/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.SharedConstantFieldProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class HostedConstantFieldProvider
extends SharedConstantFieldProvider {
    public HostedConstantFieldProvider(MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        super(metaAccess, classInitializationSupport);
    }

    @Override
    public boolean isFinalField(ResolvedJavaField f, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        HostedField field = (HostedField)f;
        if (field.location == -10) {
            return true;
        }
        if (!field.wrapped.isWritten()) {
            return true;
        }
        return super.isFinalField(field, tool);
    }

    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        ReadableJavaField readableField;
        AnalysisField f = ((HostedField)field).wrapped;
        if (f.wrapped instanceof ReadableJavaField && !(readableField = (ReadableJavaField)f.wrapped).isValueAvailable()) {
            return null;
        }
        return (T)super.readConstantField(field, tool);
    }
}

