/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.windows.SignalDispatcher;
import java.util.Hashtable;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.WordFactory;

@TargetClass(className="jdk.internal.misc.Signal")
final class Target_jdk_internal_misc_Signal {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static Hashtable<?, ?> handlers = new Hashtable(4);
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static Hashtable<?, ?> signals = new Hashtable(4);

    Target_jdk_internal_misc_Signal() {
    }

    @Alias
    static native void dispatch(int var0);

    @Substitute
    private static long handle0(int sig, long nativeH) {
        if (!SubstrateOptions.EnableSignalAPI.getValue().booleanValue()) {
            throw new IllegalArgumentException("Installing signal handlers is not enabled");
        }
        if (!Isolates.isCurrentFirst()) {
            throw new IllegalArgumentException("Only the first isolate can install signal handlers, as signal handling is global for the process.");
        }
        SignalDispatcher.ensureInitialized();
        return Jvm.JVM_RegisterSignal(sig, (VoidPointer)WordFactory.pointer((long)nativeH)).rawValue();
    }
}

