/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.Safepoint;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class CallStackFrameMethodInfo {
    protected static final int INITIAL_METHOD_ID = -1;
    private final Map<Integer, String> sampledMethods = new HashMap<Integer, String>();
    private int enterSafepointCheckId = -1;
    private int enterSafepointFromNativeId = -1;

    public void addMethodInfo(ResolvedJavaMethod method, int methodId) {
        String formattedMethod = CallStackFrameMethodInfo.formatted(method);
        this.sampledMethods.put(methodId, formattedMethod);
        if (this.enterSafepointCheckId == -1 && formattedMethod.equals(CallStackFrameMethodInfo.formatted(Safepoint.ENTER_SLOW_PATH_SAFEPOINT_CHECK))) {
            this.enterSafepointCheckId = methodId;
        }
        if (this.enterSafepointFromNativeId == -1 && formattedMethod.equals(CallStackFrameMethodInfo.formatted(Safepoint.ENTER_SLOW_PATH_TRANSITION_FROM_NATIVE_TO_NEW_STATUS))) {
            this.enterSafepointFromNativeId = methodId;
        }
    }

    protected static String formatted(ResolvedJavaMethod method) {
        return method.format("%H.%n");
    }

    protected static String formatted(SnippetRuntime.SubstrateForeignCallDescriptor descriptor) {
        return String.format("%s.%s", descriptor.getDeclaringClass().getCanonicalName(), descriptor.getName());
    }

    public String methodFor(int methodId) {
        return this.sampledMethods.get(methodId);
    }

    public boolean isSamplingCodeEntry(int methodId) {
        return this.enterSafepointCheckId == methodId || this.enterSafepointFromNativeId == methodId;
    }

    public void setEnterSamplingCodeMethodId(int i) {
        this.enterSafepointCheckId = i;
        this.enterSafepointFromNativeId = i;
    }
}

