/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.core.jfr.events.ExecutionSampleEvent;
import com.oracle.svm.core.jfr.events.ThreadEndEvent;
import com.oracle.svm.core.jfr.events.ThreadStartEvent;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class JfrThreadLocal
implements ThreadListener {
    private static final FastThreadLocalObject<Target_jdk_jfr_internal_EventWriter> javaEventWriter = FastThreadLocalFactory.createObject(Target_jdk_jfr_internal_EventWriter.class, "JfrThreadLocal.javaEventWriter");
    private static final FastThreadLocalWord<JfrBuffer> javaBuffer = FastThreadLocalFactory.createWord("JfrThreadLocal.javaBuffer");
    private static final FastThreadLocalWord<JfrBuffer> nativeBuffer = FastThreadLocalFactory.createWord("JfrThreadLocal.nativeBuffer");
    private static final FastThreadLocalWord<UnsignedWord> dataLost = FastThreadLocalFactory.createWord("JfrThreadLocal.dataLost");
    private static final FastThreadLocalLong threadId = FastThreadLocalFactory.createLong("JfrThreadLocal.threadId");
    private static final FastThreadLocalLong parentThreadId = FastThreadLocalFactory.createLong("JfrThreadLocal.parentThreadId");
    private long threadLocalBufferSize;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrThreadLocal() {
    }

    public void initialize(long bufferSize) {
        this.threadLocalBufferSize = bufferSize;
    }

    @Override
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public void beforeThreadRun(IsolateThread isolateThread, Thread javaThread) {
        Target_java_lang_Thread t = SubstrateUtil.cast(javaThread, Target_java_lang_Thread.class);
        threadId.set(isolateThread, t.getId());
        parentThreadId.set(isolateThread, JavaThreads.getParentThreadId(javaThread));
        SubstrateJVM.getThreadRepo().registerThread(javaThread);
        ThreadStartEvent.emit(isolateThread);
        ExecutionSampleEvent.tryToRegisterExecutionSampleEventCallback();
    }

    @Override
    @Uninterruptible(reason="Accesses a JFR buffer.")
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        ThreadEndEvent.emit(isolateThread);
        if (SubstrateJVM.isRecording()) {
            JfrBuffer nb;
            JfrBuffer jb = javaBuffer.get(isolateThread);
            if (jb.isNonNull()) {
                JfrThreadLocal.flush(jb, WordFactory.unsigned((int)0), 0);
            }
            if ((nb = nativeBuffer.get(isolateThread)).isNonNull()) {
                JfrThreadLocal.flush(nb, WordFactory.unsigned((int)0), 0);
            }
        }
        threadId.set(isolateThread, 0L);
        parentThreadId.set(isolateThread, 0L);
        dataLost.set(isolateThread, WordFactory.unsigned((int)0));
        javaEventWriter.set(isolateThread, null);
        JfrThreadLocal.freeBuffer(javaBuffer.get(isolateThread));
        javaBuffer.set(isolateThread, (JfrBuffer)WordFactory.nullPointer());
        JfrThreadLocal.freeBuffer(nativeBuffer.get(isolateThread));
        nativeBuffer.set(isolateThread, (JfrBuffer)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTraceId(IsolateThread isolateThread) {
        return threadId.get(isolateThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getParentThreadId(IsolateThread isolateThread) {
        return parentThreadId.get(isolateThread);
    }

    public Target_jdk_jfr_internal_EventWriter getEventWriter() {
        return javaEventWriter.get();
    }

    public Target_jdk_jfr_internal_EventWriter newEventWriter() {
        assert (javaEventWriter.get() == null);
        assert (javaBuffer.get().isNull());
        JfrBuffer buffer = this.getJavaBuffer();
        if (buffer.isNull()) {
            throw new OutOfMemoryError("OOME for thread local buffer");
        }
        assert (JfrBufferAccess.isEmpty(buffer)) : "a fresh JFR buffer must be empty";
        long startPos = buffer.getPos().rawValue();
        long maxPos = JfrBufferAccess.getDataEnd(buffer).rawValue();
        long addressOfPos = JfrBufferAccess.getAddressOfPos(buffer).rawValue();
        long jfrThreadId = SubstrateJVM.getThreadId(CurrentIsolate.getCurrentThread());
        Target_jdk_jfr_internal_EventWriter result = JavaVersionUtil.JAVA_SPEC >= 19 ? new Target_jdk_jfr_internal_EventWriter(startPos, maxPos, addressOfPos, jfrThreadId, true, false) : new Target_jdk_jfr_internal_EventWriter(startPos, maxPos, addressOfPos, jfrThreadId, true);
        javaEventWriter.set(result);
        return result;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public JfrBuffer getJavaBuffer() {
        VMError.guarantee(threadId.get() > 0L, "Thread local JFR data must be initialized");
        JfrBuffer result = javaBuffer.get();
        if (result.isNull()) {
            result = JfrBufferAccess.allocate(WordFactory.unsigned((long)this.threadLocalBufferSize), JfrBufferType.THREAD_LOCAL_JAVA);
            javaBuffer.set(result);
        }
        return result;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.", callerMustBe=true)
    public JfrBuffer getNativeBuffer() {
        VMError.guarantee(threadId.get() > 0L, "Thread local JFR data must be initialized");
        JfrBuffer result = nativeBuffer.get();
        if (result.isNull()) {
            result = JfrBufferAccess.allocate(WordFactory.unsigned((long)this.threadLocalBufferSize), JfrBufferType.THREAD_LOCAL_NATIVE);
            nativeBuffer.set(result);
        }
        return result;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.", callerMustBe=true)
    public static JfrBuffer getJavaBuffer(IsolateThread thread) {
        assert (VMOperation.isInProgressAtSafepoint());
        return javaBuffer.get(thread);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.", callerMustBe=true)
    public static JfrBuffer getNativeBuffer(IsolateThread thread) {
        assert (VMOperation.isInProgressAtSafepoint());
        return nativeBuffer.get(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void notifyEventWriter(IsolateThread thread) {
        if (javaEventWriter.get(thread) != null) {
            JfrThreadLocal.javaEventWriter.get((IsolateThread)thread).notified = true;
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public static JfrBuffer flush(JfrBuffer threadLocalBuffer, UnsignedWord uncommitted, int requested) {
        JfrGlobalMemory globalMemory;
        assert (threadLocalBuffer.isNonNull());
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(threadLocalBuffer);
        if (unflushedSize.aboveThan(0) && !(globalMemory = SubstrateJVM.getGlobalMemory()).write(threadLocalBuffer, unflushedSize)) {
            JfrBufferAccess.reinitialize(threadLocalBuffer);
            JfrThreadLocal.writeDataLoss(threadLocalBuffer, unflushedSize);
            return (JfrBuffer)WordFactory.nullPointer();
        }
        if (uncommitted.aboveThan(0)) {
            assert (JfrBufferAccess.getDataStart(threadLocalBuffer).add(uncommitted).belowOrEqual((UnsignedWord)JfrBufferAccess.getDataEnd(threadLocalBuffer)));
            UnmanagedMemoryUtil.copy(threadLocalBuffer.getPos(), JfrBufferAccess.getDataStart(threadLocalBuffer), uncommitted);
        }
        JfrBufferAccess.reinitialize(threadLocalBuffer);
        assert (JfrBufferAccess.getUnflushedSize(threadLocalBuffer).equal(0));
        if (threadLocalBuffer.getSize().aboveOrEqual(uncommitted.add(requested))) {
            return threadLocalBuffer;
        }
        return (JfrBuffer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void writeDataLoss(JfrBuffer buffer, UnsignedWord unflushedSize) {
        assert (buffer.isNonNull());
        assert (unflushedSize.aboveThan(0));
        UnsignedWord totalDataLoss = JfrThreadLocal.increaseDataLost(unflushedSize);
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.DataLoss)) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, buffer);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.DataLoss);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, unflushedSize.rawValue());
            JfrNativeEventWriter.putLong(data, totalDataLoss.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord increaseDataLost(UnsignedWord delta) {
        UnsignedWord result = dataLost.get().add(delta);
        dataLost.set(result);
        return result;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void freeBuffer(JfrBuffer buffer) {
        JfrBufferAccess.free(buffer);
    }
}

