/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.PredefinedClassesRegistry;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class PredefinedClassesConfigurationParser
extends ConfigurationParser {
    private final PredefinedClassesRegistry registry;

    public static InputStream openClassdataStream(URI baseUri, String providedHash) throws IOException {
        return PredefinedClassesConfigurationParser.openStream(PredefinedClassesConfigurationParser.resolveClassdataFile(baseUri, providedHash));
    }

    public PredefinedClassesConfigurationParser(PredefinedClassesRegistry registry, boolean strictConfiguration) {
        super(strictConfiguration);
        this.registry = registry;
    }

    private static URI resolveBaseUri(URI original) throws IOException {
        String directory = "agent-extracted-predefined-classes/";
        URI uri = original;
        try {
            if ("jar".equalsIgnoreCase(uri.getScheme())) {
                String ssp = uri.getSchemeSpecificPart();
                int sep = ssp.indexOf("!/");
                String path = ssp.substring(0, sep);
                String entry = ssp.substring(sep + 2);
                int last = entry.lastIndexOf(47);
                String subdir = entry.substring(0, last + 1) + directory;
                return new URI(uri.getScheme(), path + "!/" + subdir, uri.getFragment());
            }
            if (uri.isOpaque()) {
                throw new URISyntaxException(uri.toString(), "expecting URI with absolute path");
            }
            return uri.resolve(directory);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static URI resolveClassdataFile(URI baseUri, String providedHash) throws IOException {
        String fileName = providedHash + ".classdata";
        if ("jar".equalsIgnoreCase(baseUri.getScheme())) {
            try {
                return new URI(baseUri.getScheme(), baseUri.getSchemeSpecificPart() + fileName, baseUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return baseUri.resolve(fileName);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) throws IOException {
        URI baseUri = origin == null ? null : PredefinedClassesConfigurationParser.resolveBaseUri(origin);
        for (Object classDataOrigin : PredefinedClassesConfigurationParser.asList(json, "first level of document must be an array of predefined class origin objects")) {
            this.parseOrigin(baseUri, PredefinedClassesConfigurationParser.asMap(classDataOrigin, "second level of document must be a predefined class origin object"));
        }
    }

    private void parseOrigin(URI baseUri, Map<String, Object> data) {
        this.checkAttributes(data, "class origin descriptor object", Arrays.asList("type", "classes"));
        String type = PredefinedClassesConfigurationParser.asString(data.get("type"), "type");
        if (!type.equals("agent-extracted")) {
            throw new JSONParserException("Attribute 'type' must have value 'agent-extracted'");
        }
        for (Object clazz : PredefinedClassesConfigurationParser.asList(data.get("classes"), "Attribute 'classes' must be an array of predefined class descriptor objects")) {
            this.parseClass(baseUri, PredefinedClassesConfigurationParser.asMap(clazz, "second level of document must be a predefined class descriptor object"));
        }
    }

    private void parseClass(URI baseUri, Map<String, Object> data) {
        this.checkAttributes(data, "class descriptor object", Collections.singleton("hash"), Collections.singleton("nameInfo"));
        String hash = PredefinedClassesConfigurationParser.asString(data.get("hash"), "hash");
        String nameInfo = PredefinedClassesConfigurationParser.asNullableString(data.get("nameInfo"), "nameInfo");
        this.registry.add(nameInfo, hash, baseUri);
    }
}

