/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.util.DirectAnnotationAccess;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
public @interface Uninterruptible {
    public String reason();

    public boolean callerMustBe() default false;

    public boolean calleeMustBe() default true;

    public boolean mayBeInlined() default false;

    public static class Utils {
        public static boolean isUninterruptible(AnnotatedElement method) {
            if (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, Uninterruptible.class)) {
                return true;
            }
            CFunction cFunctionAnnotation = (CFunction)DirectAnnotationAccess.getAnnotation((AnnotatedElement)method, CFunction.class);
            InvokeCFunctionPointer cFunctionPointerAnnotation = (InvokeCFunctionPointer)DirectAnnotationAccess.getAnnotation((AnnotatedElement)method, InvokeCFunctionPointer.class);
            return cFunctionAnnotation != null && cFunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || cFunctionPointerAnnotation != null && cFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION;
        }

        public static boolean inliningAllowed(AnnotatedElement caller, AnnotatedElement callee) {
            boolean callerUninterruptible = Utils.isUninterruptible(caller);
            boolean calleeUninterruptible = Utils.isUninterruptible(callee);
            if (callerUninterruptible) {
                return calleeUninterruptible;
            }
            if (!calleeUninterruptible) {
                return true;
            }
            Uninterruptible calleeUninterruptibleAnnotation = (Uninterruptible)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)callee, Uninterruptible.class);
            return calleeUninterruptibleAnnotation != null && calleeUninterruptibleAnnotation.mayBeInlined();
        }
    }
}

