/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.svm.core.SubstrateUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import jdk.vm.ci.meta.JavaKind;

final class SignatureKey {
    final boolean isStatic;
    final Class<?>[] argTypes;
    final JavaKind returnKind;

    SignatureKey(Executable member) {
        this.isStatic = member instanceof Constructor || Modifier.isStatic(member.getModifiers());
        this.argTypes = member.getParameterTypes();
        this.returnKind = member instanceof Method ? JavaKind.fromJavaClass(((Method)member).getReturnType()) : JavaKind.Object;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != SignatureKey.class) {
            return false;
        }
        SignatureKey other = (SignatureKey)obj;
        return this.isStatic == other.isStatic && Arrays.equals(this.argTypes, other.argTypes) && Objects.equals(this.returnKind, other.returnKind);
    }

    public int hashCode() {
        return Objects.hash(this.isStatic, Arrays.hashCode(this.argTypes), this.returnKind);
    }

    public String toString() {
        StringBuilder fullName = new StringBuilder();
        fullName.append(this.isStatic);
        fullName.append("(");
        for (Class<?> c : this.argTypes) {
            fullName.append(c.getName()).append(",");
        }
        fullName.append(')');
        fullName.append(this.returnKind);
        return fullName.toString();
    }

    String uniqueShortName() {
        return SubstrateUtil.digest(this.toString());
    }
}

