/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.util.VMError;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

class ProgressReporterJsonHelper {
    protected static final long UNAVAILABLE_METRIC = -1L;
    private static final String ANALYSIS_RESULTS_KEY = "analysis_results";
    private static final String GENERAL_INFO_KEY = "general_info";
    private static final String IMAGE_DETAILS_KEY = "image_details";
    private static final String RESSOURCE_USAGE_KEY = "resource_usage";
    private final Map<String, Object> statsHolder = new HashMap<String, Object>();
    private final String jsonOutputFile;

    ProgressReporterJsonHelper(String outFile) {
        this.jsonOutputFile = outFile;
    }

    private void recordSystemFixedValues() {
        this.putResourceUsage(ResourceUsageKey.CPU_CORES_TOTAL, Runtime.getRuntime().availableProcessors());
        this.putResourceUsage(ResourceUsageKey.MEMORY_TOTAL, ProgressReporterJsonHelper.getTotalSystemMemory());
    }

    private static long getTotalSystemMemory() {
        java.lang.management.OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        return ((OperatingSystemMXBean)osMXBean).getTotalPhysicalMemorySize();
    }

    public void putAnalysisResults(AnalysisResults key, long value) {
        Map analysisMap = (Map)this.statsHolder.computeIfAbsent(ANALYSIS_RESULTS_KEY, k -> new HashMap());
        Map bucketMap = (Map)analysisMap.computeIfAbsent(key.bucket(), bk -> new HashMap());
        bucketMap.put(key.jsonKey(), value);
    }

    public void putGeneralInfo(GeneralInfo info, String value) {
        Map generalInfoMap = (Map)this.statsHolder.computeIfAbsent(GENERAL_INFO_KEY, gi -> new HashMap());
        generalInfoMap.put(info.jsonKey(), value);
    }

    public void putImageDetails(ImageDetailKey key, Object value) {
        Map imageDetailsMap = (Map)this.statsHolder.computeIfAbsent(IMAGE_DETAILS_KEY, id -> new HashMap());
        if (!key.hasBucket() && !key.hasSubBucket()) {
            imageDetailsMap.put(key.jsonKey(), value);
        } else if (!key.hasSubBucket()) {
            assert (key.hasBucket());
            Map bucketMap = (Map)imageDetailsMap.computeIfAbsent(key.bucket(), sb -> new HashMap());
            bucketMap.put(key.jsonKey(), value);
        } else {
            assert (key.hasSubBucket());
            Map bucketMap = (Map)imageDetailsMap.computeIfAbsent(key.bucket(), sb -> new HashMap());
            Map subbucketMap = (Map)bucketMap.computeIfAbsent(key.subBucket(), sb -> new HashMap());
            subbucketMap.put(key.jsonKey(), value);
        }
    }

    public void putResourceUsage(ResourceUsageKey key, Object value) {
        Map resUsageMap = (Map)this.statsHolder.computeIfAbsent(RESSOURCE_USAGE_KEY, ru -> new HashMap());
        Map subMap = (Map)resUsageMap.computeIfAbsent(key.bucket, k -> new HashMap());
        subMap.put(key.key, value);
    }

    public Path printToFile() {
        this.recordSystemFixedValues();
        File file = new File(this.jsonOutputFile);
        String description = "image statistics in json";
        return ReportUtils.report((String)description, (Path)file.getAbsoluteFile().toPath(), this.getReporter(), (boolean)false);
    }

    private Consumer<PrintWriter> getReporter() {
        return out -> out.println(this.toJson());
    }

    private String toJson() {
        return this.mapToJson(this.statsHolder);
    }

    private String mapToJson(Map<String, Object> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Iterator<String> keySetIter = map.keySet().iterator();
        while (keySetIter.hasNext()) {
            String key = keySetIter.next();
            Object value = map.get(key);
            builder.append("\"" + key + "\":");
            if (value == null) {
                builder.append("null");
            } else if (value instanceof Map) {
                Map subMap = (Map)value;
                builder.append(this.mapToJson(subMap));
            } else if (value instanceof String) {
                builder.append("\"" + value + "\"");
            } else {
                assert (value instanceof Number);
                builder.append(value);
            }
            if (!keySetIter.hasNext()) continue;
            builder.append(",");
        }
        builder.append("}");
        return builder.toString();
    }

    static enum GeneralInfo implements JsonMetric
    {
        IMAGE_NAME("name"),
        JAVA_VERSION("java_version"),
        GRAALVM_VERSION("graalvm_version"),
        GC("garbage_collector"),
        CC("c_compiler");

        private String key;

        private GeneralInfo(String key) {
            this.key = key;
        }

        public String jsonKey() {
            return this.key;
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            helper.putGeneralInfo(this, (String)value);
        }
    }

    static enum AnalysisResults implements JsonMetric
    {
        CLASS_TOTAL("classes", "total"),
        CLASS_REACHABLE("classes", "reachable"),
        CLASS_JNI("classes", "jni"),
        CLASS_REFLECT("classes", "reflection"),
        METHOD_TOTAL("methods", "total"),
        METHOD_REACHABLE("methods", "reachable"),
        METHOD_JNI("methods", "jni"),
        METHOD_REFLECT("methods", "reflection"),
        FIELD_TOTAL("fields", "total"),
        FIELD_REACHABLE("fields", "reachable"),
        FIELD_JNI("fields", "jni"),
        FIELD_REFLECT("fields", "reflection");

        private String key;
        private String bucket;

        private AnalysisResults(String bucket, String key) {
            this.key = key;
            this.bucket = bucket;
        }

        public String jsonKey() {
            return this.key;
        }

        public String bucket() {
            return this.bucket;
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            if (value instanceof Integer) {
                helper.putAnalysisResults(this, ((Integer)value).intValue());
            } else if (value instanceof Long) {
                helper.putAnalysisResults(this, (Long)value);
            } else {
                VMError.shouldNotReachHere("Imcompatible type of 'value': " + value.getClass());
            }
        }
    }

    static enum ResourceUsageKey implements JsonMetric
    {
        CPU_LOAD("cpu", "load"),
        CPU_CORES_TOTAL("cpu", "total_cores"),
        GC_COUNT("garbage_collection", "count"),
        GC_SECS("garbage_collection", "total_secs"),
        PEAK_RSS("memory", "peak_rss_bytes"),
        MEMORY_TOTAL("memory", "system_total");

        private String bucket;
        private String key;

        private ResourceUsageKey(String bucket, String key) {
            this.key = key;
            this.bucket = bucket;
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            helper.putResourceUsage(this, value);
        }
    }

    static enum ImageDetailKey implements JsonMetric
    {
        TOTAL_SIZE(null, null, "total_bytes"),
        CODE_AREA_SIZE("code_area", null, "bytes"),
        NUM_COMP_UNITS("code_area", null, "compilation_units"),
        IMAGE_HEAP_SIZE("image_heap", null, "bytes"),
        DEBUG_INFO_SIZE("debug_info", null, "bytes"),
        IMAGE_HEAP_RESOURCE_COUNT("image_heap", "resources", "count"),
        RESOURCE_SIZE_BYTES("image_heap", "resources", "bytes"),
        RUNTIME_COMPILED_METHODS_COUNT("runtime_compiled_methods", null, "count"),
        GRAPH_ENCODING_SIZE("runtime_compiled_methods", null, "graph_encoding_bytes");

        private String bucket;
        private String key;
        private String subBucket;

        private ImageDetailKey(String bucket, String subBucket, String key) {
            this.bucket = bucket;
            this.key = key;
            this.subBucket = subBucket;
        }

        public boolean hasBucket() {
            return this.bucket != null;
        }

        public boolean hasSubBucket() {
            return this.subBucket != null;
        }

        public String bucket() {
            return this.bucket;
        }

        public String subBucket() {
            return this.subBucket;
        }

        public String jsonKey() {
            return this.key;
        }

        @Override
        public void record(ProgressReporterJsonHelper helper, Object value) {
            helper.putImageDetails(this, value);
        }
    }

    static interface JsonMetric {
        public void record(ProgressReporterJsonHelper var1, Object var2);
    }
}

