/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo
public class ComputedIndirectCallTargetNode
extends LoweredCallTargetNode {
    public static final NodeClass<ComputedIndirectCallTargetNode> TYPE = NodeClass.create(ComputedIndirectCallTargetNode.class);
    @Node.Input
    protected ValueNode addressBase;
    private final Computation[] addressComputation;

    public ComputedIndirectCallTargetNode(ValueNode addressBase, Computation[] addressComputation, ValueNode[] arguments, StampPair returnStamp, JavaType[] signature, ResolvedJavaMethod target) {
        super(TYPE, arguments, returnStamp, signature, target, (CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static);
        this.addressBase = addressBase;
        this.addressComputation = addressComputation;
    }

    public ValueNode getAddressBase() {
        return this.addressBase;
    }

    public Computation[] getAddressComputation() {
        return this.addressComputation;
    }

    public String targetName() {
        return this.targetMethod() == null ? "[unknown]" : this.targetMethod().format("ComputedIndirect#%h.%n");
    }

    public static class FieldLoadIfZero
    extends Computation {
        private final JavaConstant object;
        private final ResolvedJavaField field;

        public FieldLoadIfZero(JavaConstant object, ResolvedJavaField field) {
            this.object = object;
            this.field = field;
        }

        public JavaConstant getObject() {
            return this.object;
        }

        public ResolvedJavaField getField() {
            return this.field;
        }
    }

    public static class FieldLoad
    extends Computation {
        private final ResolvedJavaField field;

        public FieldLoad(ResolvedJavaField field) {
            this.field = field;
        }

        public ResolvedJavaField getField() {
            return this.field;
        }
    }

    public static abstract class Computation {
    }
}

