/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@AutomaticallyRegisteredFeature
public final class ResourcesFeature
implements InternalFeature {
    static final String MODULE_NAME_ALL_UNNAMED = "ALL-UNNAMED";
    private boolean sealed = false;
    private final Set<String> resourcePatternWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> excludedResourcePatterns = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;
    private ImageClassLoader imageClassLoader;
    public final Set<String> includedResourcesModules = new HashSet<String>();

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
        ResourcesRegistryImpl resourcesRegistry = new ResourcesRegistryImpl(new ConfigurationTypeResolver("resource configuration", this.imageClassLoader));
        ImageSingletons.add(ResourcesRegistry.class, (Object)resourcesRegistry);
        ImageSingletons.add(RuntimeResourceSupport.class, (Object)resourcesRegistry);
    }

    private static ResourcesRegistryImpl resourceRegistryImpl() {
        return (ResourcesRegistryImpl)ImageSingletons.lookup(ResourcesRegistry.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ResourceConfigurationParser parser = new ResourceConfigurationParser((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, this.imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, ConfigurationFile.RESOURCES.getFileName());
        this.resourcePatternWorkSet.addAll(Options.IncludeResources.getValue().values());
        this.excludedResourcePatterns.addAll(Options.ExcludeResources.getValue().values());
        ResourcesFeature.resourceRegistryImpl().flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        ResourcesFeature.resourceRegistryImpl().flushConditionalConfiguration(access);
        if (this.resourcePatternWorkSet.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        ResourcePattern[] includePatterns = this.compilePatterns(this.resourcePatternWorkSet);
        ResourcePattern[] excludePatterns = this.compilePatterns(this.excludedResourcePatterns);
        DebugContext debugContext = ((FeatureImpl.DuringAnalysisAccessImpl)access).getDebugContext();
        ResourceCollectorImpl collector = new ResourceCollectorImpl(debugContext, includePatterns, excludePatterns, this.includedResourcesModules);
        ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).collectResources(collector);
        this.resourcePatternWorkSet.clear();
    }

    private ResourcePattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(this::makeResourcePattern).collect(Collectors.toList()).toArray(new ResourcePattern[0]);
    }

    private ResourcePattern makeResourcePattern(String rawPattern) {
        boolean acceptModuleName;
        String[] moduleNameWithPattern = SubstrateUtil.split(rawPattern, ":", 2);
        if (moduleNameWithPattern.length < 2) {
            return new ResourcePattern(null, Pattern.compile(moduleNameWithPattern[0]));
        }
        String moduleName = moduleNameWithPattern[0];
        boolean bl = acceptModuleName = MODULE_NAME_ALL_UNNAMED.equals(moduleName) ? true : this.imageClassLoader.findModule(moduleName).isPresent();
        if (acceptModuleName) {
            return new ResourcePattern(moduleName, Pattern.compile(moduleNameWithPattern[1]));
        }
        throw UserError.abort("Resource pattern \"" + rawPattern + "\"s specifies unknown module " + moduleName, new Object[0]);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    private static void registerResource(DebugContext debugContext, String moduleName, String resourceName, InputStream resourceStream, boolean fromJar) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            Object moduleNamePrefix = moduleName == null ? "" : moduleName + ":";
            debugContext.log(3, "ResourcesFeature: registerResource: %s%s", moduleNamePrefix, (Object)resourceName);
            Resources.registerResource(moduleName, resourceName, resourceStream, fromJar);
        }
    }

    private static void registerDirectoryResource(DebugContext debugContext, String moduleName, String dir, String content, boolean fromJar) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            Object moduleNamePrefix = moduleName == null ? "" : moduleName + ":";
            debugContext.log(3, "ResourcesFeature: registerResource: %s%s", moduleNamePrefix, (Object)moduleName, (Object)dir);
            Resources.registerDirectoryResource(moduleName, dir, content, fromJar);
        }
    }

    private static final class ResourcePattern {
        final String moduleName;
        final Pattern pattern;

        private ResourcePattern(String moduleName, Pattern pattern) {
            this.moduleName = moduleName;
            this.pattern = pattern;
        }

        boolean moduleNameMatches(String resourceContainerModuleName) {
            if (this.moduleName == null) {
                return true;
            }
            if (this.moduleName.equals(ResourcesFeature.MODULE_NAME_ALL_UNNAMED)) {
                return resourceContainerModuleName == null;
            }
            return this.moduleName.equals(resourceContainerModuleName);
        }
    }

    private static final class ResourceCollectorImpl
    implements ClassLoaderSupport.ResourceCollector {
        private final DebugContext debugContext;
        private final ResourcePattern[] includePatterns;
        private final ResourcePattern[] excludePatterns;
        private final Set<String> includedResourcesModules;

        private ResourceCollectorImpl(DebugContext debugContext, ResourcePattern[] includePatterns, ResourcePattern[] excludePatterns, Set<String> includedResourcesModules) {
            this.debugContext = debugContext;
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
            this.includedResourcesModules = includedResourcesModules;
        }

        @Override
        public boolean isIncluded(String moduleName, String resourceName) {
            String relativePathWithTrailingSlash = resourceName + "/";
            for (ResourcePattern rp : this.excludePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return false;
            }
            for (ResourcePattern rp : this.includePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addResource(String moduleName, String resourceName, InputStream resourceStream, boolean fromJar) {
            this.collectModuleName(moduleName);
            ResourcesFeature.registerResource(this.debugContext, moduleName, resourceName, resourceStream, fromJar);
        }

        @Override
        public void addDirectoryResource(String moduleName, String dir, String content, boolean fromJar) {
            this.collectModuleName(moduleName);
            ResourcesFeature.registerDirectoryResource(this.debugContext, moduleName, dir, content, fromJar);
        }

        private void collectModuleName(String moduleName) {
            if (moduleName != null) {
                this.includedResourcesModules.add(moduleName);
            }
        }
    }

    private class ResourcesRegistryImpl
    extends ConditionalConfigurationRegistry
    implements ResourcesRegistry {
        private final ConfigurationTypeResolver configurationTypeResolver;

        ResourcesRegistryImpl(ConfigurationTypeResolver configurationTypeResolver) {
            this.configurationTypeResolver = configurationTypeResolver;
        }

        @Override
        public void addResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources added too late: %s", pattern);
                ResourcesFeature.this.resourcePatternWorkSet.add(pattern);
            });
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent) {
            String moduleName = module.isNamed() ? module.getName() : null;
            Resources.registerResource(moduleName, resourcePath, resourceContent);
        }

        @Override
        public void ignoreResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
                ResourcesFeature.this.excludedResourcePatterns.add(pattern);
            });
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String name) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(name));
        }

        @Override
        public void addClassBasedResourceBundle(ConfigurationCondition condition, String basename, String className) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareClassResourceBundle(basename, className));
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(basename, locales));
        }
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    }
}

