/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrConstantPool;
import com.oracle.svm.core.jfr.JfrGCName;
import com.oracle.svm.core.jfr.JfrGCNames;
import com.oracle.svm.core.jfr.JfrSymbolRepository;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrTypeRepository
implements JfrConstantPool {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrTypeRepository() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getClassId(Class<?> clazz) {
        return JfrTraceId.load(clazz);
    }

    @Override
    public int write(JfrChunkWriter writer) {
        TypeInfo typeInfo = this.collectTypeInfo();
        int count = this.writeClasses(writer, typeInfo);
        count += JfrTypeRepository.writePackages(writer, typeInfo);
        count += JfrTypeRepository.writeModules(writer, typeInfo);
        count += JfrTypeRepository.writeClassLoaders(writer, typeInfo);
        count += JfrTypeRepository.writeGCCauses(writer);
        count += JfrTypeRepository.writeGCNames(writer);
        return count += JfrTypeRepository.writeVMOperations(writer);
    }

    private TypeInfo collectTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        for (Class<?> clazz : Heap.getHeap().getLoadedClasses()) {
            if (!JfrTraceId.isUsedPreviousEpoch(clazz)) continue;
            JfrTraceId.clearUsedPreviousEpoch(clazz);
            this.visitClass(typeInfo, clazz);
        }
        return typeInfo;
    }

    private void visitClass(TypeInfo typeInfo, Class<?> clazz) {
        if (clazz != null && typeInfo.addClass(clazz)) {
            this.visitPackage(typeInfo, clazz.getPackage(), clazz.getModule());
            this.visitClass(typeInfo, clazz.getSuperclass());
        }
    }

    private void visitPackage(TypeInfo typeInfo, Package pkg, Module module) {
        if (pkg != null && typeInfo.addPackage(pkg, module)) {
            this.visitModule(typeInfo, module);
        }
    }

    private void visitModule(TypeInfo typeInfo, Module module) {
        if (module != null && typeInfo.addModule(module)) {
            this.visitClassLoader(typeInfo, module.getClassLoader());
        }
    }

    private void visitClassLoader(TypeInfo typeInfo, ClassLoader classLoader) {
        if (classLoader != null && typeInfo.addClassLoader(classLoader)) {
            this.visitClass(typeInfo, classLoader.getClass());
        }
    }

    public int writeClasses(JfrChunkWriter writer, TypeInfo typeInfo) {
        if (typeInfo.getClasses().isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Class.getId());
        writer.writeCompressedInt(typeInfo.getClasses().size());
        for (Class<?> clazz : typeInfo.getClasses()) {
            JfrTypeRepository.writeClass(writer, typeInfo, clazz);
        }
        return 1;
    }

    private static void writeClass(JfrChunkWriter writer, TypeInfo typeInfo, Class<?> clazz) {
        JfrSymbolRepository symbolRepo = SubstrateJVM.getSymbolRepository();
        writer.writeCompressedLong(JfrTraceId.getTraceId(clazz));
        writer.writeCompressedLong(typeInfo.getClassLoaderId(clazz.getClassLoader()));
        writer.writeCompressedLong(symbolRepo.getSymbolId(clazz.getName(), true, true));
        writer.writeCompressedLong(typeInfo.getPackageId(clazz.getPackage()));
        writer.writeCompressedLong(clazz.getModifiers());
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            writer.writeBoolean(SubstrateUtil.isHiddenClass(clazz));
        }
    }

    private static int writePackages(JfrChunkWriter writer, TypeInfo typeInfo) {
        Map<String, PackageInfo> packages = typeInfo.getPackages();
        if (packages.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Package.getId());
        writer.writeCompressedInt(packages.size());
        for (Map.Entry<String, PackageInfo> pkgInfo : packages.entrySet()) {
            JfrTypeRepository.writePackage(writer, typeInfo, pkgInfo.getKey(), pkgInfo.getValue());
        }
        return 1;
    }

    private static void writePackage(JfrChunkWriter writer, TypeInfo typeInfo, String pkgName, PackageInfo pkgInfo) {
        JfrSymbolRepository symbolRepo = SubstrateJVM.getSymbolRepository();
        writer.writeCompressedLong(pkgInfo.id);
        writer.writeCompressedLong(symbolRepo.getSymbolId(pkgName, true, true));
        writer.writeCompressedLong(typeInfo.getModuleId(pkgInfo.module));
        writer.writeBoolean(false);
    }

    private static int writeModules(JfrChunkWriter writer, TypeInfo typeInfo) {
        Map<Module, Long> modules = typeInfo.getModules();
        if (modules.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.Module.getId());
        writer.writeCompressedInt(modules.size());
        for (Map.Entry<Module, Long> modInfo : modules.entrySet()) {
            JfrTypeRepository.writeModule(writer, typeInfo, modInfo.getKey(), modInfo.getValue());
        }
        return 1;
    }

    private static void writeModule(JfrChunkWriter writer, TypeInfo typeInfo, Module module, long id) {
        JfrSymbolRepository symbolRepo = SubstrateJVM.getSymbolRepository();
        writer.writeCompressedLong(id);
        writer.writeCompressedLong(symbolRepo.getSymbolId(module.getName(), true));
        writer.writeCompressedLong(0L);
        writer.writeCompressedLong(0L);
        writer.writeCompressedLong(typeInfo.getClassLoaderId(module.getClassLoader()));
    }

    private static int writeClassLoaders(JfrChunkWriter writer, TypeInfo typeInfo) {
        Map<ClassLoader, Long> classLoaders = typeInfo.getClassLoaders();
        if (classLoaders.isEmpty()) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.ClassLoader.getId());
        writer.writeCompressedInt(classLoaders.size());
        for (Map.Entry<ClassLoader, Long> clInfo : classLoaders.entrySet()) {
            JfrTypeRepository.writeClassLoader(writer, clInfo.getKey(), clInfo.getValue());
        }
        return 1;
    }

    private static int writeGCCauses(JfrChunkWriter writer) {
        GCCause[] causes = GCCause.getGCCauses();
        int nonNullItems = 0;
        for (int index = 0; index < causes.length; ++index) {
            if (causes[index] == null) continue;
            ++nonNullItems;
        }
        assert (nonNullItems > 0);
        writer.writeCompressedLong(JfrType.GCCause.getId());
        writer.writeCompressedLong(nonNullItems);
        for (GCCause cause : causes) {
            if (cause == null) continue;
            writer.writeCompressedLong(cause.getId());
            writer.writeString(cause.getName());
        }
        return 1;
    }

    private static int writeGCNames(JfrChunkWriter writer) {
        JfrGCName[] gcNames = JfrGCNames.singleton().getNames();
        assert (gcNames != null && gcNames.length > 0);
        writer.writeCompressedLong(JfrType.GCName.getId());
        writer.writeCompressedLong(gcNames.length);
        for (JfrGCName name : gcNames) {
            writer.writeCompressedLong(name.getId());
            writer.writeString(name.getName());
        }
        return 1;
    }

    private static int writeVMOperations(JfrChunkWriter writer) {
        String[] vmOperationNames = VMOperationInfos.getNames();
        assert (vmOperationNames.length > 0);
        writer.writeCompressedLong(JfrType.VMOperation.getId());
        writer.writeCompressedLong(vmOperationNames.length);
        for (int id = 0; id < vmOperationNames.length; ++id) {
            writer.writeCompressedLong(id + 1);
            writer.writeString(vmOperationNames[id]);
        }
        return 1;
    }

    private static void writeClassLoader(JfrChunkWriter writer, ClassLoader cl, long id) {
        JfrSymbolRepository symbolRepo = SubstrateJVM.getSymbolRepository();
        writer.writeCompressedLong(id);
        if (cl == null) {
            writer.writeCompressedLong(0L);
            writer.writeCompressedLong(symbolRepo.getSymbolId("bootstrap", true));
        } else {
            writer.writeCompressedLong(JfrTraceId.getTraceId(cl.getClass()));
            writer.writeCompressedLong(symbolRepo.getSymbolId(cl.getName(), true));
        }
    }

    private static class TypeInfo {
        private final Set<Class<?>> classes = new HashSet();
        private final Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
        private final Map<Module, Long> modules = new HashMap<Module, Long>();
        private final Map<ClassLoader, Long> classLoaders = new HashMap<ClassLoader, Long>();
        private long currentPackageId = 0L;
        private long currentModuleId = 0L;
        private long currentClassLoaderId = 0L;

        private TypeInfo() {
        }

        boolean addClass(Class<?> clazz) {
            return this.classes.add(clazz);
        }

        Set<Class<?>> getClasses() {
            return this.classes;
        }

        boolean addPackage(Package pkg, Module module) {
            if (!this.packages.containsKey(pkg.getName())) {
                long id = pkg.getName().isEmpty() ? 0L : (this.currentPackageId = this.currentPackageId + 1L);
                this.packages.put(pkg.getName(), new PackageInfo(id, module));
                return true;
            }
            assert (module == this.packages.get((Object)pkg.getName()).module);
            return false;
        }

        Map<String, PackageInfo> getPackages() {
            return this.packages;
        }

        long getPackageId(Package pkg) {
            if (pkg != null) {
                return this.packages.get((Object)pkg.getName()).id;
            }
            return 0L;
        }

        boolean addModule(Module module) {
            if (!this.modules.containsKey(module)) {
                this.modules.put(module, ++this.currentModuleId);
                return true;
            }
            return false;
        }

        Map<Module, Long> getModules() {
            return this.modules;
        }

        long getModuleId(Module module) {
            if (module != null) {
                return this.modules.get(module);
            }
            return 0L;
        }

        boolean addClassLoader(ClassLoader classLoader) {
            if (!this.classLoaders.containsKey(classLoader)) {
                this.classLoaders.put(classLoader, ++this.currentClassLoaderId);
                return true;
            }
            return false;
        }

        Map<ClassLoader, Long> getClassLoaders() {
            return this.classLoaders;
        }

        long getClassLoaderId(ClassLoader classLoader) {
            if (classLoader != null) {
                return this.classLoaders.get(classLoader);
            }
            return 0L;
        }
    }

    private static class PackageInfo {
        private final long id;
        private final Module module;

        PackageInfo(long id, Module module) {
            this.id = id;
            this.module = module;
        }
    }
}

