/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk17;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Objects;

@AutomaticallyRegisteredImageSingleton(value={RecordSupport.class}, onlyWith={JDK17OrLater.class})
final class RecordSupportJDK17OrLater
extends RecordSupport {
    RecordSupportJDK17OrLater() {
    }

    @Override
    public boolean isRecord(Class<?> clazz) {
        return clazz.isRecord();
    }

    @Override
    public Object[] getRecordComponents(Class<?> clazz) {
        return clazz.getRecordComponents();
    }

    @Override
    public Method[] getRecordComponentAccessorMethods(Class<?> clazz) {
        return (Method[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getAccessor).filter(Objects::nonNull).toArray(Method[]::new);
    }

    @Override
    public Constructor<?> getCanonicalRecordConstructor(Class<?> clazz) {
        Class[] paramTypes = (Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            Constructor<?> ctr = clazz.getDeclaredConstructor(paramTypes);
            ctr.setAccessible(true);
            return ctr;
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere("Malformed record class that does not declare a canonical constructor: " + clazz.getTypeName());
        }
    }
}

