/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.CompressibleConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

@NodeInfo(nameTemplate="{p#op/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class SubstrateCompressionNode
extends CompressionNode {
    public static final NodeClass<SubstrateCompressionNode> TYPE = NodeClass.create(SubstrateCompressionNode.class);

    public SubstrateCompressionNode(CompressionNode.CompressionOp op, ValueNode input, CompressEncoding encoding) {
        super(TYPE, op, input, SubstrateNarrowOopStamp.mkStamp(op, input.stamp(NodeView.DEFAULT), encoding), encoding);
    }

    public static SubstrateCompressionNode compress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return (SubstrateCompressionNode)graph.unique((Node)SubstrateCompressionNode.compress(input, encoding));
    }

    public static SubstrateCompressionNode uncompress(StructuredGraph graph, ValueNode input, CompressEncoding encoding) {
        return (SubstrateCompressionNode)graph.unique((Node)SubstrateCompressionNode.uncompress(input, encoding));
    }

    private static SubstrateCompressionNode compress(ValueNode input, CompressEncoding encoding) {
        return new SubstrateCompressionNode(CompressionNode.CompressionOp.Compress, input, encoding);
    }

    private static SubstrateCompressionNode uncompress(ValueNode input, CompressEncoding encoding) {
        return new SubstrateCompressionNode(CompressionNode.CompressionOp.Uncompress, input, encoding);
    }

    public JavaConstant nullConstant() {
        return this.op == CompressionNode.CompressionOp.Uncompress ? CompressedNullConstant.COMPRESSED_NULL : JavaConstant.NULL_POINTER;
    }

    protected Constant compress(Constant c) {
        if (JavaConstant.NULL_POINTER.equals(c)) {
            return CompressedNullConstant.COMPRESSED_NULL;
        }
        if (c instanceof CompressibleConstant) {
            return ((CompressibleConstant)c).compress();
        }
        throw GraalError.shouldNotReachHere((String)("invalid constant input for compress op: " + c));
    }

    protected Constant uncompress(Constant c) {
        if (c instanceof CompressibleConstant) {
            return ((CompressibleConstant)c).uncompress();
        }
        throw GraalError.shouldNotReachHere((String)("invalid constant input for uncompress op: " + c));
    }

    public ValueNode reverse(ValueNode input) {
        switch (this.op) {
            case Compress: {
                return SubstrateCompressionNode.uncompress(input, this.encoding);
            }
            case Uncompress: {
                return SubstrateCompressionNode.compress(input, this.encoding);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    protected Stamp mkStamp(Stamp input) {
        return SubstrateNarrowOopStamp.mkStamp(this.op, input, this.encoding);
    }

    public boolean mayNullCheckSkipConversion() {
        return false;
    }
}

