/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtracter;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.meta.InternalRuntimeReflectionSupport;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.util.GuardedAnnotationAccess;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import sun.reflect.annotation.ExceptionProxy;

public class ReflectionDataBuilder
extends ConditionalConfigurationRegistry
implements InternalRuntimeReflectionSupport {
    private final Set<Class<?>> modifiedClasses = ConcurrentHashMap.newKeySet();
    private boolean sealed;
    private final Set<Class<?>> reflectionClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Class<?>> unsafeInstantiatedClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Executable, ExecutableAccessibility> reflectionMethods = new ConcurrentHashMap<Executable, ExecutableAccessibility>();
    private final Map<Executable, Object> methodAccessors = new ConcurrentHashMap<Executable, Object>();
    private final Set<Field> reflectionFields = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnalysisField> hidingFields = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> hidingMethods = ConcurrentHashMap.newKeySet();
    private final Set<Executable> registeredMethods = ConcurrentHashMap.newKeySet();
    private final Set<Field> registeredFields = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, Object[]> registeredRecordComponents = new ConcurrentHashMap();
    private final Set<DynamicHub> heapDynamicHubs = ConcurrentHashMap.newKeySet();
    private final Set<AccessibleObject> heapReflectionObjects = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, Set<Class<?>>> innerClasses = new ConcurrentHashMap();
    private final Set<Class<?>> processedClasses = new HashSet();
    private final Set<Type> processedTypes = new HashSet<Type>();
    private final Set<DynamicHub> processedDynamicHubs = new HashSet<DynamicHub>();
    private final Map<AnalysisField, Set<AnalysisType>> processedHidingFields = new HashMap<AnalysisField, Set<AnalysisType>>();
    private final Map<AnalysisMethod, Set<AnalysisType>> processedHidingMethods = new HashMap<AnalysisMethod, Set<AnalysisType>>();
    private final Set<AccessibleObject> processedHeapReflectionObjects = new HashSet<AccessibleObject>();
    private final Map<Class<?>, Set<Member>> annotationMembers = new HashMap();
    private final Map<AnnotatedElement, AnnotationValue[]> filteredAnnotations = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<AnalysisMethod, AnnotationValue[][]> filteredParameterAnnotations = new ConcurrentHashMap<AnalysisMethod, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> filteredTypeAnnotations = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final SubstrateAnnotationExtracter annotationExtracter;
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];

    ReflectionDataBuilder(SubstrateAnnotationExtracter annotationExtracter) {
        this.annotationExtracter = annotationExtracter;
    }

    public void register(ConfigurationCondition condition, boolean unsafeInstantiated, Class<?> clazz) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> {
            if (unsafeInstantiated) {
                this.unsafeInstantiatedClasses.add(clazz);
            }
            if (this.reflectionClasses.add(clazz)) {
                this.modifiedClasses.add(clazz);
            }
        });
    }

    public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... methods) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerMethods(queriedOnly, methods));
    }

    private void registerMethods(boolean queriedOnly, Executable[] methods) {
        for (Executable method : methods) {
            ExecutableAccessibility newValue;
            ExecutableAccessibility oldValue;
            do {
                newValue = queriedOnly ? ExecutableAccessibility.QueriedOnly : ExecutableAccessibility.Accessed;
                oldValue = this.reflectionMethods.get(method);
                if (oldValue == null) continue;
                newValue = ExecutableAccessibility.max(oldValue, newValue);
            } while (oldValue != null ? !this.reflectionMethods.replace(method, oldValue, newValue) : this.reflectionMethods.putIfAbsent(method, newValue) != null);
            if (oldValue == newValue) continue;
            this.modifiedClasses.add(method.getDeclaringClass());
        }
    }

    public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
        this.checkNotSealed();
        this.registerConditionalConfiguration(condition, () -> this.registerFields(fields));
    }

    private void registerFields(Field[] fields) {
        for (Field field : fields) {
            if (!this.reflectionFields.add(field)) continue;
            this.modifiedClasses.add(field.getDeclaringClass());
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw UserError.abort("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
        }
    }

    protected void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.processReachableTypes(access);
        this.processRegisteredElements(access);
        this.processMethodMetadata(access);
    }

    private void processReachableTypes(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (AnalysisType type : access.getUniverse().getTypes()) {
            Class originalClass = type.getJavaClass();
            if (originalClass == null || this.processedClasses.contains(originalClass) || type.isArray() && !access.isReachable(type)) continue;
            if (type.isArray() || ReflectionDataBuilder.enclosingMethodOrConstructor(originalClass, null) != null) {
                this.processClass(access, originalClass);
                this.processedClasses.add(originalClass);
                access.requireAnalysisIteration();
            }
            if (!(type.getWrappedWithoutResolve() instanceof AnnotationSubstitutionType)) continue;
            ResolvedJavaType annotationType = ((AnnotationSubstitutionType)type.getWrappedWithoutResolve()).getAnnotationInterfaceType();
            Class annotationClass = access.getUniverse().lookup((JavaType)annotationType).getJavaClass();
            if (!this.annotationMembers.containsKey(annotationClass)) {
                this.processClass(access, annotationClass);
            }
            for (Member member : this.annotationMembers.get(annotationClass)) {
                try {
                    if (member instanceof Field) {
                        Field field = (Field)member;
                        this.register(ConfigurationCondition.alwaysTrue(), false, originalClass.getDeclaredField(field.getName()));
                        continue;
                    }
                    if (!(member instanceof Method)) continue;
                    Method method = (Method)member;
                    this.register(ConfigurationCondition.alwaysTrue(), false, originalClass.getDeclaredMethod(method.getName(), method.getParameterTypes()));
                }
                catch (NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {}
            }
        }
    }

    protected void processMethodMetadata(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (DynamicHub hub : this.heapDynamicHubs) {
            AnalysisType type;
            if (this.processedDynamicHubs.contains(hub) || SubstitutionReflectivityFilter.shouldExclude((type = access.getHostVM().lookupType(hub)).getJavaClass(), access.getMetaAccess(), access.getUniverse())) continue;
            this.registerTypesForClass(access, type, type.getJavaClass());
            this.processedDynamicHubs.add(hub);
        }
        for (Field reflectField : this.reflectionFields) {
            if (this.registeredFields.contains(reflectField) || SubstitutionReflectivityFilter.shouldExclude(reflectField, access.getMetaAccess(), access.getUniverse())) continue;
            AnalysisField analysisField = access.getMetaAccess().lookupJavaField(reflectField);
            this.registerTypesForField(access, analysisField, reflectField);
            this.registerHidingSubTypeFields(access, analysisField, analysisField.getDeclaringClass());
            this.registeredFields.add(reflectField);
        }
        for (Executable method : this.reflectionMethods.keySet()) {
            SubstrateAccessor accessor;
            if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            if (!this.registeredMethods.contains(method)) {
                AnalysisMethod analysisMethod = access.getMetaAccess().lookupJavaMethod(method);
                this.registerTypesForMethod(access, analysisMethod, method);
                this.registerHidingSubTypeMethods(access, analysisMethod, analysisMethod.getDeclaringClass());
                this.registeredMethods.add(method);
            }
            if (this.reflectionMethods.get(method) != ExecutableAccessibility.Accessed || this.methodAccessors.putIfAbsent(method, accessor = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(method)) != null) continue;
            access.rescanObject(accessor);
        }
        for (AccessibleObject object : this.heapReflectionObjects) {
            Executable executable;
            if (this.processedHeapReflectionObjects.contains(object)) continue;
            if (object instanceof Field) {
                Field field = (Field)object;
                if (!SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) {
                    AnalysisField analysisField = access.getMetaAccess().lookupJavaField(field);
                    this.registerTypesForField(access, analysisField, field);
                    this.registerHidingSubTypeFields(access, analysisField, analysisField.getDeclaringClass());
                }
            } else if (object instanceof Executable && !SubstitutionReflectivityFilter.shouldExclude(executable = (Executable)object, access.getMetaAccess(), access.getUniverse())) {
                AnalysisMethod analysisMethod = access.getMetaAccess().lookupJavaMethod(executable);
                this.registerTypesForMethod(access, analysisMethod, executable);
                this.registerHidingSubTypeMethods(access, analysisMethod, analysisMethod.getDeclaringClass());
            }
            this.processedHeapReflectionObjects.add(object);
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            for (AnalysisField field : access.getUniverse().getFields()) {
                if (!field.isAccessed()) continue;
                ReflectionDataBuilder.registerTypesForReachableField(access, field);
            }
            for (Executable method : access.getUniverse().getMethods()) {
                if (!method.isReachable() || method.isIntrinsicMethod()) continue;
                ReflectionDataBuilder.registerTypesForReachableMethod(access, (AnalysisMethod)method);
            }
        }
    }

    private void registerHidingSubTypeFields(Feature.DuringAnalysisAccess access, AnalysisField field, AnalysisType type) {
        if (!(type.equals((Object)field.getDeclaringClass()) || !type.isReachable() || this.processedHidingFields.containsKey(field) && this.processedHidingFields.get(field).contains(type))) {
            this.processedHidingFields.computeIfAbsent(field, m -> ConcurrentHashMap.newKeySet()).add(type);
            try {
                AnalysisField[] subClassFields;
                for (AnalysisField subclassField : subClassFields = field.isStatic() ? type.getStaticFields() : type.getInstanceFields(false)) {
                    if (!subclassField.getName().equals(field.getName())) continue;
                    this.hidingFields.add(subclassField);
                }
                access.requireAnalysisIteration();
            }
            catch (UnsupportedFeatureException | LinkageError throwable) {
                // empty catch block
            }
        }
        for (AnalysisType subType : type.getSubTypes()) {
            if (subType.equals((Object)type)) continue;
            this.registerHidingSubTypeFields(access, field, subType);
        }
    }

    private void registerHidingSubTypeMethods(Feature.DuringAnalysisAccess access, AnalysisMethod method, AnalysisType type) {
        if (!(type.equals((Object)method.getDeclaringClass()) || !type.isReachable() || this.processedHidingMethods.containsKey(method) && this.processedHidingMethods.get(method).contains(type))) {
            this.processedHidingMethods.computeIfAbsent(method, m -> ConcurrentHashMap.newKeySet()).add(type);
            try {
                AnalysisMethod subClassMethod = type.findMethod(method.getName(), (Signature)method.getSignature());
                if (subClassMethod != null) {
                    this.hidingMethods.add(subClassMethod);
                }
                access.requireAnalysisIteration();
            }
            catch (UnsupportedFeatureException | LinkageError throwable) {
                // empty catch block
            }
        }
        for (AnalysisType subType : type.getSubTypes()) {
            if (subType.equals((Object)type)) continue;
            this.registerHidingSubTypeMethods(access, method, subType);
        }
    }

    private void registerTypesForClass(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType analysisType, Class<?> clazz) {
        Object[] recordComponents;
        Executable enclosingMethod;
        this.makeTypeReachable(access, ReflectionDataBuilder.query(clazz::getGenericSuperclass, null));
        Type[] genericInterfaces = ReflectionDataBuilder.query(clazz::getGenericInterfaces, null);
        if (genericInterfaces != null) {
            for (Type genericInterface : genericInterfaces) {
                try {
                    this.makeTypeReachable(access, genericInterface);
                }
                catch (LinkageError | TypeNotPresentException throwable) {
                    // empty catch block
                }
            }
        }
        if ((enclosingMethod = ReflectionDataBuilder.enclosingMethodOrConstructor(clazz, null)) != null) {
            ReflectionDataBuilder.makeAnalysisTypeReachable(access, access.getMetaAccess().lookupJavaType(enclosingMethod.getDeclaringClass()));
            RuntimeReflection.registerAsQueried((Executable[])new Executable[]{enclosingMethod});
        }
        if ((recordComponents = this.buildRecordComponents(clazz, access)) != null) {
            for (Object recordComponent : recordComponents) {
                this.registerTypesForRecordComponent(access, recordComponent);
            }
            this.registeredRecordComponents.put(clazz, recordComponents);
        }
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisType);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisType);
    }

    private void registerTypesForField(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisField analysisField, Field reflectField) {
        if (!analysisField.isUnsafeAccessed() && !GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)analysisField, InjectAccessors.class)) {
            analysisField.registerAsAccessed();
            analysisField.registerAsUnsafeAccessed();
        }
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisField.getDeclaringClass());
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisField.getType());
        this.makeTypeReachable(access, reflectField.getGenericType());
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisField);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisField);
    }

    private void registerTypesForMethod(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod analysisMethod, Executable reflectMethod) {
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisMethod.getDeclaringClass());
        for (TypeVariable<?> type : reflectMethod.getTypeParameters()) {
            this.makeTypeReachable(access, type);
        }
        for (Type paramType : analysisMethod.getGenericParameterTypes()) {
            this.makeTypeReachable(access, paramType);
        }
        if (!analysisMethod.isConstructor()) {
            this.makeTypeReachable(access, ((Method)reflectMethod).getGenericReturnType());
        }
        for (Type exceptionType : reflectMethod.getGenericExceptionTypes()) {
            this.makeTypeReachable(access, exceptionType);
        }
        this.registerTypesForAnnotations(access, (AnnotatedElement)analysisMethod);
        this.registerTypesForParameterAnnotations(access, analysisMethod);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)analysisMethod);
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForAnnotationDefault(access, analysisMethod);
        }
    }

    private static void registerTypesForReachableField(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisField analysisField) {
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisField.getDeclaringClass());
    }

    private static void registerTypesForReachableMethod(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod analysisMethod) {
        ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisMethod.getDeclaringClass());
        for (JavaType paramType : analysisMethod.toParameterTypes()) {
            ReflectionDataBuilder.makeAnalysisTypeReachable(access, (AnalysisType)paramType);
        }
    }

    private void makeTypeReachable(FeatureImpl.DuringAnalysisAccessImpl access, Type type) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            try {
                                if (type == null || this.processedTypes.contains(type)) {
                                    return;
                                }
                            }
                            catch (TypeNotPresentException e) {
                                return;
                            }
                            this.processedTypes.add(type);
                            if (!(type instanceof Class) || SubstitutionReflectivityFilter.shouldExclude((Class)type, access.getMetaAccess(), access.getUniverse())) break block8;
                            Class clazz = (Class)type;
                            ReflectionDataBuilder.makeAnalysisTypeReachable(access, access.getMetaAccess().lookupJavaType(clazz));
                            if (ClassForNameSupport.forNameOrNull(clazz.getName(), null) == null) {
                                access.requireAnalysisIteration();
                            }
                            ClassForNameSupport.registerClass(clazz);
                            break block9;
                        }
                        if (!(type instanceof TypeVariable)) break block10;
                        for (Type bound : ((TypeVariable)type).getBounds()) {
                            this.makeTypeReachable(access, bound);
                        }
                        break block9;
                    }
                    if (!(type instanceof GenericArrayType)) break block11;
                    this.makeTypeReachable(access, ((GenericArrayType)type).getGenericComponentType());
                    break block9;
                }
                if (!(type instanceof ParameterizedType)) break block12;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (Type actualType : parameterizedType.getActualTypeArguments()) {
                    this.makeTypeReachable(access, actualType);
                }
                this.makeTypeReachable(access, parameterizedType.getRawType());
                this.makeTypeReachable(access, parameterizedType.getOwnerType());
                break block9;
            }
            if (!(type instanceof WildcardType)) break block9;
            WildcardType wildcardType = (WildcardType)type;
            for (Type lowerBound : wildcardType.getLowerBounds()) {
                this.makeTypeReachable(access, lowerBound);
            }
            for (Type upperBound : wildcardType.getUpperBounds()) {
                this.makeTypeReachable(access, upperBound);
            }
        }
    }

    private void registerTypesForRecordComponent(FeatureImpl.DuringAnalysisAccessImpl access, Object recordComponent) {
        this.registerTypesForAnnotations(access, (AnnotatedElement)recordComponent);
        this.registerTypesForTypeAnnotations(access, (AnnotatedElement)recordComponent);
    }

    private void registerTypesForAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            this.filteredAnnotations.computeIfAbsent(annotatedElement, element -> {
                ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                for (AnnotationValue annotation : this.annotationExtracter.getDeclaredAnnotationData((AnnotatedElement)element)) {
                    if (!ReflectionDataBuilder.includeAnnotation(access, annotation)) continue;
                    includedAnnotations.add(annotation);
                    ReflectionDataBuilder.registerTypes(access, annotation.getTypes());
                }
                return includedAnnotations.toArray(new AnnotationValue[0]);
            });
        }
    }

    private void registerTypesForParameterAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod executable) {
        if (executable != null) {
            this.filteredParameterAnnotations.computeIfAbsent(executable, element -> {
                AnnotationValue[][] parameterAnnotations = this.annotationExtracter.getParameterAnnotationData((AnnotatedElement)element);
                AnnotationValue[][] includedParameterAnnotations = new AnnotationValue[parameterAnnotations.length][];
                for (int i = 0; i < includedParameterAnnotations.length; ++i) {
                    AnnotationValue[] annotations = parameterAnnotations[i];
                    ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                    for (AnnotationValue annotation : annotations) {
                        if (!ReflectionDataBuilder.includeAnnotation(access, annotation)) continue;
                        includedAnnotations.add(annotation);
                        ReflectionDataBuilder.registerTypes(access, annotation.getTypes());
                    }
                    includedParameterAnnotations[i] = includedAnnotations.toArray(new AnnotationValue[0]);
                }
                return includedParameterAnnotations;
            });
        }
    }

    private void registerTypesForTypeAnnotations(FeatureImpl.DuringAnalysisAccessImpl access, AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            this.filteredTypeAnnotations.computeIfAbsent(annotatedElement, element -> {
                ArrayList<TypeAnnotationValue> includedTypeAnnotations = new ArrayList<TypeAnnotationValue>();
                for (TypeAnnotationValue typeAnnotation : this.annotationExtracter.getTypeAnnotationData((AnnotatedElement)element)) {
                    if (!ReflectionDataBuilder.includeAnnotation(access, typeAnnotation.getAnnotationData())) continue;
                    includedTypeAnnotations.add(typeAnnotation);
                    ReflectionDataBuilder.registerTypes(access, typeAnnotation.getAnnotationData().getTypes());
                }
                return includedTypeAnnotations.toArray(new TypeAnnotationValue[0]);
            });
        }
    }

    private void registerTypesForAnnotationDefault(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.annotationExtracter.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            ReflectionDataBuilder.registerTypes(access, annotationDefault.getTypes());
        }
    }

    private static boolean includeAnnotation(FeatureImpl.DuringAnalysisAccessImpl access, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return false;
        }
        for (Class<?> type : annotationValue.getTypes()) {
            if (type != null && !SubstitutionReflectivityFilter.shouldExclude(type, access.getMetaAccess(), access.getUniverse())) continue;
            return false;
        }
        return true;
    }

    private static void registerTypes(FeatureImpl.DuringAnalysisAccessImpl access, Collection<Class<?>> types) {
        for (Class<?> type : types) {
            AnalysisType analysisType = access.getMetaAccess().lookupJavaType(type);
            ReflectionDataBuilder.makeAnalysisTypeReachable(access, analysisType);
            if (type.isAnnotation()) {
                ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass(type);
            }
            if (!ExceptionProxy.class.isAssignableFrom(type)) continue;
            analysisType.registerAsInHeap();
        }
    }

    private static void makeAnalysisTypeReachable(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type) {
        if (type.registerAsReachable()) {
            access.requireAnalysisIteration();
        }
    }

    private void processRegisteredElements(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (this.modifiedClasses.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        for (Class<?> clazz : this.modifiedClasses) {
            this.processClass(access, clazz);
        }
        this.modifiedClasses.clear();
    }

    private void processClass(FeatureImpl.DuringAnalysisAccessImpl access, Class<?> clazz) {
        if (SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
        type.registerAsReachable();
        if (this.unsafeInstantiatedClasses.contains(clazz)) {
            type.registerAsAllocated(null);
        }
        if (this.reflectionClasses.contains(clazz)) {
            ClassForNameSupport.registerClass(clazz);
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            if (ReflectionDataBuilder.query(clazz::getEnclosingClass, errors) != null) {
                this.innerClasses.computeIfAbsent(access.getMetaAccess().lookupJavaType(clazz.getEnclosingClass()).getJavaClass(), enclosingType -> ConcurrentHashMap.newKeySet()).add(clazz);
            }
            ReflectionDataBuilder.reportLinkingErrors(clazz, errors);
        }
        if (type.isAnnotation()) {
            HashSet<AccessibleObject> members = new HashSet<AccessibleObject>();
            for (Field field : this.reflectionFields) {
                if (!field.getDeclaringClass().equals(clazz) || SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) continue;
                members.add(field);
            }
            for (Executable executable : this.reflectionMethods.keySet()) {
                if (!executable.getDeclaringClass().equals(clazz) || SubstitutionReflectivityFilter.shouldExclude(executable, access.getMetaAccess(), access.getUniverse())) continue;
                members.add(executable);
            }
            this.annotationMembers.put(clazz, members);
            access.requireAnalysisIteration();
        }
    }

    private static <T> T query(Callable<T> callable, List<Throwable> errors) {
        try {
            return callable.call();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException e) {
            if (errors != null) {
                errors.add(e);
            }
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere(e);
        }
        return null;
    }

    private Object[] buildRecordComponents(Class<?> clazz, FeatureImpl.DuringAnalysisAccessImpl access) {
        Method[] allMethods;
        RecordSupport support = RecordSupport.singleton();
        if (!support.isRecord(clazz)) {
            return null;
        }
        for (Method method : allMethods = support.getRecordComponentAccessorMethods(clazz)) {
            if (this.reflectionMethods.containsKey(method) && !SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            return null;
        }
        return support.getRecordComponents(clazz);
    }

    private static void reportLinkingErrors(Class<?> clazz, List<Throwable> errors) {
        if (errors.isEmpty()) {
            return;
        }
        String messages = errors.stream().map(e -> e.getClass().getTypeName() + ": " + e.getMessage()).distinct().collect(Collectors.joining(", "));
        System.out.println("Warning: Could not register complete reflection metadata for " + clazz.getTypeName() + ". Reason(s): " + messages);
    }

    protected void afterAnalysis() {
        this.sealed = true;
        if (!this.modifiedClasses.isEmpty()) {
            throw UserError.abort("Registration of classes, methods, and fields for reflective access during analysis must set DuringAnalysisAccess.requireAnalysisIteration().", new Object[0]);
        }
    }

    @Override
    public boolean requiresProcessing() {
        return !this.modifiedClasses.isEmpty();
    }

    private static Executable enclosingMethodOrConstructor(Class<?> clazz, List<Throwable> errors) {
        Constructor<?> enclosingConstructor;
        Method enclosingMethod;
        try {
            enclosingMethod = clazz.getEnclosingMethod();
            enclosingConstructor = clazz.getEnclosingConstructor();
        }
        catch (LinkageError | TypeNotPresentException e) {
            if (errors != null) {
                errors.add(e);
            }
            return null;
        }
        catch (InternalError ex) {
            if (errors != null) {
                errors.add(ex);
            }
            return null;
        }
        if (enclosingMethod == null && enclosingConstructor == null) {
            return null;
        }
        if (enclosingMethod != null && enclosingConstructor != null) {
            throw VMError.shouldNotReachHere("Class has both an enclosingMethod and an enclosingConstructor: " + clazz + ", " + enclosingMethod + ", " + enclosingConstructor);
        }
        return enclosingMethod != null ? enclosingMethod : enclosingConstructor;
    }

    @Override
    public Map<Class<?>, Set<Class<?>>> getReflectionInnerClasses() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.innerClasses);
    }

    @Override
    public Set<Field> getReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.registeredFields);
    }

    @Override
    public Set<Executable> getReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.registeredMethods);
    }

    @Override
    public Object getAccessor(Executable method) {
        assert (this.sealed);
        return this.methodAccessors.get(method);
    }

    public Set<ResolvedJavaField> getHidingReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingFields);
    }

    public Set<ResolvedJavaMethod> getHidingReflectionMethods() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingMethods);
    }

    @Override
    public Object[] getRecordComponents(Class<?> type) {
        assert (this.sealed);
        return this.registeredRecordComponents.get(type);
    }

    @Override
    public void registerHeapDynamicHub(Object hub) {
        assert (!this.sealed);
        this.heapDynamicHubs.add((DynamicHub)hub);
    }

    public Set<DynamicHub> getHeapDynamicHubs() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapDynamicHubs);
    }

    @Override
    public void registerHeapReflectionObject(AccessibleObject object) {
        assert (!this.sealed);
        this.heapReflectionObjects.add(object);
    }

    @Override
    public Set<AccessibleObject> getHeapReflectionObjects() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapReflectionObjects);
    }

    public AnnotationValue[] getAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredAnnotations.getOrDefault(element, NO_ANNOTATIONS);
    }

    public AnnotationValue[][] getParameterAnnotationData(AnalysisMethod element) {
        assert (this.sealed);
        return this.filteredParameterAnnotations.getOrDefault(element, NO_PARAMETER_ANNOTATIONS);
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredTypeAnnotations.getOrDefault(element, NO_TYPE_ANNOTATIONS);
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        return this.annotationExtracter.getAnnotationDefaultData(element);
    }

    @Override
    public int getReflectionClassesCount() {
        return this.reflectionClasses.size();
    }

    @Override
    public int getReflectionMethodsCount() {
        return this.registeredMethods.size();
    }

    @Override
    public int getReflectionFieldsCount() {
        return this.registeredFields.size();
    }

    private static enum ExecutableAccessibility {
        QueriedOnly,
        Accessed;


        static ExecutableAccessibility max(ExecutableAccessibility a, ExecutableAccessibility b) {
            return a == Accessed || b == Accessed ? Accessed : QueriedOnly;
        }
    }
}

