/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.AnalysisObjectScanningObserver;
import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.heap.HeapSnapshotVerifier;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisFactory;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.PointsToAnalysisFactory;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.reports.AnalysisReporter;
import com.oracle.graal.pointsto.typestate.DefaultAnalysisPolicy;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.aarch64.AArch64CPUFeatureAccess;
import com.oracle.svm.core.allocationprofile.AllocationCounter;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.c.libc.NoLibC;
import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.cpufeature.RuntimeCPUFeatureCheck;
import com.oracle.svm.core.graal.EconomyGraalConfiguration;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.jdk.SubstrateArraycopySnippets;
import com.oracle.svm.core.graal.lir.VerifyCFunctionReferenceMapsLIRPhase;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateStampProvider;
import com.oracle.svm.core.graal.phases.CollectDeoptimizationSourcePositionsPhase;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.phases.OptimizeExceptionPathsPhase;
import com.oracle.svm.core.graal.phases.RemoveUnwindPhase;
import com.oracle.svm.core.graal.phases.SubstrateSafepointInsertionPhase;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.graal.snippets.DeoptHostedSnippets;
import com.oracle.svm.core.graal.snippets.DeoptRuntimeSnippets;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.ExceptionSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.TypeSnippets;
import com.oracle.svm.core.graal.word.SubstrateWordOperationPlugins;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ClassLoaderSupportImpl;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.TemporaryBuildDirectoryProviderImpl;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.analysis.SVMAnalysisMetaAccess;
import com.oracle.svm.hosted.analysis.SubstrateUnsupportedFeatures;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.c.CConstantValueSupportImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.OffsetOfSupportImpl;
import com.oracle.svm.hosted.c.SizeOfSupportImpl;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperSubstitutionProcessor;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ConfigurableClassInitialization;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CFunctionSubstitutionProcessor;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.HostedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.NativeMethodSubstitutionProcessor;
import com.oracle.svm.hosted.code.RestrictHeapAccessCalleesImpl;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateGraphMakerFactory;
import com.oracle.svm.hosted.heap.SVMImageHeapScanner;
import com.oracle.svm.hosted.heap.SVMImageHeapVerifier;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.EarlyConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.ImageBuildStatisticsCounterPhase;
import com.oracle.svm.hosted.phases.InjectedAccessorsPlugin;
import com.oracle.svm.hosted.phases.IntrinsifyMethodHandlesInvocationPlugin;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.phases.VerifyDeoptFrameStatesLIRPhase;
import com.oracle.svm.hosted.phases.VerifyNoGuardsPhase;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedFieldsPlugin;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import com.oracle.svm.util.AnnotationExtracter;
import com.oracle.svm.util.ImageBuildStatistics;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.gc.BarrierSet;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginInjectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeoptimizationGroupingPhase;
import org.graalvm.compiler.phases.common.ExpandLogicPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.common.UseTrappingNullChecksPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.CConstantValueSupport;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;
import org.graalvm.nativeimage.impl.SizeOfSupport;
import org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking;
import org.graalvm.word.PointerBase;

public class NativeImageGenerator {
    protected final FeatureHandler featureHandler;
    protected final ImageClassLoader loader;
    protected final HostedOptionProvider optionProvider;
    private final ProgressReporter reporter;
    private DeadlockWatchdog watchdog;
    private AnalysisUniverse aUniverse;
    private HostedUniverse hUniverse;
    private Inflation bb;
    private NativeLibraries nativeLibraries;
    private AbstractImage image;
    private AtomicBoolean buildStarted = new AtomicBoolean();
    private Pair<Method, CEntryPointData> mainEntryPoint;
    private final Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifacts = new EnumMap<BuildArtifacts.ArtifactType, List<Path>>(BuildArtifacts.ArtifactType.class);

    public NativeImageGenerator(ImageClassLoader loader, HostedOptionProvider optionProvider, Pair<Method, CEntryPointData> mainEntryPoint, ProgressReporter reporter) {
        this.loader = loader;
        this.mainEntryPoint = mainEntryPoint;
        this.featureHandler = new FeatureHandler();
        this.optionProvider = optionProvider;
        this.reporter = reporter;
        optionProvider.getHostedValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
        optionProvider.getRuntimeValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
    }

    public static Platform loadPlatform(ClassLoader classLoader, String platformClassName) throws ClassNotFoundException {
        Object result;
        Class<?> platformClass = classLoader.loadClass(platformClassName);
        try {
            result = ReflectionUtil.newInstance(platformClass);
        }
        catch (ReflectionUtil.ReflectionUtilError ex) {
            throw UserError.abort(ex.getCause(), "Could not instantiate platform class %s. Ensure the class is not abstract and has a no-argument constructor.", platformClassName);
        }
        if (!(result instanceof Platform)) {
            throw UserError.abort("Platform class %s does not implement %s", platformClassName, Platform.class.getTypeName());
        }
        return (Platform)result;
    }

    public static Platform loadPlatform(String os, String arch) {
        ServiceLoader<Platform> loader = ServiceLoader.load(Platform.class);
        for (Platform platform : loader) {
            if (!platform.getOS().equals(os) || !platform.getArchitecture().equals(arch)) continue;
            return platform;
        }
        throw UserError.abort("Platform specified as " + os + "-" + arch + " isn't supported.", new Object[0]);
    }

    public static Platform getTargetPlatform(ClassLoader classLoader) {
        String arch;
        String platformClassName = System.getProperty("svm.platform");
        if (platformClassName != null) {
            try {
                return NativeImageGenerator.loadPlatform(classLoader, platformClassName);
            }
            catch (ClassNotFoundException ex) {
                throw UserError.abort("Could not find platform class %s that was specified explicitly on the command line using the system property %s", platformClassName, "svm.platform");
            }
        }
        String os = System.getProperty("svm.targetPlatformOS");
        if (os == null) {
            os = OS.getCurrent().className.toLowerCase();
        }
        if ((arch = System.getProperty("svm.targetPlatformArch")) == null) {
            arch = SubstrateUtil.getArchitectureName();
        }
        return NativeImageGenerator.loadPlatform(os, arch);
    }

    public static boolean includedIn(Platform platform, Class<? extends Platform> platformGroup) {
        return platformGroup.isInstance(platform);
    }

    public static boolean includedIn(Platform platform, Platforms platformsAnnotation) {
        if (platformsAnnotation == null) {
            return true;
        }
        for (Class platformGroup : platformsAnnotation.value()) {
            if (!NativeImageGenerator.includedIn(platform, platformGroup)) continue;
            return true;
        }
        return false;
    }

    public static SubstrateTargetDescription createTarget(Platform platform) {
        if (NativeImageGenerator.includedIn(platform, Platform.AMD64.class)) {
            EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
            if (NativeImageOptions.NativeArchitecture.getValue().booleanValue()) {
                features.addAll(((AMD64)GraalAccess.getOriginalTarget().arch).getFeatures());
            } else {
                features.add(AMD64.CPUFeature.SSE);
                features.add(AMD64.CPUFeature.SSE2);
                features.addAll(NativeImageGenerator.parseCSVtoEnum(AMD64.CPUFeature.class, NativeImageOptions.CPUFeatures.getValue().values(), (Enum[])AMD64.CPUFeature.values()));
            }
            features.remove(AMD64.CPUFeature.RTM);
            Object runtimeCheckedFeatures = features.clone();
            if (NativeImageOptions.RuntimeCheckedCPUFeatures.hasBeenSet()) {
                ((AbstractCollection)runtimeCheckedFeatures).addAll(NativeImageGenerator.parseCSVtoEnum(AMD64.CPUFeature.class, NativeImageOptions.RuntimeCheckedCPUFeatures.getValue().values(), (Enum[])AMD64.CPUFeature.values()));
            } else {
                Set<Enum<?>> disabledFeatures = RuntimeCPUFeatureCheck.getDefaultDisabledFeatures(GraalAccess.getOriginalTarget().arch);
                for (Enum<?> feature : RuntimeCPUFeatureCheck.getSupportedFeatures(GraalAccess.getOriginalTarget().arch)) {
                    if (disabledFeatures.contains(feature)) continue;
                    ((AbstractCollection)runtimeCheckedFeatures).add((AMD64.CPUFeature)feature);
                }
            }
            AMD64 architecture = new AMD64(features, AMD64CPUFeatureAccess.allAMD64Flags());
            assert (architecture instanceof AMD64) : "using AMD64 platform with a different architecture";
            int deoptScratchSpace = 16;
            return new SubstrateTargetDescription((Architecture)architecture, true, 16, 0, deoptScratchSpace, (EnumSet<?>)runtimeCheckedFeatures);
        }
        if (NativeImageGenerator.includedIn(platform, Platform.AARCH64.class)) {
            Architecture architecture;
            if (NativeImageOptions.NativeArchitecture.getValue().booleanValue()) {
                architecture = GraalAccess.getOriginalTarget().arch;
            } else {
                EnumSet<AArch64.CPUFeature> features = EnumSet.noneOf(AArch64.CPUFeature.class);
                features.add(AArch64.CPUFeature.FP);
                features.add(AArch64.CPUFeature.ASIMD);
                features.addAll(NativeImageGenerator.parseCSVtoEnum(AArch64.CPUFeature.class, NativeImageOptions.CPUFeatures.getValue().values(), (Enum[])AArch64.CPUFeature.values()));
                architecture = new AArch64(features, AArch64CPUFeatureAccess.enabledAArch64Flags());
            }
            assert (architecture instanceof AArch64) : "using AArch64 platform with a different architecture";
            Object runtimeCheckedFeatures = ((AArch64)architecture).getFeatures().clone();
            int deoptScratchSpace = 16;
            return new SubstrateTargetDescription(architecture, true, 16, 0, deoptScratchSpace, (EnumSet<?>)runtimeCheckedFeatures);
        }
        throw UserError.abort("Architecture specified by platform is not supported: %s", platform.getClass().getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<Method, CEntryPointData> entryPoints, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor, EconomicSet<String> allOptionNames, TimerCollection timerCollection) {
        try {
            if (!this.buildStarted.compareAndSet(false, true)) {
                throw UserError.abort("An image build has already been performed with this generator.", new Object[0]);
            }
            try {
                ResolvedJavaType.class.getDeclaredMethod("link", new Class[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw UserError.abort("JVMCI version provided %s is missing the 'ResolvedJavaType.link()' method added in jvmci-20.2-b01. Please use the latest JVMCI JDK from %s.", System.getProperty("java.home"), "https://github.com/graalvm/labs-openjdk-*/releases");
            }
            NativeImageGenerator.setSystemPropertiesForImageLate(k);
            ImageSingletonsSupportImpl.HostedManagement.install(new ImageSingletonsSupportImpl.HostedManagement());
            ImageSingletons.add(ProgressReporter.class, (Object)this.reporter);
            ImageSingletons.add(TimerCollection.class, (Object)timerCollection);
            ImageSingletons.add(ImageBuildStatistics.TimerCollectionPrinter.class, (Object)timerCollection);
            ImageSingletons.add(AnnotationExtracter.class, (Object)this.loader.classLoaderSupport.annotationExtracter);
            ImageSingletons.add(BuildArtifacts.class, (type, artifact) -> this.buildArtifacts.computeIfAbsent(type, t -> new ArrayList()).add(artifact));
            ImageSingletons.add(HostedOptionValues.class, (Object)((Object)new HostedOptionValues(this.optionProvider.getHostedValues())));
            ImageSingletons.add(RuntimeOptionValues.class, (Object)((Object)new RuntimeOptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)this.optionProvider.getRuntimeValues(), allOptionNames)));
            this.watchdog = new DeadlockWatchdog();
            try (TemporaryBuildDirectoryProviderImpl tempDirectoryProvider = new TemporaryBuildDirectoryProviderImpl();){
                ImageSingletons.add(TemporaryBuildDirectoryProvider.class, (Object)tempDirectoryProvider);
                this.doRun(entryPoints, javaMainSupport, imageName, k, harnessSubstitutions, compilationExecutor, analysisExecutor);
            }
            finally {
                this.reporter.ensureCreationStageEndCompleted();
                this.watchdog.close();
            }
        }
        finally {
            analysisExecutor.shutdownNow();
            compilationExecutor.shutdownNow();
        }
    }

    protected static void setSystemPropertiesForImageEarly() {
        System.setProperty("org.graalvm.nativeimage.imagecode", "buildtime");
    }

    private static void setSystemPropertiesForImageLate(AbstractImage.NativeImageKind imageKind) {
        VMError.guarantee(ImageInfo.inImageBuildtimeCode(), "System property to indicate image build time is set earlier, before listing classes");
        if (imageKind.isExecutable) {
            System.setProperty("org.graalvm.nativeimage.kind", "executable");
        } else {
            System.setProperty("org.graalvm.nativeimage.kind", "shared");
        }
    }

    protected static void clearSystemPropertiesForImage() {
        System.clearProperty("org.graalvm.nativeimage.imagecode");
        System.clearProperty("org.graalvm.nativeimage.kind");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRun(Map<Method, CEntryPointData> entryPoints, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor) {
        ArrayList<HostedMethod> hostedEntryPoints = new ArrayList<HostedMethod>();
        OptionValues options = HostedOptionValues.singleton();
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        try (DebugContext debug = new DebugContext.Builder(options, (DebugHandlersFactory)new GraalDebugHandlersFactory(originalSnippetReflection)).build();
             DebugCloseable featureCleanup = () -> this.featureHandler.forEachFeature(Feature::cleanup);){
            NativeImageCodeCache codeCache;
            CompileQueue compileQueue;
            SharedRuntimeConfigurationBuilder runtime;
            HostedMetaAccess hMetaAccess;
            this.setupNativeImage(imageName, options, entryPoints, javaMainSupport, harnessSubstitutions, analysisExecutor, originalSnippetReflection, debug);
            this.reporter.printFeatures(this.featureHandler.getUserSpecificFeatures());
            boolean returnAfterAnalysis = this.runPointsToAnalysis(imageName, options, debug);
            if (returnAfterAnalysis) {
                return;
            }
            try (ProgressReporter.ReporterClosable c = this.reporter.printUniverse();){
                this.bb.getHeartbeatCallback().run();
                this.hUniverse = new HostedUniverse(this.bb);
                hMetaAccess = new HostedMetaAccess(this.hUniverse, this.bb.getMetaAccess());
                ((SVMImageHeapScanner)this.aUniverse.getHeapScanner()).setHostedMetaAccess(hMetaAccess);
                FeatureImpl.BeforeUniverseBuildingAccessImpl beforeUniverseBuildingConfig = new FeatureImpl.BeforeUniverseBuildingAccessImpl(this.featureHandler, this.loader, debug, hMetaAccess);
                this.featureHandler.forEachFeature(feature -> feature.beforeUniverseBuilding((Feature.BeforeUniverseBuildingAccess)beforeUniverseBuildingConfig));
                new UniverseBuilder(this.aUniverse, this.bb.getMetaAccess(), this.hUniverse, hMetaAccess, HostedConfiguration.instance().createStaticAnalysisResultsBuilder(this.bb, this.hUniverse), this.bb.getUnsupportedFeatures()).build(debug);
                BuildPhaseProvider.markHostedUniverseBuilt();
                ClassInitializationSupport classInitializationSupport = this.bb.getHostVM().getClassInitializationSupport();
                runtime = new HostedRuntimeConfigurationBuilder(options, this.bb.getHostVM(), this.hUniverse, hMetaAccess, this.bb.getProviders(), this.nativeLibraries, classInitializationSupport, GraalAccess.getOriginalProviders().getLoopsDataProvider()).build();
                NativeImageGenerator.registerGraphBuilderPlugins(this.featureHandler, runtime.getRuntimeConfig(), (HostedProviders)runtime.getRuntimeConfig().getProviders(), this.bb.getMetaAccess(), this.aUniverse, hMetaAccess, this.hUniverse, this.nativeLibraries, this.loader, ParsingReason.AOTCompilation, this.bb.getAnnotationSubstitutionProcessor(), new SubstrateClassInitializationPlugin((SVMHost)this.aUniverse.hostVM()), classInitializationSupport, ConfigurationValues.getTarget());
                if (NativeImageOptions.PrintUniverse.getValue().booleanValue()) {
                    this.printTypes();
                }
                for (AnalysisMethod m : this.aUniverse.getMethods()) {
                    if (!m.isEntryPoint()) continue;
                    HostedMethod found = this.hUniverse.lookup((JavaMethod)m);
                    assert (found != null);
                    hostedEntryPoints.add(found);
                }
                if (hostedEntryPoints.size() == 0) {
                    throw UserError.abort("Warning: no entry points found, i.e., no method annotated with @%s", CEntryPoint.class.getSimpleName());
                }
                this.bb.getUnsupportedFeatures().report((BigBang)this.bb);
                NativeImageGenerator.recordRestrictHeapAccessCallees(this.aUniverse.getMethods());
                this.bb.cleanupAfterAnalysis();
            }
            catch (UnsupportedFeatureException ufe) {
                throw FallbackFeature.reportAsFallback((RuntimeException)((Object)ufe));
            }
            NativeImageHeap heap = new NativeImageHeap(this.aUniverse, this.hUniverse, hMetaAccess, (ImageHeapLayouter)ImageSingletons.lookup(ImageHeapLayouter.class));
            FeatureImpl.BeforeCompilationAccessImpl beforeCompilationConfig = new FeatureImpl.BeforeCompilationAccessImpl(this.featureHandler, this.loader, this.aUniverse, this.hUniverse, heap, debug, runtime);
            this.featureHandler.forEachFeature(feature -> feature.beforeCompilation((Feature.BeforeCompilationAccess)beforeCompilationConfig));
            try (Timer.StopTimer t = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.COMPILE_TOTAL);){
                compileQueue = HostedConfiguration.instance().createCompileQueue(debug, this.featureHandler, this.hUniverse, runtime, DeoptTester.enabled(), this.bb.getProviders().getSnippetReflection(), compilationExecutor);
                compileQueue.finish(debug);
                this.hUniverse.getMethods().forEach(HostedMethod::clear);
                codeCache = NativeImageCodeCacheFactory.get().newCodeCache(compileQueue, heap, this.loader.platform, ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory());
                codeCache.layoutConstants();
                codeCache.layoutMethods(debug, imageName, this.bb, compilationExecutor);
                BuildPhaseProvider.markCompilationFinished();
                FeatureImpl.AfterCompilationAccessImpl config = new FeatureImpl.AfterCompilationAccessImpl(this.featureHandler, this.loader, this.aUniverse, this.hUniverse, compileQueue.getCompilations(), heap, debug, runtime);
                this.featureHandler.forEachFeature(feature -> feature.afterCompilation((Feature.AfterCompilationAccess)config));
            }
            CodeCacheProvider codeCacheProvider = runtime.getRuntimeConfig().getBackendForNormalMethod().getProviders().getCodeCache();
            this.reporter.printCreationStart();
            try (Indent indent = debug.logAndIndent("create native image");){
                try (DebugContext.Scope buildScope = debug.scope((Object)"CreateImage", (Object)codeCacheProvider);
                     Timer.StopTimer t = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.IMAGE);){
                    this.bb.getHeartbeatCallback().run();
                    heap.addInitialObjects();
                    codeCache.addConstantsToHeap();
                    heap.addTrailingObjects();
                    FeatureImpl.AfterHeapLayoutAccessImpl config = new FeatureImpl.AfterHeapLayoutAccessImpl(this.featureHandler, this.loader, heap, hMetaAccess, debug);
                    this.featureHandler.forEachFeature(feature -> feature.afterHeapLayout((Feature.AfterHeapLayoutAccess)config));
                    this.image = AbstractImage.create(k, this.hUniverse, hMetaAccess, this.nativeLibraries, heap, codeCache, hostedEntryPoints, this.loader.getClassLoader());
                    this.image.build(imageName, debug);
                    if (NativeImageOptions.PrintUniverse.getValue().booleanValue()) {
                        codeCache.printCompilationResults();
                    }
                }
                catch (Throwable e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            ProgressReporter.singleton().createBreakdowns(compileQueue.getCompilationTasks(), this.image.getHeap().getObjects());
            compileQueue.purge();
            int numCompilations = codeCache.getOrderedCompilations().size();
            try (Timer.StopTimer t = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.WRITE);){
                this.bb.getHeartbeatCallback().run();
                FeatureImpl.BeforeImageWriteAccessImpl beforeConfig = new FeatureImpl.BeforeImageWriteAccessImpl(this.featureHandler, this.loader, imageName, this.image, runtime.getRuntimeConfig(), this.aUniverse, this.hUniverse, this.optionProvider, hMetaAccess, debug);
                this.featureHandler.forEachFeature(feature -> feature.beforeImageWrite((Feature.BeforeImageWriteAccess)beforeConfig));
                Path tmpDir = ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory();
                LinkerInvocation inv = this.image.write(debug, NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()), tmpDir, imageName, beforeConfig);
                if (NativeImageOptions.ExitAfterRelocatableImageWrite.getValue().booleanValue()) {
                    return;
                }
                FeatureImpl.AfterImageWriteAccessImpl afterConfig = new FeatureImpl.AfterImageWriteAccessImpl(this.featureHandler, this.loader, this.hUniverse, inv, tmpDir, this.image.getImageKind(), debug);
                this.featureHandler.forEachFeature(feature -> feature.afterImageWrite((Feature.AfterImageWriteAccess)afterConfig));
            }
            this.reporter.printCreationEnd(this.image.getImageSize(), heap.getObjectCount(), this.image.getImageHeapSize(), codeCache.getCodeAreaSize(), numCompilations, this.image.getDebugInfoSize());
            return;
        }
    }

    private boolean runPointsToAnalysis(String imageName, OptionValues options, DebugContext debug) {
        try (Indent ignored = debug.logAndIndent("run analysis");){
            FeatureImpl.BeforeAnalysisAccessImpl config;
            try (Indent ignored1 = debug.logAndIndent("process analysis initializers");){
                config = new FeatureImpl.BeforeAnalysisAccessImpl(this.featureHandler, this.loader, this.bb, this.nativeLibraries, debug);
                this.featureHandler.forEachFeature(feature -> feature.beforeAnalysis((Feature.BeforeAnalysisAccess)config));
                this.bb.getHostVM().getClassInitializationSupport().setConfigurationSealed(true);
            }
            try (ProgressReporter.ReporterClosable c = ProgressReporter.singleton().printAnalysis(this.bb.getUniverse(), this.nativeLibraries.getLibraries());){
                config = new FeatureImpl.DuringAnalysisAccessImpl(this.featureHandler, this.loader, this.bb, this.nativeLibraries, debug);
                try {
                    FeatureImpl.ConcurrentAnalysisAccessImpl concurrentConfig = new FeatureImpl.ConcurrentAnalysisAccessImpl(this.featureHandler, this.loader, this.bb, this.nativeLibraries, debug);
                    this.aUniverse.setConcurrentAnalysisAccess((Feature.DuringAnalysisAccess)concurrentConfig);
                    this.bb.runAnalysis(debug, arg_0 -> this.lambda$runPointsToAnalysis$11((FeatureImpl.DuringAnalysisAccessImpl)config, arg_0));
                }
                catch (AnalysisError e) {
                    throw UserError.abort(e, "Analysis step failed. Reason: %s.", e.getMessage());
                }
                assert (this.verifyAssignableTypes(imageName));
                this.nativeLibraries.processAnnotated();
                BuildPhaseProvider.markAnalysisFinished();
                FeatureImpl.AfterAnalysisAccessImpl postConfig = new FeatureImpl.AfterAnalysisAccessImpl(this.featureHandler, this.loader, this.bb, debug);
                this.featureHandler.forEachFeature(feature -> feature.afterAnalysis((Feature.AfterAnalysisAccess)postConfig));
                this.checkUniverse();
                this.bb.printTimers();
                this.bb.getUnsupportedFeatures().report((BigBang)this.bb);
                this.bb.checkUserLimitations();
            }
            catch (UnsupportedFeatureException ufe) {
                throw FallbackFeature.reportAsFallback((RuntimeException)((Object)ufe));
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptImageBuilding();
        }
        finally {
            FeatureImpl.OnAnalysisExitAccessImpl onExitConfig = new FeatureImpl.OnAnalysisExitAccessImpl(this.featureHandler, this.loader, this.bb, debug);
            this.featureHandler.forEachFeature(feature -> feature.onAnalysisExit(onExitConfig));
            AnalysisReporter.printAnalysisReports((String)imageName, (OptionValues)options, (String)SubstrateOptions.reportsPath(), (BigBang)this.bb);
        }
        if (NativeImageOptions.ReturnAfterAnalysis.getValue().booleanValue()) {
            return true;
        }
        if (NativeImageOptions.ExitAfterAnalysis.getValue().booleanValue()) {
            throw new InterruptImageBuilding("Exiting image generation because of " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ExitAfterAnalysis, "+"));
        }
        return false;
    }

    private boolean verifyAssignableTypes(String imageName) {
        if (SubstrateOptions.DisableTypeIdResultVerification.getValue().booleanValue()) {
            return true;
        }
        try (Timer.StopTimer t = TimerCollection.createTimerAndStart((String)imageName, (String)"(verifyAssignableTypes)");){
            boolean bl = AnalysisType.verifyAssignableTypes((BigBang)this.bb);
            return bl;
        }
    }

    private void setupNativeImage(String imageName, OptionValues options, Map<Method, CEntryPointData> entryPoints, JavaMainWrapper.JavaMainSupport javaMainSupport, SubstitutionProcessor harnessSubstitutions, ForkJoinPool analysisExecutor, SnippetReflectionProvider originalSnippetReflection, DebugContext debug) {
        try (Indent ignored = debug.logAndIndent("setup native-image builder");){
            try (Timer.StopTimer ignored1 = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.SETUP);){
                boolean withoutCompilerInvoker;
                SubstrateTargetDescription target = NativeImageGenerator.createTarget(this.loader.platform);
                ImageSingletons.add(Platform.class, (Object)this.loader.platform);
                ImageSingletons.add(SubstrateTargetDescription.class, (Object)((Object)target));
                ImageSingletons.add(SubstrateOptions.ReportingSupport.class, (Object)new SubstrateOptions.ReportingSupport(NativeImageOptions.DiagnosticsMode.getValue() != false ? NativeImageOptions.DiagnosticsDir.getValue() : Paths.get("reports", new String[0]).toString()));
                if (javaMainSupport != null) {
                    ImageSingletons.add(JavaMainWrapper.JavaMainSupport.class, (Object)javaMainSupport);
                }
                Providers originalProviders = GraalAccess.getOriginalProviders();
                MetaAccessProvider originalMetaAccess = originalProviders.getMetaAccess();
                ClassLoaderSupportImpl classLoaderSupport = new ClassLoaderSupportImpl(this.loader.classLoaderSupport);
                ImageSingletons.add(ClassLoaderSupport.class, (Object)classLoaderSupport);
                ImageSingletons.add(LinkAtBuildTimeSupport.class, (Object)new LinkAtBuildTimeSupport(this.loader, classLoaderSupport));
                ConfigurableClassInitialization classInitializationSupport = new ConfigurableClassInitialization(originalMetaAccess, this.loader);
                ImageSingletons.add(RuntimeClassInitializationSupport.class, (Object)classInitializationSupport);
                ClassInitializationFeature.processClassInitializationOptions(classInitializationSupport);
                if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(options)).booleanValue()) {
                    ImageSingletons.add(ImageBuildStatistics.class, (Object)new ImageBuildStatistics());
                }
                if (SubstrateOptions.useEconomyCompilerConfig()) {
                    GraalConfiguration.setHostedInstanceIfEmpty(new EconomyGraalConfiguration());
                }
                BuildPhaseProvider.init();
                this.featureHandler.registerFeatures(this.loader, debug);
                FeatureImpl.AfterRegistrationAccessImpl access = new FeatureImpl.AfterRegistrationAccessImpl(this.featureHandler, this.loader, originalMetaAccess, this.mainEntryPoint, debug);
                this.featureHandler.forEachFeature(feature -> feature.afterRegistration((Feature.AfterRegistrationAccess)access));
                NativeImageGenerator.setDefaultLibCIfMissing();
                if (!Pair.empty().equals(access.getMainEntryPoint())) {
                    this.setAndVerifyMainEntryPoint(access, entryPoints);
                }
                this.registerEntryPoints(entryPoints);
                HostedConfiguration.setDefaultIfEmpty();
                GraalConfiguration.setDefaultIfEmpty();
                AnnotationSubstitutionProcessor annotationSubstitutions = NativeImageGenerator.createAnnotationSubstitutionProcessor(originalMetaAccess, this.loader, classInitializationSupport);
                CEnumCallWrapperSubstitutionProcessor cEnumProcessor = new CEnumCallWrapperSubstitutionProcessor();
                this.aUniverse = NativeImageGenerator.createAnalysisUniverse(options, target, this.loader, originalMetaAccess, originalSnippetReflection, annotationSubstitutions, cEnumProcessor, classInitializationSupport, Collections.singletonList(harnessSubstitutions));
                SVMAnalysisMetaAccess aMetaAccess = new SVMAnalysisMetaAccess(this.aUniverse, originalMetaAccess);
                AnalysisConstantReflectionProvider aConstantReflection = new AnalysisConstantReflectionProvider(this.aUniverse, (MetaAccessProvider)aMetaAccess, originalProviders.getConstantReflection(), classInitializationSupport);
                SubstrateWordTypes aWordTypes = new SubstrateWordTypes((MetaAccessProvider)aMetaAccess, FrameAccess.getWordKind());
                HostedSnippetReflectionProvider aSnippetReflection = new HostedSnippetReflectionProvider(aWordTypes);
                SubstrateForeignCallsProvider aForeignCalls = new SubstrateForeignCallsProvider((MetaAccessProvider)aMetaAccess, null);
                this.bb = NativeImageGenerator.createBigBang(options, target, this.aUniverse, analysisExecutor, this.watchdog::recordActivity, aMetaAccess, aConstantReflection, aWordTypes, aSnippetReflection, annotationSubstitutions, (ForeignCallsProvider)aForeignCalls, classInitializationSupport, originalProviders);
                this.aUniverse.setBigBang((BigBang)this.bb);
                ImageHeap imageHeap = new ImageHeap();
                AnalysisObjectScanningObserver aScanningObserver = new AnalysisObjectScanningObserver((BigBang)this.bb);
                SVMImageHeapScanner heapScanner = new SVMImageHeapScanner(imageHeap, this.loader, aMetaAccess, aSnippetReflection, aConstantReflection, (ObjectScanningObserver)aScanningObserver);
                this.aUniverse.setHeapScanner((ImageHeapScanner)heapScanner);
                SVMImageHeapVerifier heapVerifier = new SVMImageHeapVerifier(this.bb, imageHeap, heapScanner);
                this.aUniverse.setHeapVerifier((HeapSnapshotVerifier)heapVerifier);
                this.aUniverse.getTypes().forEach(t -> {
                    t.registerAsAssignable((BigBang)this.bb);
                    if (t.isReachable()) {
                        this.bb.onTypeInitialized((AnalysisType)t);
                    }
                });
                boolean bl = withoutCompilerInvoker = CAnnotationProcessorCache.Options.ExitAfterQueryCodeGeneration.getValue() != false || NativeImageOptions.ExitAfterRelocatableImageWrite.getValue() != false && CAnnotationProcessorCache.Options.UseCAPCache.getValue() != false;
                if (!withoutCompilerInvoker) {
                    CCompilerInvoker compilerInvoker = CCompilerInvoker.create(((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory());
                    compilerInvoker.verifyCompiler();
                    ImageSingletons.add(CCompilerInvoker.class, (Object)compilerInvoker);
                }
                this.nativeLibraries = this.setupNativeLibraries(imageName, aConstantReflection, (MetaAccessProvider)aMetaAccess, aSnippetReflection, cEnumProcessor, classInitializationSupport, debug);
                try (Indent ignored2 = debug.logAndIndent("process startup initializers");){
                    FeatureImpl.DuringSetupAccessImpl config = new FeatureImpl.DuringSetupAccessImpl(this.featureHandler, this.loader, this.bb, debug);
                    this.featureHandler.forEachFeature(feature -> feature.duringSetup((Feature.DuringSetupAccess)config));
                }
                NativeImageGenerator.initializeBigBang(this.bb, options, this.featureHandler, this.nativeLibraries, debug, aMetaAccess, this.aUniverse.getSubstitutions(), this.loader, true, new SubstrateClassInitializationPlugin((SVMHost)this.aUniverse.hostVM()));
                entryPoints.forEach((method, entryPointData) -> CEntryPointCallStubSupport.singleton().registerStubForMethod((Executable)method, () -> entryPointData));
            }
            ProgressReporter.singleton().printInitializeEnd();
        }
    }

    private static void setDefaultLibCIfMissing() {
        if (!ImageSingletons.contains(LibCBase.class)) {
            ImageSingletons.add(LibCBase.class, (Object)new NoLibC());
        }
    }

    private void setAndVerifyMainEntryPoint(FeatureImpl.AfterRegistrationAccessImpl access, Map<Method, CEntryPointData> entryPoints) {
        this.mainEntryPoint = access.getMainEntryPoint();
        entryPoints.put((Method)this.mainEntryPoint.getLeft(), (CEntryPointData)this.mainEntryPoint.getRight());
    }

    public static AnalysisUniverse createAnalysisUniverse(OptionValues options, TargetDescription target, ImageClassLoader loader, MetaAccessProvider originalMetaAccess, SnippetReflectionProvider originalSnippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, SubstitutionProcessor cEnumProcessor, ClassInitializationSupport classInitializationSupport, List<SubstitutionProcessor> additionalSubstitutions) {
        UnsafeAutomaticSubstitutionProcessor automaticSubstitutions = NativeImageGenerator.createAutomaticUnsafeSubstitutions(originalSnippetReflection, annotationSubstitutions);
        SubstitutionProcessor aSubstitutions = NativeImageGenerator.createAnalysisSubstitutionProcessor(originalMetaAccess, originalSnippetReflection, cEnumProcessor, automaticSubstitutions, annotationSubstitutions, additionalSubstitutions);
        SVMHost hostVM = HostedConfiguration.instance().createHostVM(options, loader.getClassLoader(), classInitializationSupport, automaticSubstitutions, loader.platform, originalSnippetReflection);
        automaticSubstitutions.init(loader, originalMetaAccess);
        BytecodeSensitiveAnalysisPolicy analysisPolicy = (Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(options) != false ? new BytecodeSensitiveAnalysisPolicy(options) : new DefaultAnalysisPolicy(options);
        return new AnalysisUniverse((HostVM)hostVM, target.wordJavaKind, (AnalysisPolicy)analysisPolicy, aSubstitutions, originalMetaAccess, originalSnippetReflection, (SnippetReflectionProvider)new SubstrateSnippetReflectionProvider(new SubstrateWordTypes(originalMetaAccess, FrameAccess.getWordKind())), (AnalysisFactory)new PointsToAnalysisFactory());
    }

    public static AnnotationSubstitutionProcessor createAnnotationSubstitutionProcessor(MetaAccessProvider originalMetaAccess, ImageClassLoader loader, ClassInitializationSupport classInitializationSupport) {
        AnnotationSubstitutionProcessor annotationSubstitutions = new AnnotationSubstitutionProcessor(loader, originalMetaAccess, classInitializationSupport);
        annotationSubstitutions.init();
        return annotationSubstitutions;
    }

    public static UnsafeAutomaticSubstitutionProcessor createAutomaticUnsafeSubstitutions(SnippetReflectionProvider originalSnippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions) {
        return new UnsafeAutomaticSubstitutionProcessor(annotationSubstitutions, originalSnippetReflection);
    }

    public static SubstitutionProcessor createAnalysisSubstitutionProcessor(MetaAccessProvider originalMetaAccess, SnippetReflectionProvider originalSnippetReflection, SubstitutionProcessor cEnumProcessor, SubstitutionProcessor automaticSubstitutions, SubstitutionProcessor annotationSubstitutions, List<SubstitutionProcessor> additionalSubstitutionProcessors) {
        ArrayList<SubstitutionProcessor> allProcessors = new ArrayList<SubstitutionProcessor>();
        CFunctionSubstitutionProcessor cFunctionSubstitutions = new CFunctionSubstitutionProcessor();
        allProcessors.addAll(Arrays.asList(new SubstitutionProcessor[]{new AnnotationSupport(originalMetaAccess, originalSnippetReflection), annotationSubstitutions, cFunctionSubstitutions, automaticSubstitutions, cEnumProcessor}));
        allProcessors.addAll(additionalSubstitutionProcessors);
        return SubstitutionProcessor.chainUpInOrder((SubstitutionProcessor[])allProcessors.toArray(new SubstitutionProcessor[0]));
    }

    public static void initializeBigBang(Inflation bb, OptionValues options, FeatureHandler featureHandler, NativeLibraries nativeLibraries, DebugContext debug, AnalysisMetaAccess aMetaAccess, SubstitutionProcessor substitutions, ImageClassLoader loader, boolean initForeignCalls, ClassInitializationPlugin classInitializationPlugin) {
        SubstrateReplacements aReplacements = bb.getReplacements();
        HostedProviders aProviders = bb.getProviders();
        AnalysisUniverse aUniverse = bb.getUniverse();
        bb.getAnnotationSubstitutionProcessor().processComputedValueFields(bb);
        SubstitutionProcessor[] featureNativeSubstitutions = aUniverse.getFeatureNativeSubstitutions();
        if (featureNativeSubstitutions.length > 0) {
            SubstitutionProcessor chain = SubstitutionProcessor.chainUpInOrder((SubstitutionProcessor[])featureNativeSubstitutions);
            NativeMethodSubstitutionProcessor nativeSubstitutionProcessor = new NativeMethodSubstitutionProcessor(chain, (Replacements)aReplacements);
            SubstitutionProcessor.extendsTheChain((SubstitutionProcessor)substitutions, (SubstitutionProcessor[])new SubstitutionProcessor[]{nativeSubstitutionProcessor});
        }
        SubstitutionProcessor.extendsTheChain((SubstitutionProcessor)substitutions, (SubstitutionProcessor[])aUniverse.getFeatureSubstitutions());
        try (Indent ignored = debug.logAndIndent("add initial classes/fields/methods");){
            bb.addRootClass(Object.class, false, false).registerAsInHeap();
            bb.addRootField(DynamicHub.class, "vtable");
            bb.addRootClass(String.class, false, false).registerAsInHeap();
            bb.addRootClass(String[].class, false, false).registerAsInHeap();
            bb.addRootField(String.class, "value").registerAsInHeap();
            bb.addRootClass(long[].class, false, false).registerAsInHeap();
            bb.addRootClass(byte[].class, false, false).registerAsInHeap();
            bb.addRootClass(byte[][].class, false, false).registerAsInHeap();
            bb.addRootClass(Object[].class, false, false).registerAsInHeap();
            bb.addRootClass(CFunctionPointer[].class, false, false).registerAsInHeap();
            bb.addRootClass(PointerBase[].class, false, false).registerAsInHeap();
            bb.addRootMethod(ReflectionUtil.lookupMethod(SubstrateArraycopySnippets.class, (String)"doArraycopy", (Class[])new Class[]{Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}), true);
            bb.addRootMethod(ReflectionUtil.lookupMethod(Object.class, (String)"getClass", (Class[])new Class[0]), true);
            for (JavaKind kind : JavaKind.values()) {
                if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
                bb.addRootClass(kind.toJavaClass(), false, true);
                bb.addRootClass(kind.toBoxedJavaClass(), false, true).registerAsInHeap();
                bb.addRootField(kind.toBoxedJavaClass(), "value");
                bb.addRootMethod(ReflectionUtil.lookupMethod((Class)kind.toBoxedJavaClass(), (String)"valueOf", (Class[])new Class[]{kind.toJavaClass()}), true);
                bb.addRootMethod(ReflectionUtil.lookupMethod((Class)kind.toBoxedJavaClass(), (String)(kind.getJavaName() + "Value"), (Class[])new Class[0]), true);
                Class<?>[] innerClasses = kind.toBoxedJavaClass().getDeclaredClasses();
                if (innerClasses == null || innerClasses.length <= 0) continue;
                bb.getMetaAccess().lookupJavaType(innerClasses[0]).registerAsReachable();
            }
            bb.getMetaAccess().lookupJavaType(JavaKind.Void.toJavaClass()).registerAsReachable();
            bb.getMetaAccess().lookupJavaType(Counter.class).registerAsReachable();
            bb.getMetaAccess().lookupJavaType(AllocationCounter.class).registerAsReachable();
            NativeImageGenerator.registerGraphBuilderPlugins(featureHandler, null, aProviders, aMetaAccess, aUniverse, null, null, nativeLibraries, loader, ParsingReason.PointsToAnalysis, bb.getAnnotationSubstitutionProcessor(), classInitializationPlugin, bb.getHostVM().getClassInitializationSupport(), ConfigurationValues.getTarget());
            NativeImageGenerator.registerReplacements(debug, featureHandler, null, (Providers)aProviders, true, initForeignCalls);
            for (StructuredGraph graph : aReplacements.getSnippetGraphs((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(options), options)) {
                HostedConfiguration.instance().createMethodTypeFlowBuilder((PointsToAnalysis)((NativeImagePointsToAnalysis)bb), graph).registerUsedElements(false);
            }
        }
    }

    public static Inflation createBigBang(OptionValues options, TargetDescription target, AnalysisUniverse aUniverse, ForkJoinPool analysisExecutor, Runnable heartbeatCallback, AnalysisMetaAccess aMetaAccess, AnalysisConstantReflectionProvider aConstantReflection, WordTypes aWordTypes, SnippetReflectionProvider aSnippetReflection, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForeignCallsProvider aForeignCalls, ClassInitializationSupport classInitializationSupport, Providers originalProviders) {
        assert (aUniverse != null) : "Analysis universe must be initialized.";
        aMetaAccess.lookupJavaType(String.class).registerAsReachable();
        AnalysisConstantFieldProvider aConstantFieldProvider = new AnalysisConstantFieldProvider(aUniverse, aMetaAccess, aConstantReflection, classInitializationSupport);
        aMetaAccess.lookupJavaType(Reference.class).registerAsReachable();
        BarrierSet barrierSet = ((Heap)ImageSingletons.lookup(Heap.class)).createBarrierSet((MetaAccessProvider)aMetaAccess);
        SubstratePlatformConfigurationProvider platformConfig = new SubstratePlatformConfigurationProvider(barrierSet);
        MetaAccessExtensionProvider aMetaAccessExtensionProvider = HostedConfiguration.instance().createAnalysisMetaAccessExtensionProvider();
        LoweringProvider aLoweringProvider = SubstrateLoweringProvider.createForHosted((MetaAccessProvider)aMetaAccess, null, platformConfig, aMetaAccessExtensionProvider);
        SubstrateStampProvider aStampProvider = new SubstrateStampProvider((MetaAccessProvider)aMetaAccess);
        HostedProviders aProviders = new HostedProviders((MetaAccessProvider)aMetaAccess, null, (ConstantReflectionProvider)aConstantReflection, (ConstantFieldProvider)aConstantFieldProvider, aForeignCalls, aLoweringProvider, null, (StampProvider)aStampProvider, aSnippetReflection, aWordTypes, (PlatformConfigurationProvider)platformConfig, aMetaAccessExtensionProvider, originalProviders.getLoopsDataProvider());
        ResolvedJavaMethodBytecodeProvider bytecodeProvider = new ResolvedJavaMethodBytecodeProvider();
        SubstrateReplacements aReplacments = new SubstrateReplacements((Providers)aProviders, aSnippetReflection, (BytecodeProvider)bytecodeProvider, target, aWordTypes, new SubstrateGraphMakerFactory(aWordTypes));
        aProviders = new HostedProviders((MetaAccessProvider)aMetaAccess, null, (ConstantReflectionProvider)aConstantReflection, (ConstantFieldProvider)aConstantFieldProvider, aForeignCalls, aLoweringProvider, (Replacements)aReplacments, (StampProvider)aStampProvider, aSnippetReflection, aWordTypes, (PlatformConfigurationProvider)platformConfig, aMetaAccessExtensionProvider, originalProviders.getLoopsDataProvider());
        return new NativeImagePointsToAnalysis(options, aUniverse, aProviders, annotationSubstitutionProcessor, analysisExecutor, heartbeatCallback, new SubstrateUnsupportedFeatures(), (TimerCollection)ImageSingletons.lookup(TimerCollection.class));
    }

    private NativeLibraries setupNativeLibraries(String imageName, ConstantReflectionProvider aConstantReflection, MetaAccessProvider aMetaAccess, SnippetReflectionProvider aSnippetReflection, CEnumCallWrapperSubstitutionProcessor cEnumProcessor, ClassInitializationSupport classInitializationSupport, DebugContext debug) {
        try (Timer.StopTimer ignored = TimerCollection.createTimerAndStart((String)imageName, (String)"(cap)");){
            NativeLibraries nativeLibs = new NativeLibraries(aConstantReflection, aMetaAccess, aSnippetReflection, ConfigurationValues.getTarget(), classInitializationSupport, ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory(), debug);
            cEnumProcessor.setNativeLibraries(nativeLibs);
            this.processNativeLibraryImports(nativeLibs, aMetaAccess, classInitializationSupport);
            ImageSingletons.add(SizeOfSupport.class, (Object)new SizeOfSupportImpl(nativeLibs, aMetaAccess));
            ImageSingletons.add(OffsetOf.Support.class, (Object)new OffsetOfSupportImpl(nativeLibs, aMetaAccess));
            ImageSingletons.add(CConstantValueSupport.class, (Object)new CConstantValueSupportImpl(nativeLibs, aMetaAccess));
            if (CAnnotationProcessorCache.Options.ExitAfterQueryCodeGeneration.getValue().booleanValue()) {
                throw new InterruptImageBuilding("Exiting image generation because of " + SubstrateOptionsParser.commandArgument(CAnnotationProcessorCache.Options.ExitAfterQueryCodeGeneration, "+"));
            }
            if (CAnnotationProcessorCache.Options.ExitAfterCAPCache.getValue().booleanValue()) {
                throw new InterruptImageBuilding("Exiting image generation because of " + SubstrateOptionsParser.commandArgument(CAnnotationProcessorCache.Options.ExitAfterCAPCache, "+"));
            }
            NativeLibraries nativeLibraries = nativeLibs;
            return nativeLibraries;
        }
    }

    private void registerEntryPoints(Map<Method, CEntryPointData> entryPoints) {
        for (Method m : this.loader.findAnnotatedMethods(CEntryPoint.class)) {
            if (!Modifier.isStatic(m.getModifiers())) {
                throw UserError.abort("Entry point method %s.%s is not static. Add a static modifier to the method.", m.getDeclaringClass().getName(), m.getName());
            }
            Class cEntryPointIncludeClass = m.getAnnotation(CEntryPoint.class).include();
            if (!((BooleanSupplier)ReflectionUtil.newInstance((Class)cEntryPointIncludeClass)).getAsBoolean()) continue;
            entryPoints.put(m, CEntryPointData.create(m));
        }
    }

    private static void recordRestrictHeapAccessCallees(Collection<AnalysisMethod> methods) {
        ((RestrictHeapAccessCalleesImpl)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).aggregateMethods(methods);
    }

    public static void registerGraphBuilderPlugins(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, HostedProviders providers, AnalysisMetaAccess aMetaAccess, AnalysisUniverse aUniverse, HostedMetaAccess hMetaAccess, HostedUniverse hUniverse, NativeLibraries nativeLibs, ImageClassLoader loader, ParsingReason reason, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ClassInitializationPlugin classInitializationPlugin, ClassInitializationSupport classInitializationSupport, TargetDescription target) {
        Object pluginsMetaAccess;
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins((InvocationPlugins)new SubstitutionInvocationPlugins(annotationSubstitutionProcessor));
        SubstrateWordOperationPlugins wordOperationPlugin = new SubstrateWordOperationPlugins(providers.getSnippetReflection(), providers.getWordTypes());
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)replacements);
        plugins.appendNodePlugin((NodePlugin)new IntrinsifyMethodHandlesInvocationPlugin(reason, (Providers)providers, aUniverse, hUniverse));
        plugins.appendNodePlugin((NodePlugin)new DeletedFieldsPlugin());
        plugins.appendNodePlugin((NodePlugin)new InjectedAccessorsPlugin());
        ResolvedJavaType resolvedJavaType = providers.getMetaAccess().lookupJavaType(ClassInitializationTracking.class);
        if (resolvedJavaType instanceof AnalysisType) {
            ((AnalysisType)resolvedJavaType).registerAsReachable();
            ResolvedJavaField field = providers.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(ClassInitializationTracking.class, (String)"IS_IMAGE_BUILD_TIME"));
            ((AnalysisField)field).registerAsAccessed();
        }
        plugins.appendNodePlugin((NodePlugin)new EarlyConstantFoldLoadFieldPlugin(providers.getMetaAccess(), providers.getSnippetReflection()));
        plugins.appendNodePlugin((NodePlugin)new ConstantFoldLoadFieldPlugin(classInitializationSupport));
        plugins.appendNodePlugin((NodePlugin)new CInterfaceInvocationPlugin(providers.getMetaAccess(), providers.getWordTypes(), nativeLibs));
        plugins.appendNodePlugin((NodePlugin)new LocalizationFeature.CharsetNodePlugin());
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        plugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        plugins.setClassInitializationPlugin(classInitializationPlugin);
        featureHandler.forEachGraalFeature(feature -> feature.registerGraphBuilderPlugins((Providers)providers, plugins, reason));
        HostedSnippetReflectionProvider hostedSnippetReflection = new HostedSnippetReflectionProvider(new SubstrateWordTypes((MetaAccessProvider)aMetaAccess, FrameAccess.getWordKind()));
        final HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        NodeIntrinsificationProvider nodeIntrinsificationProvider = !SubstrateUtil.isBuildingLibgraal() ? new NodeIntrinsificationProvider(providers.getMetaAccess(), (SnippetReflectionProvider)hostedSnippetReflection, providers.getForeignCalls(), providers.getWordTypes(), target) : new NodeIntrinsificationProvider(providers.getMetaAccess(), hostedSnippetReflection, providers.getForeignCalls(), providers.getWordTypes(), target){

            public <T> T getInjectedArgument(Class<T> type) {
                if (type.isAssignableFrom(GraalHotSpotVMConfig.class)) {
                    return type.cast(compiler.getGraalRuntime().getVMConfig());
                }
                if (type.isAssignableFrom(HotSpotGraalRuntimeProvider.class)) {
                    return type.cast(compiler.getGraalRuntime());
                }
                return (T)super.getInjectedArgument(type);
            }
        };
        for (Class<GeneratedPluginFactory> factoryClass : loader.findSubclasses(GeneratedPluginFactory.class, true)) {
            GeneratedPluginFactory factory;
            if (Modifier.isAbstract(factoryClass.getModifiers()) || factoryClass.getName().contains("hotspot")) continue;
            try {
                factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            factory.registerPlugins(plugins.getInvocationPlugins(), (GeneratedPluginInjectionProvider)nodeIntrinsificationProvider);
        }
        boolean arrayEqualsSubstitution = !SubstrateOptions.useLLVMBackend();
        StandardGraphBuilderPlugins.registerInvocationPlugins((SnippetReflectionProvider)providers.getSnippetReflection(), (InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)replacements, (reason == ParsingReason.JITCompilation ? 1 : 0) != 0, (boolean)true, (boolean)arrayEqualsSubstitution, (LoweringProvider)providers.getLowerer());
        Architecture architecture = ConfigurationValues.getTarget().arch;
        OptionValues options = aUniverse.hostVM().options();
        ((TargetGraphBuilderPlugins)ImageSingletons.lookup(TargetGraphBuilderPlugins.class)).register(plugins, (Replacements)replacements, architecture, false, options);
        if (reason == ParsingReason.PointsToAnalysis || reason == ParsingReason.JITCompilation) {
            pluginsMetaAccess = aMetaAccess;
        } else {
            VMError.guarantee(reason == ParsingReason.AOTCompilation);
            pluginsMetaAccess = hMetaAccess;
        }
        assert (pluginsMetaAccess != null);
        SubstrateGraphBuilderPlugins.registerInvocationPlugins(annotationSubstitutionProcessor, (MetaAccessProvider)pluginsMetaAccess, hostedSnippetReflection, plugins.getInvocationPlugins(), (Replacements)replacements, reason);
        featureHandler.forEachGraalFeature(feature -> feature.registerInvocationPlugins((Providers)providers, hostedSnippetReflection, plugins, reason));
        providers.setGraphBuilderPlugins(plugins);
        replacements.setGraphBuilderPlugins(plugins);
        if (runtimeConfig != null && runtimeConfig.getProviders() instanceof HostedProviders) {
            ((HostedProviders)runtimeConfig.getProviders()).setGraphBuilderPlugins(plugins);
            for (SubstrateBackend backend : runtimeConfig.getBackends()) {
                ((HostedProviders)backend.getProviders()).setGraphBuilderPlugins(plugins);
            }
        }
    }

    public static void registerReplacements(DebugContext debug, FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, Providers providers, boolean hosted, boolean initForeignCalls) {
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)providers.getForeignCalls();
        if (initForeignCalls) {
            SnippetRuntime.registerForeignCalls(foreignCallsProvider);
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerForeignCalls(foreignCallsProvider));
        try (DebugContext.Scope s = debug.scope((Object)"RegisterLowerings", (Object)new DebugDumpScope("RegisterLowerings"));){
            SubstrateLoweringProvider lowerer = (SubstrateLoweringProvider)providers.getLowerer();
            Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = lowerer.getLowerings();
            lowerer.setConfiguration(runtimeConfig, (OptionValues)options, providers);
            TypeSnippets.registerLowerings(options, providers, lowerings);
            ExceptionSnippets.registerLowerings(options, providers, lowerings);
            if (hosted) {
                DeoptHostedSnippets.registerLowerings(options, providers, lowerings);
            } else {
                DeoptRuntimeSnippets.registerLowerings(options, providers, lowerings);
            }
            featureHandler.forEachGraalFeature(arg_0 -> NativeImageGenerator.lambda$registerReplacements$22(runtimeConfig, (OptionValues)options, providers, lowerings, hosted, arg_0));
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        assert (NativeImageGenerator.checkInvocationPluginMethods(replacements));
        replacements.encodeSnippets();
    }

    private static boolean checkInvocationPluginMethods(SubstrateReplacements replacements) {
        Iterator<ResolvedJavaMethod> iterator = replacements.getDelayedInvocationPluginMethods().iterator();
        while (iterator.hasNext()) {
            String hostedDescriptor;
            String runtimeDescriptor;
            ResolvedJavaMethod method;
            ResolvedJavaMethod unwrapped = method = iterator.next();
            while (unwrapped instanceof WrappedJavaMethod) {
                unwrapped = ((WrappedJavaMethod)unwrapped).getWrapped();
            }
            if (method != unwrapped && !(runtimeDescriptor = method.getSignature().toMethodDescriptor()).equals(hostedDescriptor = unwrapped.getSignature().toMethodDescriptor())) {
                String name = method.format("%H.%n");
                throw new AssertionError((Object)String.format("Cannot have invocation plugin for a method whose runtime signature is different from its hosted signature:%n            method: %s%n  hosted signature: %s%n runtime signature: %s", name, runtimeDescriptor, hostedDescriptor));
            }
            assert (method == unwrapped || method.getSignature().toMethodDescriptor().equals(unwrapped.getSignature().toMethodDescriptor()));
        }
        return true;
    }

    public static Suites createSuites(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted) {
        SubstrateBackend backend = runtimeConfig.getBackendForNormalMethod();
        Suites suites = hosted ? GraalConfiguration.hostedInstance().createSuites(HostedOptionValues.singleton(), hosted) : GraalConfiguration.runtimeInstance().createSuites((OptionValues)RuntimeOptionValues.singleton(), hosted);
        return NativeImageGenerator.modifySuites(backend, suites, featureHandler, runtimeConfig, snippetReflection, hosted, false);
    }

    public static Suites createFirstTierSuites(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted) {
        SubstrateBackend backend = runtimeConfig.getBackendForNormalMethod();
        Suites suites = hosted ? GraalConfiguration.hostedInstance().createFirstTierSuites(HostedOptionValues.singleton(), hosted) : GraalConfiguration.runtimeInstance().createFirstTierSuites((OptionValues)RuntimeOptionValues.singleton(), hosted);
        return NativeImageGenerator.modifySuites(backend, suites, featureHandler, runtimeConfig, snippetReflection, hosted, true);
    }

    private static Suites modifySuites(SubstrateBackend backend, Suites suites, FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted, boolean firstTier) {
        Providers runtimeCallProviders = backend.getProviders();
        PhaseSuite highTier = suites.getHighTier();
        PhaseSuite midTier = suites.getMidTier();
        PhaseSuite lowTier = suites.getLowTier();
        boolean economy = firstTier || SubstrateOptions.useEconomyCompilerConfig();
        ListIterator position = hosted ? GraalConfiguration.hostedInstance().createHostedInliners((PhaseSuite<HighTierContext>)highTier) : highTier.findPhase(InliningPhase.class);
        if (position != null) {
            position.add(new DeadStoreRemovalPhase());
            position.add(new RemoveUnwindPhase());
        } else {
            highTier.prependPhase((BasePhase)new RemoveUnwindPhase());
            highTier.prependPhase((BasePhase)new DeadStoreRemovalPhase());
        }
        lowTier.addBeforeLast((BasePhase)new OptimizeExceptionPathsPhase());
        BasePhase<CoreProviders> addressLoweringPhase = backend.newAddressLoweringPhase(runtimeCallProviders.getCodeCache());
        if (economy) {
            lowTier.findPhase(ExpandLogicPhase.class, true).add(addressLoweringPhase);
        } else {
            lowTier.findPhase(UseTrappingNullChecksPhase.class).add(addressLoweringPhase);
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            midTier.findPhase(LoopSafepointInsertionPhase.class).set(new SubstrateSafepointInsertionPhase());
        } else {
            VMError.guarantee(midTier.removePhase(LoopSafepointInsertionPhase.class));
        }
        if (hosted) {
            lowTier.appendPhase((BasePhase)new VerifyNoGuardsPhase());
            highTier.removePhase(InliningPhase.class);
            highTier.removePhase(ConvertDeoptimizeToGuardPhase.class);
            midTier.removePhase(DeoptimizationGroupingPhase.class);
        } else if (economy) {
            ListIterator it = midTier.findPhase(FrameStateAssignmentPhase.class);
            it.add(new CollectDeoptimizationSourcePositionsPhase());
            it = midTier.findLastPhase();
            it.add(CanonicalizerPhase.create());
        } else {
            ListIterator it = midTier.findPhase(DeoptimizationGroupingPhase.class);
            it.previous();
            it.add(new CollectDeoptimizationSourcePositionsPhase());
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerGraalPhases(runtimeCallProviders, snippetReflection, suites, hosted));
        if (hosted && ((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(HostedOptionValues.singleton())).booleanValue()) {
            highTier.prependPhase((BasePhase)new ImageBuildStatisticsCounterPhase(ImageBuildStatistics.CheckCountLocation.BEFORE_HIGH_TIER));
            highTier.prependPhase((BasePhase)CanonicalizerPhase.create());
            highTier.findLastPhase().add(CanonicalizerPhase.create());
            highTier.findLastPhase().add(new ImageBuildStatisticsCounterPhase(ImageBuildStatistics.CheckCountLocation.AFTER_HIGH_TIER));
        }
        return suites;
    }

    public static LIRSuites createLIRSuites(FeatureHandler featureHandler, Providers providers, boolean hosted) {
        LIRSuites lirSuites;
        if (hosted) {
            lirSuites = GraalConfiguration.hostedInstance().createLIRSuites(HostedOptionValues.singleton());
            lirSuites.getFinalCodeAnalysisStage().appendPhase((LIRPhase)new VerifyCFunctionReferenceMapsLIRPhase());
        } else {
            lirSuites = GraalConfiguration.runtimeInstance().createLIRSuites((OptionValues)RuntimeOptionValues.singleton());
        }
        assert (NativeImageGenerator.addAssertionLIRPhases(lirSuites, hosted));
        return lirSuites;
    }

    public static LIRSuites createFirstTierLIRSuites(FeatureHandler featureHandler, Providers providers, boolean hosted) {
        LIRSuites lirSuites;
        if (hosted) {
            lirSuites = GraalConfiguration.hostedInstance().createFirstTierLIRSuites(HostedOptionValues.singleton());
            lirSuites.getFinalCodeAnalysisStage().appendPhase((LIRPhase)new VerifyCFunctionReferenceMapsLIRPhase());
        } else {
            lirSuites = GraalConfiguration.runtimeInstance().createFirstTierLIRSuites((OptionValues)RuntimeOptionValues.singleton());
        }
        assert (NativeImageGenerator.addAssertionLIRPhases(lirSuites, hosted));
        return lirSuites;
    }

    private static boolean addAssertionLIRPhases(LIRSuites lirSuites, boolean hosted) {
        if (hosted) {
            lirSuites.getFinalCodeAnalysisStage().appendPhase((LIRPhase)new VerifyDeoptFrameStatesLIRPhase());
        }
        return true;
    }

    private static String format(BigBang bb, TypeState state) {
        return state.typesStream(bb).map(t -> t.toJavaName(true)).collect(Collectors.joining(","));
    }

    private void checkUniverse() {
        if (this.bb instanceof NativeImagePointsToAnalysis) {
            NativeImagePointsToAnalysis bigbang = (NativeImagePointsToAnalysis)this.bb;
            for (AnalysisMethod m : this.aUniverse.getMethods()) {
                PointsToAnalysisMethod method = PointsToAnalysis.assertPointsToAnalysisMethod((AnalysisMethod)m);
                for (TypeFlow parameter : method.getTypeFlow().getParameters()) {
                    TypeState declaredTypeState;
                    AnalysisType declaredType;
                    TypeState parameterState = method.getTypeFlow().foldTypeFlow((PointsToAnalysis)bigbang, parameter);
                    if (parameterState == null || !(declaredType = parameter.getDeclaredType()).isInterface() || (parameterState = TypeState.forSubtraction((PointsToAnalysis)bigbang, (TypeState)parameterState, (TypeState)(declaredTypeState = declaredType.getAssignableTypes(true)))).isEmpty()) continue;
                    String methodKey = method.format("%H.%n(%p)");
                    bigbang.getUnsupportedFeatures().addMessage(methodKey, (AnalysisMethod)method, "Parameter " + ((FormalParamTypeFlow)parameter).position() + " of " + methodKey + " has declared type " + declaredType.toJavaName(true) + ", with assignable types: " + NativeImageGenerator.format(this.bb, declaredTypeState) + ", which is incompatible with analysis inferred types: " + NativeImageGenerator.format(this.bb, parameterState) + ".");
                }
            }
            for (AnalysisField field : this.aUniverse.getFields()) {
                TypeState declaredTypeState;
                AnalysisType declaredType;
                TypeState state = field.getTypeState();
                if (state == null || !(declaredType = field.getType()).isInterface() || (state = TypeState.forSubtraction((PointsToAnalysis)bigbang, (TypeState)state, (TypeState)(declaredTypeState = declaredType.getAssignableTypes(true)))).isEmpty()) continue;
                String fieldKey = field.format("%H.%n");
                bigbang.getUnsupportedFeatures().addMessage(fieldKey, null, "Field " + fieldKey + " has declared type " + declaredType.toJavaName(true) + ", with assignable types: " + NativeImageGenerator.format(this.bb, declaredTypeState) + ", which is incompatible with analysis inferred types: " + NativeImageGenerator.format(this.bb, state) + ".");
            }
        }
        if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue()) {
            for (AnalysisMethod method : this.aUniverse.getMethods()) {
                if (!method.isInvoked() && !method.isReachable() || method.getAnnotation(Fold.class) != null) continue;
                NativeImageGenerator.checkName(method.format("%H.%n(%p)"), method, this.bb);
            }
            for (AnalysisField field : this.aUniverse.getFields()) {
                if (!field.isAccessed()) continue;
                NativeImageGenerator.checkName(field.format("%H.%n"), null, this.bb);
            }
            for (AnalysisType type : this.aUniverse.getTypes()) {
                if (!type.isReachable()) continue;
                NativeImageGenerator.checkName(type.toJavaName(true), null, this.bb);
            }
        }
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            Set invocations;
            if (!method.isEntryPoint() || (invocations = method.getCallers()).size() <= 0) continue;
            String name = method.format("%H.%n(%p)");
            StringBuilder msg = new StringBuilder("Native entry point is also called from within Java. Invocations: ");
            String sep = "";
            for (AnalysisMethod invocation : invocations) {
                msg.append(sep).append(invocation.format("%H.%n(%p)"));
                sep = ", ";
            }
            this.bb.getUnsupportedFeatures().addMessage(name, method, msg.toString());
        }
    }

    public static void checkName(String name, AnalysisMethod method, BigBang bb) {
        String lname = name.toLowerCase();
        String message = null;
        if (lname.contains("hosted")) {
            message = "Hosted element used at run time: " + name;
        } else if (!name.startsWith("jdk.internal") && lname.contains("hotspot")) {
            message = "HotSpot element used at run time: " + name;
        }
        if (message != null) {
            if (bb != null) {
                bb.getUnsupportedFeatures().addMessage(name, method, message);
            } else {
                throw new UnsupportedFeatureException(message);
            }
        }
    }

    private void processNativeLibraryImports(NativeLibraries nativeLibs, MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        for (Method method : this.loader.findAnnotatedMethods(CConstant.class)) {
            if (!LibCBase.isMethodProvidedInCurrentLibc(method)) continue;
            classInitializationSupport.initializeAtBuildTime(method.getDeclaringClass(), "classes with " + CConstant.class.getSimpleName() + " annotations are always initialized");
            nativeLibs.loadJavaMethod(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Method method : this.loader.findAnnotatedMethods(CFunction.class)) {
            if (!LibCBase.isMethodProvidedInCurrentLibc(method)) continue;
            nativeLibs.loadJavaMethod(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CStruct.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + CStruct.class.getSimpleName() + " are always initialized");
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(RawStructure.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + RawStructure.class.getSimpleName() + " are always initialized");
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CPointerTo.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + CPointerTo.class.getSimpleName() + " are always initialized");
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(RawPointerTo.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + RawPointerTo.class.getSimpleName() + " are always initialized");
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CEnum.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            ResolvedJavaType type = metaAccess.lookupJavaType(clazz);
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + CEnum.class.getSimpleName() + " are always initialized");
            nativeLibs.loadJavaType(type);
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CContext.class, false)) {
            if (!LibCBase.isTypeProvidedInCurrentLibc(clazz)) continue;
            classInitializationSupport.initializeAtBuildTime(clazz, "classes annotated with " + CContext.class.getSimpleName() + " are always initialized");
        }
        nativeLibs.processCLibraryAnnotations(this.loader);
        nativeLibs.finish();
        nativeLibs.reportErrors();
    }

    public AbstractImage getBuiltImage() {
        return this.image;
    }

    public BigBang getBigbang() {
        return this.bb;
    }

    public Map<BuildArtifacts.ArtifactType, List<Path>> getBuildArtifacts() {
        return this.buildArtifacts;
    }

    private void printTypes() {
        for (HostedType type : this.hUniverse.getTypes()) {
            Object arrayType;
            int n;
            System.out.format("%8d %s  ", type.getTypeID(), type.toJavaName(true));
            if (type.getSuperclass() != null) {
                System.out.format("extends %d %s  ", type.getSuperclass().getTypeID(), type.getSuperclass().toJavaName(false));
            }
            if (type.getInterfaces().length > 0) {
                System.out.print("implements ");
                String sep = "";
                HostedInterface[] hostedInterfaceArray = type.getInterfaces();
                int n2 = hostedInterfaceArray.length;
                for (n = 0; n < n2; ++n) {
                    HostedInterface interf = hostedInterfaceArray[n];
                    System.out.format("%s%d %s", sep, interf.getTypeID(), interf.toJavaName(false));
                    sep = ", ";
                }
                System.out.print("  ");
            }
            if (type.getWrapped().isInstantiated()) {
                System.out.print("instantiated  ");
            }
            if (type.getWrapped().isReachable()) {
                System.out.print("reachable  ");
            }
            System.out.format("type check start %d range %d slot # %d ", type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot());
            System.out.format("type check slots %s  ", NativeImageGenerator.slotsToString(type.getTypeCheckSlots()));
            int le = type.getHub().getLayoutEncoding();
            if (LayoutEncoding.isPrimitive(le)) {
                System.out.print("primitive  ");
            } else if (LayoutEncoding.isInterface(le)) {
                System.out.print("interface  ");
            } else if (LayoutEncoding.isAbstract(le)) {
                System.out.print("abstract  ");
            } else if (LayoutEncoding.isPureInstance(le)) {
                System.out.format("instance size %d  ", LayoutEncoding.getPureInstanceSize(le).rawValue());
            } else if (LayoutEncoding.isArrayLike(le)) {
                arrayType = LayoutEncoding.isHybrid(le) ? "hybrid" : "array";
                String elements = LayoutEncoding.isArrayLikeWithPrimitiveElements(le) ? "primitives" : "objects";
                System.out.format("%s containing %s, base %d shift %d scale %d  ", arrayType, elements, LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else {
                throw VMError.shouldNotReachHere();
            }
            System.out.println();
            arrayType = type.getSubTypes();
            int elements = ((HostedType[])arrayType).length;
            for (n = 0; n < elements; ++n) {
                HostedType sub = arrayType[n];
                System.out.format("               s %d %s\n", sub.getTypeID(), sub.toJavaName(false));
            }
            if (type.isInterface()) {
                for (HostedMethod method : this.hUniverse.getMethods()) {
                    if (method.getDeclaringClass() != type) continue;
                    NativeImageGenerator.printMethod(method, -1);
                }
                continue;
            }
            if (!type.isInstanceClass()) continue;
            HostedField[] fields = type.getInstanceFields(false);
            fields = Arrays.copyOf(fields, fields.length);
            Arrays.sort(fields, Comparator.comparing(HostedField::toString));
            HostedField[] method = fields;
            n = method.length;
            for (int sub = 0; sub < n; ++sub) {
                HostedField field = method[sub];
                System.out.println("               f " + field.getLocation() + ": " + field.format("%T %n"));
            }
            HostedMethod[] vtable = type.getVTable();
            for (int i = 0; i < vtable.length; ++i) {
                if (vtable[i] == null) continue;
                NativeImageGenerator.printMethod(vtable[i], i);
            }
            for (HostedMethod method2 : this.hUniverse.getMethods()) {
                if (method2.getDeclaringClass() != type || method2.hasVTableIndex()) continue;
                NativeImageGenerator.printMethod(method2, -1);
            }
        }
    }

    private static void printMethod(HostedMethod method, int vtableIndex) {
        if (vtableIndex != -1) {
            System.out.print("               v " + vtableIndex + " ");
        } else {
            System.out.print("               m ");
        }
        if (method.hasVTableIndex()) {
            System.out.print(method.getVTableIndex() + " ");
        }
        System.out.print(method.format("%r %n(%p)") + ": " + method.getImplementations().length + " [");
        if (method.getImplementations().length <= 10) {
            String sep = "";
            for (HostedMethod impl : method.getImplementations()) {
                System.out.print(sep + impl.getDeclaringClass().toJavaName(false));
                sep = ", ";
            }
        }
        System.out.println("]");
    }

    private static String slotsToString(short[] slots) {
        if (slots == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        for (short slot : slots) {
            result.append(Short.toUnsignedInt(slot)).append(" ");
        }
        return result.toString();
    }

    public static Path generatedFiles(OptionValues optionValues) {
        String pathName = (String)SubstrateOptions.Path.getValue(optionValues);
        Path path = FileSystems.getDefault().getPath(pathName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw VMError.shouldNotReachHere("Output path is not a directory: " + pathName);
        }
        return path.toAbsolutePath();
    }

    private static <T extends Enum<T>> Set<T> parseCSVtoEnum(Class<T> enumType, List<String> csvEnumValues, T[] availValues) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (String enumValue : OptionUtils.flatten(",", csvEnumValues)) {
            try {
                result.add(Enum.valueOf(enumType, enumValue));
            }
            catch (IllegalArgumentException iae) {
                throw VMError.shouldNotReachHere("Value '" + enumValue + "' does not exist. Available values are:\n" + Arrays.toString(availValues));
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$registerReplacements$22(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map lowerings, boolean hosted, InternalFeature feature) {
        feature.registerLowerings(runtimeConfig, options, providers, lowerings, hosted);
    }

    private /* synthetic */ Boolean lambda$runPointsToAnalysis$11(FeatureImpl.DuringAnalysisAccessImpl config, AnalysisUniverse universe) {
        try (Timer.StopTimer t2 = TimerCollection.createTimerAndStart((TimerCollection.Registry)TimerCollection.Registry.FEATURES);){
            this.bb.getHostVM().notifyClassReachabilityListener(universe, config);
            this.featureHandler.forEachFeature(feature -> feature.duringAnalysis((Feature.DuringAnalysisAccess)config));
        }
        return !config.getAndResetRequireAnalysisIteration();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static class SubstitutionInvocationPlugins
    extends InvocationPlugins {
        private AnnotationSubstitutionProcessor annotationSubstitutionProcessor;

        SubstitutionInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutionProcessor) {
            this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        }

        protected void register(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
            Class<?> targetClass = declaringClass instanceof Class ? this.annotationSubstitutionProcessor.getTargetClass(declaringClass) : declaringClass;
            super.register(targetClass, plugin, allowOverwrite);
        }
    }
}

