/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.CounterGroupList;
import com.oracle.svm.core.util.CounterSupport;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Counter {
    protected final Group group;
    protected final String name;
    protected final String description;
    protected long value;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Field VALUE_FIELD;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Counter(Group group, String name, String description) {
        this.group = group;
        this.name = name;
        this.description = description;
        group.counters = Arrays.copyOf(group.counters, group.counters.length + 1);
        group.counters[group.counters.length - 1] = this;
    }

    @NeverInline(value="Counters can be incremented in snippets, prevent wrong memory access reordering")
    public long getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    @AlwaysInline(value="Constant folding and dead code elimination remove code for disabled counters")
    @Uninterruptible(reason="Gets always inlined", mayBeInlined=true)
    public void inc() {
        this.add(1L);
    }

    @AlwaysInline(value="Constant folding and dead code elimination remove code for disabled counters")
    @Uninterruptible(reason="Gets always inlined", mayBeInlined=true)
    public void add(long increment) {
        if (this.group.enabled) {
            this.value += increment;
        }
    }

    @NeverInline(value="Counters can be incremented in snippets, prevent wrong memory access reordering")
    public void reset() {
        this.value = 0L;
    }

    public static void logValues(Log log) {
        for (Group group : ((CounterSupport)ImageSingletons.lookup(CounterSupport.class)).enabledGroups) {
            group.logValues(log);
        }
    }

    static {
        try {
            VALUE_FIELD = Counter.class.getDeclaredField("value");
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static final class Group {
        protected final String name;
        protected Counter[] counters = new Counter[0];
        @Platforms(value={Platform.HOSTED_ONLY.class})
        final HostedOptionKey<Boolean> enabledOption;
        protected boolean enabled;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public Group(HostedOptionKey<Boolean> enabledOption, String name) {
            this.name = name;
            this.enabledOption = enabledOption;
            ((CounterGroupList)ImageSingletons.lookup(CounterGroupList.class)).addGroup(this);
        }

        public Counter[] getCounters() {
            return this.counters;
        }

        public void reset() {
            for (Counter counter : this.counters) {
                counter.reset();
            }
        }

        public void logValues(Log log) {
            long total = 0L;
            int maxNameLen = 0;
            for (Counter counter : this.counters) {
                total += counter.getValue();
                maxNameLen = Math.max(counter.name.length(), maxNameLen);
            }
            log.string("=== ").string(this.name).string(" ===").newline();
            for (Counter counter : this.counters) {
                long counterValue = counter.getValue();
                long percent = total == 0L ? 0L : counterValue * 100L / total;
                log.string("  ").string(counter.name, maxNameLen, 2).string(":");
                log.unsigned(counterValue, 10, 2).unsigned(percent, 5, 2).string("%");
                if (!counter.description.isEmpty()) {
                    log.string("  // ").string(counter.description);
                }
                log.newline();
            }
            log.string("  ").string("TOTAL", maxNameLen, 2).string(":");
            log.unsigned(total, 10, 2).newline();
        }
    }
}

