/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_util_concurrent_ForkJoinWorkerThread;
import com.oracle.svm.core.thread.Target_java_util_concurrent_ThreadPoolExecutor_Worker;
import com.oracle.svm.core.thread.ThreadData;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class PlatformThreads {
    static final FastThreadLocalObject<Thread> currentThread = (FastThreadLocalObject)FastThreadLocalFactory.createObject(Thread.class, "PlatformThreads.currentThread").setMaxOffset(127);
    static final FastThreadLocalObject<Object> lockHelper = (FastThreadLocalObject)FastThreadLocalFactory.createObject(Object.class, "PlatformThreads.lockHelper").setMaxOffset(127);
    private static final UninterruptibleUtils.AtomicInteger nonDaemonThreads = new UninterruptibleUtils.AtomicInteger(1);
    private final AtomicInteger unattachedStartedThreads = new AtomicInteger(0);
    final ThreadGroup mainGroup = Thread.currentThread().getThreadGroup();
    public final ThreadGroup systemGroup;
    final Thread mainThread;
    final Thread[] mainGroupThreadsArray;

    @Fold
    public static PlatformThreads singleton() {
        return (PlatformThreads)ImageSingletons.lookup(PlatformThreads.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected PlatformThreads() {
        VMError.guarantee(this.mainGroup.getName().equals("main"), "Wrong ThreadGroup for main");
        this.systemGroup = this.mainGroup.getParent();
        VMError.guarantee(this.systemGroup.getParent() == null && this.systemGroup.getName().equals("system"), "Wrong ThreadGroup for system");
        this.mainThread = new Thread(this.mainGroup, "main");
        this.mainThread.setDaemon(false);
        this.mainGroupThreadsArray = new Thread[4];
        this.mainGroupThreadsArray[0] = this.mainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.")
    public static long getThreadAllocatedBytes(long javaThreadId) {
        Thread curThread = currentThread.get();
        if (curThread != null && curThread.getId() == javaThreadId) {
            return Heap.getHeap().getThreadAllocatedMemory(CurrentIsolate.getCurrentThread());
        }
        VMThreads.lockThreadMutexInNativeCode();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread javaThread = currentThread.get(isolateThread);
                if (javaThread != null && javaThread.getId() == javaThreadId) {
                    long l = Heap.getHeap().getThreadAllocatedMemory(isolateThread);
                    return l;
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
            long l = -1L;
            return l;
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.")
    public static void getThreadAllocatedBytes(long[] javaThreadIds, long[] result) {
        VMThreads.lockThreadMutexInNativeCode();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread javaThread = currentThread.get(isolateThread);
                if (javaThread != null) {
                    for (int i = 0; i < javaThreadIds.length; ++i) {
                        if (javaThread.getId() != javaThreadIds[i]) continue;
                        result[i] = Heap.getHeap().getThreadAllocatedMemory(isolateThread);
                        break;
                    }
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    static void setInterrupt(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        if (!JavaThreads.isInterrupted(thread)) {
            JavaThreads.writeInterruptedFlag(thread, true);
            JavaThreads.toTarget(thread).interrupt0();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Thread fromVMThread(IsolateThread thread) {
        assert (CurrentIsolate.getCurrentThread() == thread || VMOperation.isInProgressAtSafepoint() || VMThreads.THREAD_MUTEX.isOwner() || SubstrateDiagnostics.isFatalErrorHandlingThread()) : "must prevent the isolate thread from exiting";
        return currentThread.get(thread);
    }

    public static IsolateThread getIsolateThreadUnsafe(Thread t) {
        return JavaThreads.toTarget((Thread)t).isolateThread;
    }

    public static IsolateThread getIsolateThread(Thread t) {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        VMError.guarantee(t.isAlive(), "Only running java.lang.Thread objects have a IsolateThread");
        return PlatformThreads.getIsolateThreadUnsafe(t);
    }

    static void cleanupBeforeDetach(IsolateThread thread) {
        VMError.guarantee(thread.equal((ComparableWord)CurrentIsolate.getCurrentThread()), "Cleanup must execute in detaching thread");
        Thread javaThread = currentThread.get(thread);
        if (javaThread != null) {
            JavaThreads.toTarget(javaThread).exit();
            ThreadListenerSupport.get().afterThreadExit(CurrentIsolate.getCurrentThread(), javaThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void join(Thread thread, long millis) throws InterruptedException {
        assert (!JavaThreads.isVirtual(thread));
        Thread thread2 = thread;
        synchronized (thread2) {
            if (millis > 0L) {
                if (thread.isAlive()) {
                    long startTime = System.nanoTime();
                    long delay = millis;
                    do {
                        thread.wait(delay);
                    } while (thread.isAlive() && (delay = millis - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)) > 0L);
                }
            } else {
                while (thread.isAlive()) {
                    thread.wait(0L);
                }
            }
        }
    }

    public void joinAllNonDaemons() {
        int expectedNonDaemonThreads = Thread.currentThread().isDaemon() ? 0 : 1;
        PlatformThreads.joinAllNonDaemonsTransition(expectedNonDaemonThreads);
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static void joinAllNonDaemonsTransition(int expectedNonDaemonThreads) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        PlatformThreads.joinAllNonDaemonsInNative(expectedNonDaemonThreads);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void joinAllNonDaemonsInNative(int expectedNonDaemonThreads) {
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            while (nonDaemonThreads.get() > expectedNonDaemonThreads) {
                VMThreads.THREAD_LIST_CONDITION.blockNoTransition();
            }
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    public static long getRequestedStackSize(Thread thread) {
        long threadSpecificStackSize = LoomSupport.CompatibilityUtil.getStackSize(JavaThreads.toTarget(thread));
        long stackSize = threadSpecificStackSize != 0L ? threadSpecificStackSize : SubstrateOptions.StackSize.getValue();
        if (stackSize != 0L) {
            stackSize += (long)StackOverflowCheck.singleton().yellowAndRedZoneSize();
        }
        return stackSize;
    }

    public static boolean isCurrentAssigned() {
        return currentThread.get() != null;
    }

    public static boolean ensureCurrentAssigned() {
        return PlatformThreads.ensureCurrentAssigned(null, null, true);
    }

    public static boolean ensureCurrentAssigned(String name, ThreadGroup group, boolean asDaemon) {
        if (currentThread.get() == null) {
            PlatformThreads.assignCurrent(JavaThreads.fromTarget(new Target_java_lang_Thread(name, group, asDaemon)), true);
            return true;
        }
        return false;
    }

    public static void assignCurrent(Thread thread, boolean manuallyStarted) {
        JavaThreads.setThreadStatus(thread, 5);
        PlatformThreads.assignCurrent0(thread);
        if (manuallyStarted) {
            ThreadGroup group = thread.getThreadGroup();
            JavaThreads.toTarget(group).addUnstarted();
            JavaThreads.toTarget(group).add(thread);
            if (!thread.isDaemon()) {
                nonDaemonThreads.incrementAndGet();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void assignCurrent0(Thread thread) {
        VMError.guarantee(currentThread.get() == null, "overwriting existing java.lang.Thread");
        currentThread.set(thread);
        assert (JavaThreads.toTarget((Thread)thread).isolateThread.isNull());
        JavaThreads.toTarget((Thread)thread).isolateThread = CurrentIsolate.getCurrentThread();
        ThreadListenerSupport.get().beforeThreadStart(CurrentIsolate.getCurrentThread(), thread);
    }

    static void setCurrentThread(Thread carrier, Thread thread) {
        Thread currentCarrierThread = currentThread.get();
        assert (currentCarrierThread == carrier);
        JavaThreads.toTarget((Thread)carrier).vthread = thread != currentCarrierThread ? thread : null;
    }

    @Uninterruptible(reason="Called during isolate initialization")
    public void initializeIsolate() {
        PlatformThreads.assignCurrent0(this.mainThread);
    }

    public boolean tearDown() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        return PlatformThreads.tearDownPlatformThreads();
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    public static void detachThread(IsolateThread vmThread) {
        VMThreads.THREAD_MUTEX.assertIsOwner("Must hold the THREAD_MUTEX.");
        Thread thread = currentThread.get(vmThread);
        if (thread != null) {
            JavaThreads.toTarget((Thread)thread).threadData.detach();
            JavaThreads.toTarget((Thread)thread).isolateThread = (IsolateThread)WordFactory.nullPointer();
            if (!thread.isDaemon()) {
                nonDaemonThreads.decrementAndGet();
            }
        }
    }

    private static boolean tearDownPlatformThreads() {
        Log trace = Log.noopLog().string("[PlatformThreads.tearDownPlatformThreads:").newline().flush();
        VMThreads.setTearingDown();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        FetchApplicationThreadsOperation operation = new FetchApplicationThreadsOperation(threads);
        operation.enqueue();
        Set<ExecutorService> pools = Collections.newSetFromMap(new IdentityHashMap());
        Set poolsWithNonDaemons = Collections.newSetFromMap(new IdentityHashMap());
        for (Thread thread : threads) {
            ThreadPoolExecutor executor;
            Set<ExecutorService> set;
            if (thread == null || thread == Thread.currentThread()) continue;
            trace.string("  interrupting: ").string(thread.getName()).newline();
            try {
                thread.interrupt();
            }
            catch (Throwable t) {
                trace.string(" threw (ignored): ").exception(t);
            }
            trace.newline().flush();
            Set<ExecutorService> set2 = set = thread.isDaemon() ? pools : poolsWithNonDaemons;
            if (thread instanceof ForkJoinWorkerThread) {
                ForkJoinPool pool = SubstrateUtil.cast((Object)thread, Target_java_util_concurrent_ForkJoinWorkerThread.class).pool;
                if (pool == null || pool.getClass() != ForkJoinPool.class) continue;
                set.add(pool);
                continue;
            }
            Runnable target = JavaThreads.toTarget((Thread)thread).target;
            if (!Target_java_util_concurrent_ThreadPoolExecutor_Worker.class.isInstance(target) || (executor = SubstrateUtil.cast((Object)target, Target_java_util_concurrent_ThreadPoolExecutor_Worker.class).executor) == null || executor.getClass() != ThreadPoolExecutor.class && executor.getClass() != ScheduledThreadPoolExecutor.class) continue;
            set.add(executor);
        }
        pools.removeAll(poolsWithNonDaemons);
        for (ExecutorService pool : pools) {
            trace.string("  shutting down: ").object(pool);
            try {
                pool.shutdownNow();
            }
            catch (Throwable t) {
                trace.string(" threw (ignored): ").exception(t);
            }
            trace.newline().flush();
        }
        boolean result = PlatformThreads.waitForTearDown();
        trace.string("  returns: ").bool(result).string("]").newline().flush();
        return result;
    }

    private static boolean waitForTearDown() {
        long startNanos;
        assert (PlatformThreads.isApplicationThread(CurrentIsolate.getCurrentThread())) : "we count the application threads until only the current one remains";
        Log trace = Log.noopLog().string("[PlatformThreads.waitForTearDown:").newline();
        long warningNanos = SubstrateOptions.getTearDownWarningNanos();
        String warningMessage = "PlatformThreads.waitForTearDown is taking too long.";
        long failureNanos = SubstrateOptions.getTearDownFailureNanos();
        String failureMessage = "PlatformThreads.waitForTearDown took too long.";
        long loopNanos = startNanos = System.nanoTime();
        AtomicBoolean printLaggards = new AtomicBoolean(false);
        Log counterLog = warningNanos == 0L ? trace : Log.log();
        CheckReadyForTearDownOperation operation = new CheckReadyForTearDownOperation(counterLog, printLaggards);
        while (true) {
            long previousLoopNanos = loopNanos;
            operation.enqueue();
            if (operation.isReadyForTearDown()) {
                trace.string("  returns true]").newline();
                return true;
            }
            loopNanos = TimeUtils.doNotLoopTooLong(startNanos, loopNanos, warningNanos, "PlatformThreads.waitForTearDown is taking too long.");
            boolean fatallyTooLong = TimeUtils.maybeFatallyTooLong(startNanos, failureNanos, "PlatformThreads.waitForTearDown took too long.");
            if (fatallyTooLong) {
                trace.string("Took too long to tear down the VM.").newline();
                return false;
            }
            printLaggards.set(previousLoopNanos != loopNanos);
            Thread.yield();
        }
    }

    private static boolean isApplicationThread(IsolateThread isolateThread) {
        return !VMOperationControl.isDedicatedVMOperationThread(isolateThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN"}, justification="notifyAll is necessary for Java semantics, no shared state needs to be modified beforehand")
    public static void exit(Thread thread) {
        JavaThreads.toTarget(thread).exit();
        JavaThreads.setThreadStatus(thread, 2);
        Thread thread2 = thread;
        synchronized (thread2) {
            thread.notifyAll();
        }
    }

    protected <T extends ThreadStartData> T prepareStart(Thread thread, int startDataSize) {
        ThreadStartData startData = (ThreadStartData)UnmanagedMemory.malloc((int)startDataSize);
        startData.setIsolate(CurrentIsolate.getIsolate());
        startData.setThreadHandle(ObjectHandles.getGlobal().create((Object)thread));
        if (!thread.isDaemon()) {
            nonDaemonThreads.incrementAndGet();
        }
        return (T)startData;
    }

    protected void undoPrepareStartOnError(Thread thread, ThreadStartData startData) {
        if (!thread.isDaemon()) {
            PlatformThreads.undoPrepareNonDaemonStartOnError();
        }
        PlatformThreads.freeStartData(startData);
    }

    @Uninterruptible(reason="Holding threads lock.")
    private static void undoPrepareNonDaemonStartOnError() {
        VMThreads.lockThreadMutexInNativeCode();
        try {
            nonDaemonThreads.decrementAndGet();
            VMThreads.THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
        }
    }

    protected static void freeStartData(ThreadStartData startData) {
        UnmanagedMemory.free((PointerBase)startData);
    }

    void startThread(Thread thread, long stackSize) {
        this.unattachedStartedThreads.incrementAndGet();
        boolean started = this.doStartThread(thread, stackSize);
        if (!started) {
            this.unattachedStartedThreads.decrementAndGet();
            throw new OutOfMemoryError("unable to create native thread: possibly out of memory or process/resource limits reached");
        }
    }

    protected abstract boolean doStartThread(Thread var1, long var2);

    @SuppressFBWarnings(value={"Ru"}, justification="We really want to call Thread.run and not Thread.start because we are in the low-level thread start routine")
    protected static void threadStartRoutine(ObjectHandle threadHandle) {
        Thread thread = (Thread)ObjectHandles.getGlobal().get(threadHandle);
        PlatformThreads.assignCurrent(thread, false);
        ObjectHandles.getGlobal().destroy(threadHandle);
        PlatformThreads.singleton().unattachedStartedThreads.decrementAndGet();
        PlatformThreads.singleton().beforeThreadRun(thread);
        try {
            if (VMThreads.isTearingDown()) {
                Thread.currentThread().interrupt();
            }
            thread.run();
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(thread, ex);
        }
        finally {
            PlatformThreads.exit(thread);
        }
    }

    protected void beforeThreadRun(Thread thread) {
    }

    protected abstract void setNativeName(Thread var1, String var2);

    protected abstract void yieldCurrent();

    protected static void wakeUpVMConditionWaiters(Thread thread) {
        if (ReferenceHandler.useDedicatedThread() && ReferenceHandlerThread.isReferenceHandlerThread(thread)) {
            Heap.getHeap().wakeUpReferencePendingListWaiters();
        }
    }

    static StackTraceElement[] getStackTrace(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        GetStackTraceOperation vmOp = new GetStackTraceOperation(thread);
        vmOp.enqueue();
        return vmOp.result;
    }

    static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        GetAllStackTracesOperation vmOp = new GetAllStackTracesOperation();
        vmOp.enqueue();
        return vmOp.result;
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    private static StackTraceElement[] getStackTrace(IsolateThread thread) {
        if (thread == CurrentIsolate.getCurrentThread()) {
            return StackTraceUtils.getStackTrace(false, KnownIntrinsics.readCallerStackPointer());
        }
        return StackTraceUtils.getStackTrace(false, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parkCurrentPlatformOrCarrierThread() {
        VMOperationControl.guaranteeOkayToBlock("[PlatformThreads.parkCurrentPlatformOrCarrierThread(): Should not park when it is not okay to block.]");
        Thread thread = currentThread.get();
        if (JavaThreads.isInterrupted(thread)) {
            return;
        }
        ParkEvent parkEvent = PlatformThreads.getCurrentThreadData().ensureUnsafeParkEvent();
        int oldStatus = JavaThreads.getThreadStatus(thread);
        int newStatus = MonitorSupport.singleton().maybeAdjustNewParkStatus(657);
        JavaThreads.setThreadStatus(thread, newStatus);
        try {
            parkEvent.condWait();
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parkCurrentPlatformOrCarrierThread(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[PlatformThreads.parkCurrentPlatformOrCarrierThread(long): Should not park when it is not okay to block.]");
        Thread thread = currentThread.get();
        if (JavaThreads.isInterrupted(thread)) {
            return;
        }
        ParkEvent parkEvent = PlatformThreads.getCurrentThreadData().ensureUnsafeParkEvent();
        int oldStatus = JavaThreads.getThreadStatus(thread);
        int newStatus = MonitorSupport.singleton().maybeAdjustNewParkStatus(673);
        JavaThreads.setThreadStatus(thread, newStatus);
        try {
            parkEvent.condTimedWait(delayNanos);
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void unpark(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        ThreadData threadData = PlatformThreads.acquireThreadData(thread);
        if (threadData != null) {
            try {
                threadData.ensureUnsafeParkEvent().unpark();
            }
            finally {
                threadData.release();
            }
        }
    }

    static void sleep(long millis) throws InterruptedException {
        assert (!JavaThreads.isVirtual(Thread.currentThread()));
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        PlatformThreads.sleep0(TimeUtils.millisToNanos(millis));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep0(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[PlatformThreads.sleep(long): Should not sleep when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        ParkEvent sleepEvent = PlatformThreads.getCurrentThreadData().ensureSleepParkEvent();
        sleepEvent.reset();
        Unsafe.getUnsafe().fullFence();
        if (JavaThreads.isInterrupted(thread)) {
            return;
        }
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 225);
        try {
            sleepEvent.condTimedWait(delayNanos);
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void interrupt(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        ThreadData threadData = PlatformThreads.acquireThreadData(thread);
        if (threadData != null) {
            try {
                ParkEvent sleepEvent = threadData.getSleepParkEvent();
                if (sleepEvent != null) {
                    sleepEvent.unpark();
                }
            }
            finally {
                threadData.release();
            }
        }
    }

    static boolean isAlive(Thread thread) {
        assert (!JavaThreads.isVirtual(thread));
        int threadStatus = LoomSupport.CompatibilityUtil.getThreadStatus(JavaThreads.toTarget(thread));
        return threadStatus != 0 && threadStatus != 2;
    }

    private static ThreadData acquireThreadData(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).threadData.acquire();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static ThreadData getCurrentThreadData() {
        return (ThreadData)JavaThreads.toTarget((Thread)Thread.currentThread()).threadData;
    }

    private static class CheckReadyForTearDownOperation
    extends JavaVMOperation {
        private final Log trace;
        private final AtomicBoolean printLaggards;
        private boolean readyForTearDown;

        CheckReadyForTearDownOperation(Log trace, AtomicBoolean printLaggards) {
            super(VMOperationInfos.get(CheckReadyForTearDownOperation.class, "Check ready for teardown", VMOperation.SystemEffect.NONE));
            this.trace = trace;
            this.printLaggards = printLaggards;
        }

        boolean isReadyForTearDown() {
            return this.readyForTearDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            int unattachedStartedCount;
            int attachedCount = 0;
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    if (PlatformThreads.isApplicationThread(isolateThread)) {
                        ++attachedCount;
                        if (this.printLaggards.get() && this.trace.isEnabled() && isolateThread != this.queuingThread) {
                            this.trace.string("  laggard isolateThread: ").hex((WordBase)isolateThread);
                            Thread thread = PlatformThreads.fromVMThread(isolateThread);
                            if (thread != null) {
                                String name = thread.getName();
                                Thread.State status = thread.getState();
                                boolean interruptedStatus = JavaThreads.isInterrupted(thread);
                                this.trace.string("  thread.getName(): ").string(name).string("  interruptedStatus: ").bool(interruptedStatus).string("  getState(): ").string(status.name()).newline();
                                for (StackTraceElement e : thread.getStackTrace()) {
                                    this.trace.string(e.toString()).newline();
                                }
                            }
                            this.trace.newline().flush();
                        }
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
                unattachedStartedCount = PlatformThreads.singleton().unattachedStartedThreads.get();
            }
            finally {
                lock.unlock();
            }
            this.readyForTearDown = attachedCount == 1 && unattachedStartedCount == 0;
        }
    }

    private static class FetchApplicationThreadsOperation
    extends JavaVMOperation {
        private final List<Thread> list;

        FetchApplicationThreadsOperation(List<Thread> list) {
            super(VMOperationInfos.get(FetchApplicationThreadsOperation.class, "Fetch application threads", VMOperation.SystemEffect.NONE));
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operate() {
            this.list.clear();
            VMMutex lock = VMThreads.THREAD_MUTEX.lock();
            try {
                IsolateThread isolateThread = VMThreads.firstThread();
                while (isolateThread.isNonNull()) {
                    Thread thread;
                    if (PlatformThreads.isApplicationThread(isolateThread) && (thread = PlatformThreads.fromVMThread(isolateThread)) != null) {
                        this.list.add(thread);
                    }
                    isolateThread = VMThreads.nextThread(isolateThread);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class GetAllStackTracesOperation
    extends JavaVMOperation {
        private final Map<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>();

        GetAllStackTracesOperation() {
            super(VMOperationInfos.get(GetAllStackTracesOperation.class, "Get all stack traces", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                this.result.put(PlatformThreads.fromVMThread(cur), PlatformThreads.getStackTrace(cur));
                cur = VMThreads.nextThread(cur);
            }
        }
    }

    private static class GetStackTraceOperation
    extends JavaVMOperation {
        private final Thread thread;
        private StackTraceElement[] result;

        GetStackTraceOperation(Thread thread) {
            super(VMOperationInfos.get(GetStackTraceOperation.class, "Get stack trace", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        @Override
        protected void operate() {
            this.result = this.thread.isAlive() ? PlatformThreads.getStackTrace(PlatformThreads.getIsolateThread(this.thread)) : Target_java_lang_Thread.EMPTY_STACK_TRACE;
        }
    }

    @RawStructure
    protected static interface ThreadStartData
    extends PointerBase {
        @RawField
        public ObjectHandle getThreadHandle();

        @RawField
        public void setThreadHandle(ObjectHandle var1);

        @RawField
        public Isolate getIsolate();

        @RawField
        public void setIsolate(Isolate var1);
    }
}

