/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.management.ManagementFeature;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.sampler.SamplerIsolateLocal;
import com.oracle.svm.core.sampler.SamplerStackWalkVisitor;
import com.oracle.svm.core.sampler.SamplerThreadLocal;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.sampler.SubstrateSigprofHandlerStartupHook;
import com.oracle.svm.core.thread.ThreadListenerFeature;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class SubstrateSigprofHandlerFeature
implements Feature {
    SubstrateSigprofHandlerFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.AllowVMInspection.getValue() != false && SubstrateSigprofHandler.isProfilingSupported() && ImageInfo.isExecutable();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(ThreadListenerFeature.class, JfrFeature.class, ManagementFeature.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ImageSingletons.contains(SubstrateSigprofHandler.class)) {
            return;
        }
        VMError.guarantee(ImageSingletons.contains(RegisterDumper.class));
        ImageSingletons.add(SamplerStackWalkVisitor.class, (Object)new SamplerStackWalkVisitor());
        ThreadListenerSupport.get().register(new SamplerThreadLocal());
        IsolateListenerSupport.singleton().register(new SamplerIsolateLocal());
        RuntimeSupport.getRuntimeSupport().addStartupHook(new SubstrateSigprofHandlerStartupHook());
    }
}

