/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SecurityProvidersFilter;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import sun.security.jca.ProviderList;

@TargetClass(className="sun.security.jca.Providers")
final class Target_sun_security_jca_Providers {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ProviderListTransformer.class, disableCaching=true)
    private static ProviderList providerList;

    Target_sun_security_jca_Providers() {
    }

    private static class ProviderListTransformer
    implements RecomputeFieldValue.CustomFieldValueTransformer {
        private ProviderListTransformer() {
        }

        @Override
        public RecomputeFieldValue.ValueAvailability valueAvailability() {
            return RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
        }

        @Override
        public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
            ProviderList originalProviderList = (ProviderList)originalValue;
            return SecurityProvidersFilter.instance().cleanUnregisteredProviders(originalProviderList);
        }
    }
}

