/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.jdk.LoomJDK;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import com.oracle.svm.core.thread.Target_java_lang_ContinuationScope;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.VMError;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(value=StackWalker.class)
final class Target_java_lang_StackWalker {
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Target_java_lang_Continuation continuation;
    @Alias
    @TargetElement(onlyWith={LoomJDK.class})
    Target_java_lang_ContinuationScope contScope;
    @Alias
    Set<StackWalker.Option> options;
    @Alias
    boolean retainClassRef;

    Target_java_lang_StackWalker() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private void forEach(final Consumer<? super StackWalker.StackFrame> action) {
        final boolean showHiddenFrames = this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
        final boolean showReflectFrames = this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), new JavaStackFrameVisitor(){

            @Override
            public boolean visitFrame(FrameInfoQueryResult frameInfo) {
                if (StackTraceUtils.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) {
                    action.accept(new StackFrameImpl(frameInfo));
                }
                return true;
            }
        });
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private Class<?> getCallerClass() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }
        Class<?> result = StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), false);
        if (result == null) {
            throw new IllegalCallerException("No calling frame");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private <T> T walk(Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        if (LoomSupport.isEnabled() && this.continuation != null) {
            throw VMError.unimplemented();
        }
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        if (LoomSupport.isEnabled() && (this.contScope != null || VirtualThreads.singleton().isVirtual(Thread.currentThread()))) {
            Target_java_lang_ContinuationScope delimitationScope = this.contScope != null ? this.contScope : Target_java_lang_VirtualThread.continuationScope();
            Target_java_lang_Continuation topContinuation = Target_java_lang_Continuation.getCurrentContinuation(delimitationScope);
            if (topContinuation != null) {
                JavaStackWalker.initWalk(walk, sp, LoomSupport.getBaseSP(topContinuation));
            } else {
                JavaStackWalker.initWalk(walk, sp);
            }
        } else {
            JavaStackWalker.initWalk(walk, sp);
        }
        StackFrameSpliterator spliterator = new StackFrameSpliterator(walk, Thread.currentThread());
        try {
            T t = function.apply(StreamSupport.stream(spliterator, false));
            return t;
        }
        finally {
            ((AbstractStackFrameSpliterator)spliterator).invalidate();
        }
    }

    final class StackFrameImpl
    implements StackWalker.StackFrame {
        private final FrameInfoQueryResult frameInfo;
        private StackTraceElement ste;

        StackFrameImpl(FrameInfoQueryResult frameInfo) {
            this.frameInfo = frameInfo;
        }

        @Override
        public String getClassName() {
            return this.frameInfo.getSourceClassName();
        }

        @Override
        public String getMethodName() {
            return this.frameInfo.getSourceMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (!Target_java_lang_StackWalker.this.retainClassRef) {
                throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
            }
            return this.frameInfo.getSourceClass();
        }

        @Override
        public int getByteCodeIndex() {
            return this.frameInfo.getBci();
        }

        @Override
        public String getFileName() {
            return this.frameInfo.getSourceFileName();
        }

        @Override
        public int getLineNumber() {
            return this.frameInfo.getSourceLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.frameInfo.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            if (this.ste == null) {
                this.ste = this.frameInfo.getSourceReference();
            }
            return this.ste;
        }

        public String toString() {
            return this.toStackTraceElement().toString();
        }
    }

    final class StackFrameSpliterator
    extends AbstractStackFrameSpliterator {
        private final Thread thread;
        private JavaStackWalk walk;

        StackFrameSpliterator(JavaStackWalk walk, Thread curThread) {
            this.walk = walk;
            this.thread = curThread;
        }

        @Override
        protected void invalidate() {
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
        }

        @Override
        protected void checkState() {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Invalid thread");
            }
            if (this.walk.isNull()) {
                throw new IllegalStateException("Stack traversal no longer valid");
            }
        }

        @Override
        protected boolean haveMoreFrames() {
            Pointer endSP = this.walk.getEndSP();
            Pointer curSP = this.walk.getSP();
            return curSP.isNonNull() && (endSP.isNull() || curSP.belowThan((UnsignedWord)endSP));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
        protected void advancePhysically() {
            CodePointer ip = FrameAccess.singleton().readReturnAddress(this.walk.getSP());
            this.walk.setPossiblyStaleIP(ip);
            DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(this.walk.getSP());
            if (deoptimizedFrame != null) {
                this.curDeoptimizedFrame = deoptimizedFrame.getTopFrame();
                this.walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
                JavaStackWalker.continueWalk(this.walk, (CodeInfo)WordFactory.nullPointer());
            } else {
                UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
                this.walk.setIPCodeInfo(untetheredInfo);
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                    this.curRegularFrame = this.queryFrameInfo(info, ip);
                    JavaStackWalker.continueWalk(this.walk, info);
                }
                finally {
                    CodeInfoAccess.releaseTether(untetheredInfo, tether);
                }
            }
        }
    }

    private abstract class AbstractStackFrameSpliterator
    implements Spliterator<StackWalker.StackFrame> {
        protected DeoptimizedFrame.VirtualFrame curDeoptimizedFrame;
        protected FrameInfoQueryResult curRegularFrame;

        private AbstractStackFrameSpliterator() {
        }

        @Override
        public Spliterator<StackWalker.StackFrame> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        @Uninterruptible(reason="Wraps the now safe call to query frame information.", calleeMustBe=false)
        protected FrameInfoQueryResult queryFrameInfo(CodeInfo info, CodePointer ip) {
            return CodeInfoTable.lookupCodeInfoQueryResult(info, ip).getFrameInfo();
        }

        @Override
        public boolean tryAdvance(Consumer<? super StackWalker.StackFrame> action) {
            this.checkState();
            boolean showHiddenFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
            boolean showReflectFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
            while (true) {
                FrameInfoQueryResult frameInfo;
                if (this.curDeoptimizedFrame != null) {
                    frameInfo = this.curDeoptimizedFrame.getFrameInfo();
                    this.curDeoptimizedFrame = this.curDeoptimizedFrame.getCaller();
                    if (!this.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (this.curRegularFrame != null) {
                    frameInfo = this.curRegularFrame;
                    this.curRegularFrame = this.curRegularFrame.getCaller();
                    if (!this.shouldShowFrame(frameInfo, showHiddenFrames, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (!this.haveMoreFrames()) break;
                this.advancePhysically();
            }
            return false;
        }

        protected boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
            return StackTraceUtils.shouldShowFrame(frameInfo, showLambdaFrames, showReflectFrames, showHiddenFrames);
        }

        protected void invalidate() {
        }

        protected void checkState() {
        }

        protected abstract boolean haveMoreFrames();

        protected abstract void advancePhysically();
    }
}

