/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import sun.management.Util;

public abstract class AbstractMemoryMXBean
implements MemoryMXBean,
NotificationEmitter {
    protected static final long UNDEFINED_MEMORY_USAGE = -1L;
    private final MemoryMXBeanCodeInfoVisitor codeInfoVisitor = new MemoryMXBeanCodeInfoVisitor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AbstractMemoryMXBean() {
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Memory");
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        return 0;
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        this.codeInfoVisitor.reset();
        RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsUninterruptibly(this.codeInfoVisitor);
        long used = this.codeInfoVisitor.getRuntimeCodeInfoSize().rawValue();
        return new MemoryUsage(-1L, used, used, -1L);
    }

    @Override
    public boolean isVerbose() {
        return SubstrateGCOptions.PrintGC.getValue();
    }

    @Override
    public void setVerbose(boolean value) {
        SubstrateGCOptions.PrintGC.update(value);
    }

    @Override
    public void gc() {
        System.gc();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    private static final class MemoryMXBeanCodeInfoVisitor
    implements RuntimeCodeCache.CodeInfoVisitor {
        private UnsignedWord runtimeCodeInfoSize;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryMXBeanCodeInfoVisitor() {
            this.reset();
        }

        public UnsignedWord getRuntimeCodeInfoSize() {
            return this.runtimeCodeInfoSize;
        }

        public void reset() {
            this.runtimeCodeInfoSize = (UnsignedWord)WordFactory.zero();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public <T extends CodeInfo> boolean visitCode(T codeInfo) {
            this.runtimeCodeInfoSize = this.runtimeCodeInfoSize.add(CodeInfoAccess.getCodeAndDataMemorySize(codeInfo)).add(CodeInfoAccess.getNativeMetadataSize(codeInfo));
            return true;
        }
    }
}

