/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.meta.SharedMethod;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public class TestDeoptimizeNode
extends FixedWithNextNode
implements Canonicalizable {
    public static final NodeClass<TestDeoptimizeNode> TYPE = NodeClass.create(TestDeoptimizeNode.class);

    public TestDeoptimizeNode() {
        super(TYPE, StampFactory.forVoid());
    }

    public Node canonical(CanonicalizerTool tool) {
        if (this.graph().method() instanceof SharedMethod) {
            SharedMethod method = (SharedMethod)this.graph().method();
            if (method.isDeoptTarget()) {
                return null;
            }
            return new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter);
        }
        return this;
    }
}

