/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrGCName;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

class JfrGCEventSupport {
    private static final int MAX_PHASE_LEVEL = 4;
    private final JfrGCName gcName;
    private int currentPhase;

    JfrGCEventSupport(JfrGCName gcName) {
        this.gcName = gcName;
    }

    public long startGCPhasePause() {
        this.pushPhase();
        return JfrTicks.elapsedTicks();
    }

    public int stopGCPhasePause() {
        return this.popPhase();
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public void emitGarbageCollectionEvent(UnsignedWord gcEpoch, GCCause cause, long start) {
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(JfrEvent.GarbageCollection)) {
            long pauseTime = JfrTicks.elapsedTicks() - start;
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.GarbageCollection);
            JfrNativeEventWriter.putLong(data, start);
            JfrNativeEventWriter.putLong(data, pauseTime);
            JfrNativeEventWriter.putLong(data, gcEpoch.rawValue());
            JfrNativeEventWriter.putLong(data, this.gcName.getId());
            JfrNativeEventWriter.putLong(data, cause.getId());
            JfrNativeEventWriter.putLong(data, pauseTime);
            JfrNativeEventWriter.putLong(data, pauseTime);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public void emitGCPhasePauseEvent(UnsignedWord gcEpoch, int level, String name, long startTicks) {
        JfrEvent event = JfrGCEventSupport.getGCPhasePauseEvent(level);
        if (SubstrateJVM.isRecording() && SubstrateJVM.get().isEnabled(event)) {
            long end = JfrTicks.elapsedTicks();
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initializeThreadLocalNativeBuffer(data);
            JfrNativeEventWriter.beginSmallEvent(data, event);
            JfrNativeEventWriter.putLong(data, startTicks);
            JfrNativeEventWriter.putLong(data, end - startTicks);
            JfrNativeEventWriter.putEventThread(data);
            JfrNativeEventWriter.putLong(data, gcEpoch.rawValue());
            JfrNativeEventWriter.putString(data, name);
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static JfrEvent getGCPhasePauseEvent(int level) {
        switch (level) {
            case 0: {
                return JfrEvent.GCPhasePauseEvent;
            }
            case 1: {
                return JfrEvent.GCPhasePauseLevel1Event;
            }
            case 2: {
                return JfrEvent.GCPhasePauseLevel2Event;
            }
            case 3: {
                return JfrEvent.GCPhasePauseLevel3Event;
            }
            case 4: {
                return JfrEvent.GCPhasePauseLevel4Event;
            }
        }
        throw VMError.shouldNotReachHere("GC phase pause level must be between 0 and 4.");
    }

    private void pushPhase() {
        assert (this.currentPhase < 4);
        ++this.currentPhase;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int popPhase() {
        assert (this.currentPhase > 0);
        return --this.currentPhase;
    }
}

