/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JNIJavaCallTrampolines {
    private JNIJavaCallTrampolines() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String getTrampolineName(JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        StringBuilder name = new StringBuilder(48);
        if (variant == JNIJavaCallWrapperMethod.CallVariant.VARARGS) {
            name.append("varargs");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.ARRAY) {
            name.append("array");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.VA_LIST) {
            name.append("valist");
        } else {
            throw VMError.shouldNotReachHere();
        }
        if (nonVirtual) {
            name.append("Nonvirtual");
        }
        name.append("JavaCallTrampoline");
        return name.toString();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isNonVirtual(String trampolineName) {
        return trampolineName.endsWith("NonvirtualJavaCallTrampoline");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JNIJavaCallWrapperMethod.CallVariant getVariant(String trampolineName) {
        if (trampolineName.startsWith("varargs")) {
            return JNIJavaCallWrapperMethod.CallVariant.VARARGS;
        }
        if (trampolineName.startsWith("array")) {
            return JNIJavaCallWrapperMethod.CallVariant.ARRAY;
        }
        if (trampolineName.startsWith("valist")) {
            return JNIJavaCallWrapperMethod.CallVariant.VA_LIST;
        }
        throw VMError.shouldNotReachHere();
    }

    private static native void varargsJavaCallTrampoline();

    private static native void arrayJavaCallTrampoline();

    private static native void valistJavaCallTrampoline();

    private static native void varargsNonvirtualJavaCallTrampoline();

    private static native void arrayNonvirtualJavaCallTrampoline();

    private static native void valistNonvirtualJavaCallTrampoline();
}

