/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.AccessControllerUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.security.AccessControlContext;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class AccessControlContextReplacerFeature
implements Feature {
    static Map<String, AccessControlContext> allowedContexts = new HashMap<String, AccessControlContext>();

    AccessControlContextReplacerFeature() {
    }

    static void allowContextIfExists(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            String description = className + "." + fieldName;
            try {
                AccessControlContext acc = (AccessControlContext)ReflectionUtil.readStaticField(clazz, (String)fieldName);
                allowedContexts.put(description, acc);
            }
            catch (ReflectionUtil.ReflectionUtilError e) {
                throw VMError.shouldNotReachHere("Following field isn't present in JDK" + JavaVersionUtil.JAVA_SPEC + ": " + description);
            }
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Following class isn't present in JDK" + JavaVersionUtil.JAVA_SPEC + ": " + className);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        AccessControlContextReplacerFeature.allowContextIfExists("java.util.Calendar$CalendarAccessControlContext", "INSTANCE");
        AccessControlContextReplacerFeature.allowContextIfExists("javax.management.monitor.Monitor", "noPermissionsACC");
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            AccessControlContextReplacerFeature.allowContextIfExists("java.security.AccessController$AccHolder", "innocuousAcc");
            AccessControlContextReplacerFeature.allowContextIfExists("java.util.concurrent.ForkJoinPool$DefaultForkJoinWorkerThreadFactory", "ACC");
        }
        if (JavaVersionUtil.JAVA_SPEC < 17) {
            AccessControlContextReplacerFeature.allowContextIfExists("java.util.concurrent.ForkJoinWorkerThread", "INNOCUOUS_ACC");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 11 && JavaVersionUtil.JAVA_SPEC < 17) {
            AccessControlContextReplacerFeature.allowContextIfExists("java.util.concurrent.ForkJoinPool$InnocuousForkJoinWorkerThreadFactory", "ACC");
        }
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            AccessControlContextReplacerFeature.allowContextIfExists("java.util.concurrent.ForkJoinPool$WorkQueue", "INNOCUOUS_ACC");
            AccessControlContextReplacerFeature.allowContextIfExists("java.util.concurrent.ForkJoinPool$DefaultCommonPoolForkJoinWorkerThreadFactory", "ACC");
        }
        access.registerObjectReplacer(AccessControlContextReplacerFeature::replaceAccessControlContext);
    }

    private static boolean isSimpleContext(AccessControlContext ctx) {
        ProtectionDomain[] context = (ProtectionDomain[])ReflectionUtil.readField(AccessControlContext.class, (String)"context", (Object)ctx);
        AccessControlContext privilegedContext = (AccessControlContext)ReflectionUtil.readField(AccessControlContext.class, (String)"privilegedContext", (Object)ctx);
        DomainCombiner combiner = (DomainCombiner)ReflectionUtil.readField(AccessControlContext.class, (String)"combiner", (Object)ctx);
        Permission[] permissions = (Permission[])ReflectionUtil.readField(AccessControlContext.class, (String)"permissions", (Object)ctx);
        AccessControlContext parent = (AccessControlContext)ReflectionUtil.readField(AccessControlContext.class, (String)"parent", (Object)ctx);
        ProtectionDomain[] limitedContext = (ProtectionDomain[])ReflectionUtil.readField(AccessControlContext.class, (String)"limitedContext", (Object)ctx);
        if (context != null && context.length > 0) {
            return AccessControlContextReplacerFeature.checkPD(context);
        }
        if (combiner != null) {
            return false;
        }
        if (parent != null) {
            return AccessControlContextReplacerFeature.isSimpleContext(parent);
        }
        if (limitedContext != null && limitedContext.length > 0) {
            return AccessControlContextReplacerFeature.checkPD(limitedContext);
        }
        if (privilegedContext != null) {
            return AccessControlContextReplacerFeature.isSimpleContext(privilegedContext);
        }
        return true;
    }

    private static boolean checkPD(ProtectionDomain[] list) {
        for (ProtectionDomain pd : list) {
            if (pd.getCodeSource() != null) {
                return false;
            }
            if (pd.getPrincipals().length > 0) {
                return false;
            }
            if (pd.getPermissions() == null) continue;
            return false;
        }
        return true;
    }

    private static Object replaceAccessControlContext(Object obj) {
        if (obj instanceof AccessControlContext && obj != AccessControllerUtil.DISALLOWED_CONTEXT_MARKER) {
            if (allowedContexts.containsValue(obj)) {
                return obj;
            }
            if (AccessControlContextReplacerFeature.isSimpleContext((AccessControlContext)obj)) {
                return obj;
            }
            return AccessControllerUtil.DISALLOWED_CONTEXT_MARKER;
        }
        return obj;
    }
}

