/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.substitute.SubstitutionField;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.hosted.substitute.SubstitutionType;
import java.security.CodeSource;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class SubstitutionReportFeature
implements Feature {
    private final boolean enabled = Options.ReportPerformedSubstitutions.getValue();
    private final Map<String, Substitutions> substitutions = new TreeMap<String, Substitutions>();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return this.enabled;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
        this.findSubstitutedTypes(accessImpl);
        this.findSubstitutedMethods(accessImpl);
        this.findSubstitutedFields(accessImpl);
        this.reportSubstitutions();
    }

    private void findSubstitutedTypes(FeatureImpl.AfterAnalysisAccessImpl access) {
        for (AnalysisType type : access.getUniverse().getTypes()) {
            SubstitutionType subType;
            ResolvedJavaType t;
            if (!type.isReachable() || type.isArray() || !((t = type.getWrappedWithoutResolve()) instanceof SubstitutionType) || !(subType = (SubstitutionType)t).isUserSubstitution()) continue;
            String jarLocation = SubstitutionReportFeature.getTypeClassFileLocation(subType.getAnnotated());
            this.substitutions.putIfAbsent(jarLocation, new Substitutions());
            this.substitutions.get(jarLocation).addType(subType);
        }
    }

    private void findSubstitutedMethods(FeatureImpl.AfterAnalysisAccessImpl access) {
        for (AnalysisMethod method : access.getUniverse().getMethods()) {
            SubstitutionMethod subMethod;
            if (!(method.wrapped instanceof SubstitutionMethod) || !(subMethod = (SubstitutionMethod)method.wrapped).isUserSubstitution()) continue;
            String jarLocation = SubstitutionReportFeature.getTypeClassFileLocation(subMethod.getAnnotated().getDeclaringClass());
            this.substitutions.putIfAbsent(jarLocation, new Substitutions());
            this.substitutions.get(jarLocation).addMethod(subMethod);
        }
    }

    private void findSubstitutedFields(FeatureImpl.AfterAnalysisAccessImpl access) {
        for (AnalysisField field : access.getUniverse().getFields()) {
            SubstitutionField subField;
            if (!(field.wrapped instanceof SubstitutionField) || !(subField = (SubstitutionField)field.wrapped).isUserSubstitution()) continue;
            String jarLocation = SubstitutionReportFeature.getTypeClassFileLocation(subField.getAnnotated().getDeclaringClass());
            this.substitutions.putIfAbsent(jarLocation, new Substitutions());
            this.substitutions.get(jarLocation).addField(subField);
        }
    }

    private void reportSubstitutions() {
        ReportUtils.report((String)"substitutions performed by native-image", (String)SubstrateOptions.reportsPath(), (String)"substitutions", (String)"csv", pw -> {
            pw.println("location, category (type/method/field), original, annotated");
            for (Map.Entry<String, Substitutions> g : this.substitutions.entrySet()) {
                for (Map.Entry<ResolvedJavaType, ResolvedJavaType> entry : g.getValue().getSubstitutedTypes().entrySet()) {
                    pw.println(SubstitutionReportFeature.formatSubstitution(g.getKey(), "type", entry.getKey(), entry.getValue(), SubstitutionReportFeature::formatType));
                }
                for (Map.Entry<ResolvedJavaType, ResolvedJavaType> entry : g.getValue().getSubstitutedMethods().entrySet()) {
                    pw.println(SubstitutionReportFeature.formatSubstitution(g.getKey(), "method", (ResolvedJavaMethod)entry.getKey(), (ResolvedJavaMethod)entry.getValue(), SubstitutionReportFeature::formatMethod));
                }
                for (Map.Entry<ResolvedJavaType, ResolvedJavaType> entry : g.getValue().getSubstitutedFields().entrySet()) {
                    pw.println(SubstitutionReportFeature.formatSubstitution(g.getKey(), "field", (ResolvedJavaField)entry.getKey(), (ResolvedJavaField)entry.getValue(), SubstitutionReportFeature::formatField));
                }
            }
        });
    }

    private static String formatType(ResolvedJavaType t) {
        return t.toJavaName(true);
    }

    private static String formatMethod(ResolvedJavaMethod method) {
        return method.format("%H#%n");
    }

    private static String formatField(ResolvedJavaField field) {
        return field.format("%H.%n");
    }

    private static String getTypeClassFileLocation(ResolvedJavaType type) {
        Class annotatedClass = OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)type);
        CodeSource source = annotatedClass.getProtectionDomain().getCodeSource();
        return source == null ? "unknown" : source.getLocation().toString();
    }

    private static <T> String formatSubstitution(String jar, String type, T original, T annotated, Function<T, String> formatter) {
        return "'" + jar + "'," + type + "," + formatter.apply(original) + "," + formatter.apply(annotated);
    }

    private static class Substitutions {
        private final Map<ResolvedJavaType, ResolvedJavaType> substitutedTypes = new TreeMap<ResolvedJavaType, ResolvedJavaType>(Comparator.comparing(x$0 -> SubstitutionReportFeature.formatType(x$0)));
        private final Map<ResolvedJavaMethod, ResolvedJavaMethod> substitutedMethods = new TreeMap<ResolvedJavaMethod, ResolvedJavaMethod>(Comparator.comparing(x$0 -> SubstitutionReportFeature.formatMethod(x$0)));
        private final Map<ResolvedJavaField, ResolvedJavaField> substitutedFields = new TreeMap<ResolvedJavaField, ResolvedJavaField>(Comparator.comparing(x$0 -> SubstitutionReportFeature.formatField(x$0)));

        private Substitutions() {
        }

        public void addType(SubstitutionType type) {
            this.substitutedTypes.put(type.getOriginal(), type.getAnnotated());
        }

        public void addMethod(SubstitutionMethod method) {
            this.substitutedMethods.put(method.getOriginal(), method.getAnnotated());
        }

        public void addField(SubstitutionField field) {
            this.substitutedFields.put(field.getOriginal(), field.getAnnotated());
        }

        public Map<ResolvedJavaType, ResolvedJavaType> getSubstitutedTypes() {
            return this.substitutedTypes;
        }

        public Map<ResolvedJavaMethod, ResolvedJavaMethod> getSubstitutedMethods() {
            return this.substitutedMethods;
        }

        public Map<ResolvedJavaField, ResolvedJavaField> getSubstitutedFields() {
            return this.substitutedFields;
        }
    }

    static class Options {
        public static final HostedOptionKey<Boolean> ReportPerformedSubstitutions = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }
}

