/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.management.SubstrateThreadMXBean;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerBufferStack;
import com.oracle.svm.core.sampler.SamplerIsolateLocal;
import com.oracle.svm.core.sampler.SamplerSampleWriter;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerStackWalkVisitor;
import com.oracle.svm.core.sampler.SamplerThreadLocal;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import java.lang.management.ManagementFactory;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public abstract class SubstrateSigprofHandler {
    private boolean enabled;
    private final SamplerBufferStack availableBuffers = new SamplerBufferStack();
    private final SamplerBufferStack fullBuffers = new SamplerBufferStack();
    private SubstrateThreadMXBean threadMXBean;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SubstrateSigprofHandler() {
    }

    @Fold
    static SubstrateSigprofHandler singleton() {
        return (SubstrateSigprofHandler)ImageSingletons.lookup(SubstrateSigprofHandler.class);
    }

    @Fold
    static SamplerStackWalkVisitor visitor() {
        return (SamplerStackWalkVisitor)ImageSingletons.lookup(SamplerStackWalkVisitor.class);
    }

    @Fold
    static boolean isProfilingSupported() {
        return Platform.includedIn(Platform.LINUX.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isProfilingEnabled() {
        return this.enabled;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    SamplerBufferStack availableBuffers() {
        return this.availableBuffers;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    SamplerBufferStack fullBuffers() {
        return this.fullBuffers;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    SubstrateThreadMXBean substrateThreadMXBean() {
        return this.threadMXBean;
    }

    void install() {
        if (Options.SamplingBasedProfiling.getValue().booleanValue()) {
            this.threadMXBean = (SubstrateThreadMXBean)ManagementFactory.getThreadMXBean();
            InitializeSamplerOperation initializeSamplerOperation = new InitializeSamplerOperation();
            initializeSamplerOperation.enqueue();
            this.install0();
        }
    }

    protected abstract void install0();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract UnsignedWord createThreadLocalKey();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void deleteThreadLocalKey(UnsignedWord var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void setThreadLocalKeyValue(UnsignedWord var1, IsolateThread var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract IsolateThread getThreadLocalKeyValue(UnsignedWord var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isIPInJavaCode(RegisterDumper.Context uContext) {
        Pointer ip = (Pointer)RegisterDumper.singleton().getIP(uContext);
        CodeInfo codeInfo = CodeInfoTable.getImageCodeInfo();
        Pointer codeStart = (Pointer)CodeInfoAccess.getCodeStart(codeInfo);
        UnsignedWord codeSize = CodeInfoAccess.getCodeSize(codeInfo);
        return ip.aboveOrEqual((UnsignedWord)codeStart) && ip.belowOrEqual((UnsignedWord)codeStart.add(codeSize));
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected static void doUninterruptibleStackWalk(RegisterDumper.Context uContext) {
        Pointer sp;
        CodePointer ip;
        if (SubstrateSigprofHandler.isIPInJavaCode(uContext)) {
            ip = (CodePointer)RegisterDumper.singleton().getIP(uContext);
            sp = (Pointer)RegisterDumper.singleton().getSP(uContext);
        } else {
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
            if (anchor.isNull()) {
                return;
            }
            ip = anchor.getLastJavaIP();
            sp = anchor.getLastJavaSP();
            if (ip.isNull() || sp.isNull()) {
                return;
            }
        }
        SamplerSampleWriterData data = (SamplerSampleWriterData)StackValue.get(SamplerSampleWriterData.class);
        if (SubstrateSigprofHandler.prepareStackWalk(data) && JavaStackWalker.walkCurrentThread(sp, ip, SubstrateSigprofHandler.visitor())) {
            SamplerSampleWriter.commit(data);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean prepareStackWalk(SamplerSampleWriterData data) {
        if (SubstrateSigprofHandler.singleton().availableBuffers().isLockedByCurrentThread() || SubstrateSigprofHandler.singleton().fullBuffers().isLockedByCurrentThread()) {
            SamplerThreadLocal.increaseMissedSamples();
            return false;
        }
        SamplerBuffer buffer = SamplerThreadLocal.getThreadLocalBuffer();
        if (buffer.isNull()) {
            buffer = SubstrateSigprofHandler.singleton().availableBuffers().popBuffer();
            if (buffer.isNull()) {
                SamplerThreadLocal.increaseMissedSamples();
                return false;
            }
            SamplerThreadLocal.setThreadLocalBuffer(buffer);
        }
        data.setSamplerBuffer(buffer);
        data.setStartPos(buffer.getPos());
        data.setCurrentPos(buffer.getPos());
        data.setEndPos(SamplerBufferAccess.getDataEnd(buffer));
        SamplerThreadLocal.setWriterData(data);
        return true;
    }

    @Uninterruptible(reason="The method executes during signal handling.", callerMustBe=true)
    protected static boolean tryEnterIsolate() {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            Isolate isolate = SamplerIsolateLocal.getIsolate();
            if (isolate.isNull()) {
                return false;
            }
            WriteHeapBaseNode.writeCurrentVMHeapBase((PointerBase)isolate);
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (!SamplerIsolateLocal.isKeySet()) {
                return false;
            }
            UnsignedWord key = SamplerIsolateLocal.getKey();
            IsolateThread thread = SubstrateSigprofHandler.singleton().getThreadLocalKeyValue(key);
            if (thread.isNull()) {
                return false;
            }
            WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        }
        return true;
    }

    private class InitializeSamplerOperation
    extends JavaVMOperation {
        protected InitializeSamplerOperation() {
            super(VMOperationInfos.get(InitializeSamplerOperation.class, "Initialize Sampler", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            this.initialize();
        }

        @Uninterruptible(reason="Prevent pollution of the current thread's thread local JFR buffer.")
        private void initialize() {
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                SamplerThreadLocal.initialize(thread);
                thread = VMThreads.nextThread(thread);
            }
            SubstrateSigprofHandler.this.enabled = true;
        }
    }

    public static class Options {
        static final RuntimeOptionKey<Boolean> SamplingBasedProfiling = new RuntimeOptionKey<Boolean>(Boolean.FALSE, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

