/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrConstantPool;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrEventWriterAccess;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.core.jfr.JfrMethodRepository;
import com.oracle.svm.core.jfr.JfrNativeEventSetting;
import com.oracle.svm.core.jfr.JfrOptionSet;
import com.oracle.svm.core.jfr.JfrRecorderThread;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrSymbolRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrThreadRepository;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.JfrTypeRepository;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.core.jfr.events.ExecutionSampleEvent;
import com.oracle.svm.core.jfr.logging.JfrLogging;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.Configuration;
import jdk.jfr.internal.EventWriter;
import jdk.jfr.internal.LogTag;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class SubstrateJVM {
    private final List<Configuration> knownConfigurations;
    private final JfrOptionSet options;
    private final JfrNativeEventSetting[] eventSettings;
    private final JfrSymbolRepository symbolRepo;
    private final JfrTypeRepository typeRepo;
    private final JfrThreadRepository threadRepo;
    private final JfrStackTraceRepository stackTraceRepo;
    private final JfrMethodRepository methodRepo;
    private final JfrConstantPool[] repositories;
    private final JfrThreadLocal threadLocal;
    private final JfrGlobalMemory globalMemory;
    private final JfrUnlockedChunkWriter unlockedChunkWriter;
    private final JfrRecorderThread recorderThread;
    private final JfrLogging jfrLogging;
    private boolean initialized;
    private volatile boolean recording;
    private byte[] metadataDescriptor;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateJVM(List<Configuration> configurations) {
        this.knownConfigurations = configurations;
        this.options = new JfrOptionSet();
        int eventCount = JfrMetadataTypeLibrary.getPlatformEventCount();
        this.eventSettings = new JfrNativeEventSetting[eventCount];
        for (int i = 0; i < this.eventSettings.length; ++i) {
            this.eventSettings[i] = new JfrNativeEventSetting();
        }
        this.symbolRepo = new JfrSymbolRepository();
        this.typeRepo = new JfrTypeRepository();
        this.threadRepo = new JfrThreadRepository();
        this.stackTraceRepo = new JfrStackTraceRepository();
        this.methodRepo = new JfrMethodRepository();
        this.repositories = new JfrConstantPool[]{this.stackTraceRepo, this.methodRepo, this.typeRepo, this.threadRepo, this.symbolRepo};
        this.threadLocal = new JfrThreadLocal();
        this.globalMemory = new JfrGlobalMemory();
        this.unlockedChunkWriter = new JfrChunkWriter(this.globalMemory);
        this.recorderThread = new JfrRecorderThread(this.globalMemory, this.unlockedChunkWriter);
        this.jfrLogging = new JfrLogging();
        this.initialized = false;
        this.recording = false;
        this.metadataDescriptor = null;
    }

    @Fold
    public static SubstrateJVM get() {
        return (SubstrateJVM)ImageSingletons.lookup(SubstrateJVM.class);
    }

    @Fold
    public static List<Configuration> getKnownConfigurations() {
        return SubstrateJVM.get().knownConfigurations;
    }

    @Fold
    public static JfrGlobalMemory getGlobalMemory() {
        return SubstrateJVM.get().globalMemory;
    }

    @Fold
    public static JfrRecorderThread getRecorderThread() {
        return SubstrateJVM.get().recorderThread;
    }

    @Fold
    public static ThreadListener getThreadLocal() {
        return SubstrateJVM.get().threadLocal;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getParentThreadId(IsolateThread isolateThread) {
        return SubstrateJVM.get().threadLocal.getParentThreadId(isolateThread);
    }

    @Fold
    public static JfrTypeRepository getTypeRepository() {
        return SubstrateJVM.get().typeRepo;
    }

    @Fold
    public static JfrSymbolRepository getSymbolRepository() {
        return SubstrateJVM.get().symbolRepo;
    }

    @Fold
    public static JfrThreadRepository getThreadRepo() {
        return SubstrateJVM.get().threadRepo;
    }

    @Fold
    public static JfrMethodRepository getMethodRepo() {
        return SubstrateJVM.get().methodRepo;
    }

    @Fold
    public static JfrLogging getJfrLogging() {
        return SubstrateJVM.get().jfrLogging;
    }

    public static Object getHandler(Class<? extends Event> eventClass) {
        try {
            Field f = eventClass.getDeclaredField("eventHandler");
            f.setAccessible(true);
            return f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new InternalError("Could not access event handler");
        }
    }

    public static boolean isInitialized() {
        return SubstrateJVM.get().initialized;
    }

    @Uninterruptible(reason="Prevent races with threads that start/stop recording.", callerMustBe=true)
    public static boolean isRecording() {
        return SubstrateJVM.get().recording;
    }

    public boolean createJFR(boolean simulateFailure) {
        if (simulateFailure) {
            throw new IllegalStateException("Unable to start JFR");
        }
        if (this.initialized) {
            throw new IllegalStateException("JFR was already started before");
        }
        this.options.validateAndAdjustMemoryOptions();
        JfrTicks.initialize();
        this.threadLocal.initialize(this.options.threadBufferSize.getValue());
        this.globalMemory.initialize(this.options.globalBufferSize.getValue(), this.options.globalBufferCount.getValue());
        this.unlockedChunkWriter.initialize(this.options.maxChunkSize.getValue());
        this.recorderThread.start();
        this.initialized = true;
        return true;
    }

    public boolean destroyJFR() {
        assert (!this.recording) : "must already have been stopped";
        if (!this.initialized) {
            return false;
        }
        this.recorderThread.setStopped(true);
        this.recorderThread.signal();
        try {
            this.recorderThread.join();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere(e);
        }
        this.globalMemory.teardown();
        this.symbolRepo.teardown();
        this.threadRepo.teardown();
        this.stackTraceRepo.teardown();
        this.methodRepo.teardown();
        this.initialized = false;
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getStackTraceId(long eventTypeId, int skipCount) {
        if (this.isStackTraceEnabled(eventTypeId)) {
            return this.getStackTraceId(skipCount);
        }
        return 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getStackTraceId(int skipCount) {
        return this.stackTraceRepo.getStackTraceId(skipCount, false);
    }

    public long getThreadId(Thread thread) {
        return thread.getId();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadId(IsolateThread isolateThread) {
        long threadId = this.threadLocal.getTraceId(isolateThread);
        VMError.guarantee(threadId > 0L);
        return threadId;
    }

    public void storeMetadataDescriptor(byte[] bytes) {
        this.metadataDescriptor = bytes;
    }

    public void beginRecording() {
        assert (!this.recording);
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            chunkWriter.maybeOpenFile();
        }
        finally {
            chunkWriter.unlock();
        }
        JfrBeginRecordingOperation vmOp = new JfrBeginRecordingOperation();
        vmOp.enqueue();
    }

    public void endRecording() {
        assert (this.recording);
        JfrEndRecordingOperation vmOp = new JfrEndRecordingOperation();
        vmOp.enqueue();
    }

    public boolean unsafeIsRecording() {
        return this.recording;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getClassId(Class<?> clazz) {
        return this.typeRepo.getClassId(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(String file) {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            if (this.recording) {
                boolean existingFile = chunkWriter.hasOpenFile();
                if (existingFile) {
                    chunkWriter.closeFile(this.metadataDescriptor, this.repositories);
                }
                if (file != null) {
                    chunkWriter.openFile(file);
                    if (!existingFile) {
                        this.recorderThread.signal();
                    }
                }
            } else {
                chunkWriter.setFilename(file);
            }
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void setFileNotification(long delta) {
        this.options.maxChunkSize.setUserValue(delta);
    }

    public void setGlobalBufferCount(long count) {
        this.options.globalBufferCount.setUserValue(count);
    }

    public void setGlobalBufferSize(long size) {
        this.options.globalBufferSize.setUserValue(size);
    }

    public void setMemorySize(long size) {
        this.options.memorySize.setUserValue(size);
    }

    public void setMethodSamplingInterval(long type, long intervalMillis) {
        long millis = intervalMillis;
        if (type != JfrEvent.ExecutionSample.getId()) {
            return;
        }
        if (millis > 0L) {
            SubstrateJVM.get().setEnabled(type, true);
        } else {
            millis = 0L;
        }
        ExecutionSampleEvent.setSamplingInterval(millis);
    }

    public void setSampleThreads(boolean sampleThreads) {
        this.setEnabled(JfrEvent.ExecutionSample.getId(), sampleThreads);
        this.setEnabled(JfrEvent.NativeMethodSample.getId(), sampleThreads);
    }

    public void setCompressedIntegers(boolean compressed) {
        if (!compressed) {
            throw new IllegalStateException("JFR currently only supports compressed integers.");
        }
    }

    public void setStackDepth(int depth) {
        this.stackTraceRepo.setStackTraceDepth(depth);
    }

    public void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setStackTrace(enabled);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isStackTraceEnabled(long eventTypeId) {
        assert ((long)((int)eventTypeId) == eventTypeId);
        return this.eventSettings[(int)eventTypeId].hasStackTrace();
    }

    public void setThreadBufferSize(long size) {
        this.options.threadBufferSize.setUserValue(size);
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public boolean flush(EventWriter writer, int uncommittedSize, int requestedSize) {
        assert (writer != null);
        assert (uncommittedSize >= 0);
        JfrBuffer oldBuffer = this.threadLocal.getJavaBuffer();
        assert (oldBuffer.isNonNull());
        JfrBuffer newBuffer = JfrThreadLocal.flush(oldBuffer, WordFactory.unsigned((int)uncommittedSize), requestedSize);
        if (newBuffer.isNull()) {
            JfrEventWriterAccess.setStartPosition(writer, oldBuffer.getPos().rawValue());
            JfrEventWriterAccess.setCurrentPosition(writer, oldBuffer.getPos().rawValue());
            JfrEventWriterAccess.setValid(writer, false);
        } else {
            Pointer newCurrentPos = newBuffer.getPos().add(uncommittedSize);
            JfrEventWriterAccess.setStartPosition(writer, newBuffer.getPos().rawValue());
            JfrEventWriterAccess.setCurrentPosition(writer, newCurrentPos.rawValue());
            if (newBuffer.notEqual((ComparableWord)oldBuffer)) {
                JfrEventWriterAccess.setStartPositionAddress(writer, JfrBufferAccess.getAddressOfPos(newBuffer).rawValue());
                JfrEventWriterAccess.setMaxPosition(writer, JfrBufferAccess.getDataEnd(newBuffer).rawValue());
            }
        }
        return false;
    }

    public void setRepositoryLocation(String dirText) {
    }

    public void abort(String errorMsg) {
        throw VMError.shouldNotReachHere(errorMsg);
    }

    public boolean shouldRotateDisk() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            boolean bl = chunkWriter.shouldRotateDisk();
            return bl;
        }
        finally {
            chunkWriter.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChunkStartNanos() {
        JfrChunkWriter chunkWriter = this.unlockedChunkWriter.lock();
        try {
            long l = chunkWriter.getChunkStartNanos();
            return l;
        }
        finally {
            chunkWriter.unlock();
        }
    }

    public void log(int tagSetId, int level, String message) {
        this.jfrLogging.log(tagSetId, level, message);
    }

    public void subscribeLogLevel(LogTag lt, int tagSetId) {
    }

    public Target_jdk_jfr_internal_EventWriter getEventWriter() {
        return this.threadLocal.getEventWriter();
    }

    public Target_jdk_jfr_internal_EventWriter newEventWriter() {
        return this.threadLocal.newEventWriter();
    }

    public void setEnabled(long eventTypeId, boolean enabled) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setEnabled(enabled);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEnabled(JfrEvent event) {
        return this.eventSettings[(int)event.getId()].isEnabled();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setLarge(JfrEvent event, boolean large) {
        this.eventSettings[(int)event.getId()].setLarge(large);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isLarge(JfrEvent event) {
        return this.eventSettings[(int)event.getId()].isLarge();
    }

    public boolean setThreshold(long eventTypeId, long ticks) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setThresholdTicks(ticks);
        return true;
    }

    public boolean setCutoff(long eventTypeId, long cutoffTicks) {
        this.eventSettings[NumUtil.safeToInt((long)eventTypeId)].setCutoffTicks(cutoffTicks);
        return true;
    }

    private static class JfrEndRecordingOperation
    extends JavaVMOperation {
        JfrEndRecordingOperation() {
            super(VMOperationInfos.get(JfrEndRecordingOperation.class, "JFR end recording", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            SubstrateJVM.get().recording = false;
        }
    }

    private static class JfrBeginRecordingOperation
    extends JavaVMOperation {
        JfrBeginRecordingOperation() {
            super(VMOperationInfos.get(JfrBeginRecordingOperation.class, "JFR begin recording", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            SubstrateJVM.get().recording = true;
            SubstrateJVM.getThreadRepo().registerRunningThreads();
        }
    }
}

