/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.JavaOrderedReadNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.memory.FloatableThreadLocalAccess;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class LoadVMThreadLocalNode
extends FixedWithNextNode
implements VMThreadLocalAccess,
Lowerable,
SingleMemoryKill,
MemoryAccess,
FloatableThreadLocalAccess {
    public static final NodeClass<LoadVMThreadLocalNode> TYPE = NodeClass.create(LoadVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    protected final OnHeapMemoryAccess.BarrierType barrierType;
    @Node.Input
    protected ValueNode holder;
    private final MemoryOrderMode memoryOrder;

    public LoadVMThreadLocalNode(MetaAccessProvider metaAccess, VMThreadLocalInfo threadLocalInfo, ValueNode holder, OnHeapMemoryAccess.BarrierType barrierType) {
        this(TYPE, metaAccess, threadLocalInfo, holder, barrierType, MemoryOrderMode.PLAIN);
    }

    protected LoadVMThreadLocalNode(NodeClass<? extends LoadVMThreadLocalNode> c, MetaAccessProvider metaAccess, VMThreadLocalInfo threadLocalInfo, ValueNode holder, OnHeapMemoryAccess.BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(c, (Stamp)(threadLocalInfo.isObject ? StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)metaAccess.lookupJavaType(threadLocalInfo.valueClass))) : StampFactory.forKind((JavaKind)threadLocalInfo.storageKind)));
        this.threadLocalInfo = threadLocalInfo;
        this.barrierType = barrierType;
        this.holder = holder;
        this.memoryOrder = memoryOrder;
    }

    public LocationIdentity getKilledLocationIdentity() {
        if (MemoryOrderMode.ordersMemoryAccesses((MemoryOrderMode)this.memoryOrder)) {
            return LocationIdentity.any();
        }
        return MemoryKill.NO_LOCATION;
    }

    public LocationIdentity getLocationIdentity() {
        return this.threadLocalInfo.locationIdentity;
    }

    public void lower(LoweringTool tool) {
        JavaReadNode read;
        assert (this.threadLocalInfo.offset >= 0);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.holder.graph());
        AddressNode address = (AddressNode)this.graph().unique((Node)new OffsetAddressNode(this.holder, (ValueNode)offset));
        if (MemoryOrderMode.ordersMemoryAccesses((MemoryOrderMode)this.memoryOrder)) {
            read = (JavaReadNode)this.graph().add((Node)new JavaOrderedReadNode(this.stamp, this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.barrierType, this.memoryOrder, true));
        } else {
            read = (JavaReadNode)this.graph().add((Node)new JavaReadNode(this.stamp, this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.barrierType, true));
            if (this.threadLocalInfo.allowFloatingReads) {
                read.setGuard((GuardingNode)read.graph().start());
            }
        }
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)read);
        tool.getLowerer().lower((Node)read, tool);
    }

    public boolean canFloat() {
        return !MemoryOrderMode.ordersMemoryAccesses((MemoryOrderMode)this.memoryOrder) && this.threadLocalInfo.allowFloatingReads;
    }
}

