/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;

public class SubstrateMetaAccessExtensionProvider
implements MetaAccessExtensionProvider {
    public JavaKind getStorageKind(JavaType type) {
        return ((SharedType)type).getStorageKind();
    }

    public boolean canConstantFoldDynamicAllocation(ResolvedJavaType type) {
        return type != null && ((SharedType)type).getHub().isInstantiated();
    }

    public boolean isGuaranteedSafepoint(ResolvedJavaMethod method, boolean isDirect) {
        if (method == null) {
            return false;
        }
        SharedMethod sharedMethod = (SharedMethod)method;
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)((Object)sharedMethod))) {
            return false;
        }
        if (!isDirect) {
            for (SharedMethod implementation : sharedMethod.getImplementations()) {
                if (!Uninterruptible.Utils.isUninterruptible((AnnotatedElement)((Object)implementation))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canVirtualize(ResolvedJavaType instanceType) {
        return true;
    }
}

