/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.BasicCollectionPolicies;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GenScavengeGCCause;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.JfrGCEvents;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheWalker;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.ThreadLocalMTWalker;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GCImpl
implements GC {
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor = new GreyToBlackObjRefVisitor();
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor = new GreyToBlackObjectVisitor(this.greyToBlackObjRefVisitor);
    private final BlackenImageHeapRootsVisitor blackenImageHeapRootsVisitor = new BlackenImageHeapRootsVisitor();
    private final RuntimeCodeCacheWalker runtimeCodeCacheWalker = new RuntimeCodeCacheWalker(this.greyToBlackObjRefVisitor);
    private final RuntimeCodeCacheCleaner runtimeCodeCacheCleaner = new RuntimeCodeCacheCleaner();
    private final GCAccounting accounting = new GCAccounting();
    private final Timers timers = new Timers();
    private final CollectionVMOperation collectOperation = new CollectionVMOperation();
    private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory("GCImpl.GCImpl()", false);
    private final ChunkReleaser chunkReleaser = new ChunkReleaser();
    private final CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord sizeBefore = (UnsignedWord)WordFactory.zero();
    private boolean collectionInProgress = false;
    private UnsignedWord collectionEpoch = (UnsignedWord)WordFactory.zero();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCImpl() {
        this.policy = CollectionPolicy.getInitialPolicy();
        RuntimeSupport.getRuntimeSupport().addShutdownHook(isFirstIsolate -> this.printGCSummary());
    }

    @Override
    public String getName() {
        if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
            return "Epsilon GC";
        }
        return "Serial GC";
    }

    @Override
    public void collect(GCCause cause) {
        this.collect(cause, false);
    }

    public void maybeCollectOnAllocation() {
        boolean outOfMemory = false;
        if (GCImpl.hasNeverCollectPolicy()) {
            UnsignedWord edenUsed = HeapImpl.getHeapImpl().getAccounting().getEdenUsedBytes();
            outOfMemory = edenUsed.aboveThan(GCImpl.getPolicy().getMaximumHeapSize());
        } else if (GCImpl.getPolicy().shouldCollectOnAllocation()) {
            outOfMemory = this.collectWithoutAllocating(GenScavengeGCCause.OnAllocation, false);
        }
        if (outOfMemory) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
    }

    public void maybeCauseUserRequestedCollection() {
        if (!SubstrateGCOptions.DisableExplicitGC.getValue().booleanValue()) {
            HeapImpl.getHeapImpl().getGC().collectCompletely(GCCause.JavaLangSystemGC);
        }
    }

    private void collect(GCCause cause, boolean forceFullGC) {
        boolean outOfMemory;
        if (!GCImpl.hasNeverCollectPolicy() && (outOfMemory = this.collectWithoutAllocating(cause, forceFullGC))) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
    }

    @Uninterruptible(reason="Avoid races with other threads that also try to trigger a GC")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    boolean collectWithoutAllocating(GCCause cause, boolean forceFullGC) {
        VMError.guarantee(!GCImpl.hasNeverCollectPolicy());
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setNativeVMOperation(this.collectOperation);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch(this.getCollectionEpoch());
        data.setRequestingNanoTime(System.nanoTime());
        data.setForceFullGC(forceFullGC);
        this.enqueueCollectOperation(data);
        return data.getOutOfMemory();
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private void enqueueCollectOperation(CollectionVMOperationData data) {
        this.collectOperation.enqueue(data);
    }

    private void collectOperation(CollectionVMOperationData data) {
        assert (VMOperation.isGCInProgress()) : "Collection should be a VMOperation.";
        assert (this.getCollectionEpoch().equal(data.getRequestingEpoch()));
        this.timers.mutator.closeAt(data.getRequestingNanoTime());
        this.startCollectionOrExit();
        this.timers.resetAllExceptMutator();
        this.collectionEpoch = this.collectionEpoch.add(1);
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        GCCause cause = GCCause.fromId(data.getCauseId());
        this.printGCBefore(cause.getName());
        boolean outOfMemory = this.collectImpl(cause, data.getRequestingNanoTime(), data.getForceFullGC());
        this.printGCAfter(cause.getName());
        this.finishCollection();
        this.timers.mutator.open();
        data.setOutOfMemory(outOfMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectImpl(GCCause cause, long requestingNanoTime, boolean forceFullGC) {
        boolean outOfMemory;
        block9: {
            GCImpl.precondition();
            try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
                long startTicks = JfrTicks.elapsedTicks();
                try {
                    outOfMemory = this.doCollectImpl(cause, requestingNanoTime, forceFullGC, false);
                    if (!outOfMemory) break block9;
                    ReferenceObjectProcessing.setSoftReferencesAreWeak(true);
                    try {
                        outOfMemory = this.doCollectImpl(cause, requestingNanoTime, true, true);
                    }
                    finally {
                        ReferenceObjectProcessing.setSoftReferencesAreWeak(false);
                    }
                }
                finally {
                    JfrGCEvents.emitGarbageCollectionEvent(this.getCollectionEpoch(), cause, startTicks);
                }
            }
        }
        GCImpl.postcondition();
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCollectImpl(GCCause cause, long requestingNanoTime, boolean forceFullGC, boolean forceNoIncremental) {
        long startTicks;
        CommittedMemoryProvider.get().beforeGarbageCollection();
        boolean incremental = !forceNoIncremental && !this.policy.shouldCollectCompletely(false);
        boolean outOfMemory = false;
        if (incremental) {
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                outOfMemory = this.doCollectOnce(cause, requestingNanoTime, false, false);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Incremental GC", startTicks);
            }
        }
        if (!incremental || outOfMemory || forceFullGC || this.policy.shouldCollectCompletely(incremental)) {
            if (incremental) {
                CommittedMemoryProvider.get().afterGarbageCollection();
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                outOfMemory = this.doCollectOnce(cause, requestingNanoTime, true, incremental);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Full GC", startTicks);
            }
        }
        HeapImpl.getChunkProvider().freeExcessAlignedChunks();
        CommittedMemoryProvider.get().afterGarbageCollection();
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCollectOnce(GCCause cause, long requestingNanoTime, boolean complete, boolean followsIncremental) {
        assert (!followsIncremental || complete) : "An incremental collection cannot be followed by another incremental collection";
        this.completeCollection = complete;
        this.accounting.beforeCollection(this.completeCollection);
        this.policy.onCollectionBegin(this.completeCollection, requestingNanoTime);
        try (Timer collectionTimer = this.timers.collection.open();){
            if (!followsIncremental) {
                this.verifyBeforeGC();
            }
            this.scavenge(!complete);
            this.verifyAfterGC();
        }
        HeapImpl.getHeapImpl().getAccounting().setEdenAndYoungGenBytes((UnsignedWord)WordFactory.zero(), this.accounting.getYoungChunkBytesAfter());
        this.accounting.afterCollection(this.completeCollection, collectionTimer);
        this.policy.onCollectionEnd(this.completeCollection, cause);
        UnsignedWord usedBytes = GCImpl.getChunkBytes();
        UnsignedWord freeBytes = this.policy.getCurrentHeapCapacity().subtract(usedBytes);
        ReferenceObjectProcessing.afterCollection(freeBytes);
        return usedBytes.aboveThan(this.policy.getMaximumHeapSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyBeforeGC() {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            try (Timer verifyBeforeTimer = this.timers.verifyBefore.open();){
                boolean success = true;
                success &= HeapVerifier.verify(HeapVerifier.Occasion.BEFORE_COLLECTION);
                if (!(success &= StackVerifier.verifyAllThreads())) {
                    String kind = this.getGCKind();
                    Log.log().string("Heap verification failed before ").string(kind).string(" garbage collection.").newline();
                    VMError.shouldNotReachHere();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAfterGC() {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            try (Timer verifyAfterTime = this.timers.verifyAfter.open();){
                boolean success = true;
                success &= HeapVerifier.verify(HeapVerifier.Occasion.AFTER_COLLECTION);
                if (!(success &= StackVerifier.verifyAllThreads())) {
                    String kind = this.getGCKind();
                    Log.log().string("Heap verification failed after ").string(kind).string(" garbage collection.").newline();
                    VMError.shouldNotReachHere();
                }
            }
        }
    }

    private String getGCKind() {
        return this.isCompleteCollection() ? "complete" : "incremental";
    }

    public static UnsignedWord getChunkBytes() {
        UnsignedWord youngBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
        UnsignedWord oldBytes = HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
        return youngBytes.add(oldBytes);
    }

    private void printGCBefore(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UnsignedWord unsignedWord = this.sizeBefore = SubstrateGCOptions.PrintGC.getValue() != false || HeapOptions.PrintHeapShape.getValue() != false ? GCImpl.getChunkBytes() : (UnsignedWord)WordFactory.zero();
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && this.getCollectionEpoch().equal(1)) {
            verboseGCLog.string("[Heap policy parameters: ").newline();
            verboseGCLog.string("  YoungGenerationSize: ").unsigned((WordBase)GCImpl.getPolicy().getMaximumYoungGenerationSize()).newline();
            verboseGCLog.string("      MaximumHeapSize: ").unsigned((WordBase)GCImpl.getPolicy().getMaximumHeapSize()).newline();
            verboseGCLog.string("      MinimumHeapSize: ").unsigned((WordBase)GCImpl.getPolicy().getMinimumHeapSize()).newline();
            verboseGCLog.string("     AlignedChunkSize: ").unsigned((WordBase)HeapParameters.getAlignedHeapChunkSize()).newline();
            verboseGCLog.string("  LargeArrayThreshold: ").unsigned((WordBase)HeapParameters.getLargeArrayThreshold()).string("]").newline();
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().logImageHeapPartitionBoundaries(verboseGCLog);
            }
        }
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            verboseGCLog.string("[");
            verboseGCLog.string("[");
            long startTime = System.nanoTime();
            if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(startTime))).string(" msec: ");
            } else {
                verboseGCLog.unsigned(startTime);
            }
            verboseGCLog.string(" GC:").string(" before").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                heap.report(verboseGCLog);
            }
            verboseGCLog.string("]").newline();
        }
    }

    private void printGCAfter(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (SubstrateGCOptions.PrintGC.getValue().booleanValue() || SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            if (SubstrateGCOptions.PrintGC.getValue().booleanValue()) {
                Log printGCLog = Log.log();
                UnsignedWord sizeAfter = GCImpl.getChunkBytes();
                printGCLog.string("[");
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    long finishNanos = this.timers.collection.getClosedTime();
                    printGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                }
                printGCLog.string(this.completeCollection ? "Full GC" : "Incremental GC");
                printGCLog.string(" (").string(cause).string(") ");
                printGCLog.unsigned((WordBase)this.sizeBefore.unsignedDivide(1024));
                printGCLog.string("K->");
                printGCLog.unsigned((WordBase)sizeAfter.unsignedDivide(1024)).string("K, ");
                printGCLog.rational(this.timers.collection.getMeasuredNanos(), 1000000000L, 7L).string(" secs");
                printGCLog.string("]").newline();
            }
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
                verboseGCLog.string(" [");
                long finishNanos = this.timers.collection.getClosedTime();
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                } else {
                    verboseGCLog.unsigned(finishNanos);
                }
                verboseGCLog.string(" GC:").string(" after ").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
                verboseGCLog.string("  policy: ");
                verboseGCLog.string(GCImpl.getPolicy().getName());
                verboseGCLog.string("  type: ").string(this.completeCollection ? "complete" : "incremental");
                if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                    heap.report(verboseGCLog);
                }
                if (!HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                    verboseGCLog.newline();
                    verboseGCLog.string("  collection time: ").unsigned(this.timers.collection.getMeasuredNanos()).string(" nanoSeconds");
                } else {
                    this.timers.logAfterCollection(verboseGCLog);
                }
                verboseGCLog.string("]");
                verboseGCLog.string("]").newline();
            }
        }
    }

    private static void precondition() {
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
    }

    private static void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        GCImpl.verbosePostCondition();
        assert (youngGen.getEden().isEmpty()) : "youngGen.getEden() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
    }

    private static void verbosePostCondition() {
        boolean forceForTesting = false;
        if (GCImpl.runtimeAssertions()) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            YoungGeneration youngGen = heap.getYoungGeneration();
            OldGeneration oldGen = heap.getOldGeneration();
            Log log = Log.log();
            if (!youngGen.getEden().isEmpty()) {
                log.string("[GCImpl.postcondition: Eden space should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    Eden space first AlignedChunk:   ").zhex((WordBase)youngGen.getEden().getFirstAlignedHeapChunk()).newline();
                log.string("    Eden space last  AlignedChunk:   ").zhex((WordBase)youngGen.getEden().getLastAlignedHeapChunk()).newline();
                log.string("    Eden space first UnalignedChunk: ").zhex((WordBase)youngGen.getEden().getFirstUnalignedHeapChunk()).newline();
                log.string("    Eden space last  UnalignedChunk: ").zhex((WordBase)youngGen.getEden().getLastUnalignedHeapChunk()).newline();
                youngGen.getEden().report(log, true).newline();
                log.string("]").newline();
            }
            for (int i = 0; i < HeapParameters.getMaxSurvivorSpaces(); ++i) {
                if (youngGen.getSurvivorToSpaceAt(i).isEmpty()) continue;
                log.string("[GCImpl.postcondition: Survivor toSpace should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    Survivor space ").signed(i).string(" first AlignedChunk:   ").zhex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstAlignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" last  AlignedChunk:   ").zhex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastAlignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" first UnalignedChunk: ").zhex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstUnalignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" last  UnalignedChunk: ").zhex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastUnalignedHeapChunk()).newline();
                youngGen.getSurvivorToSpaceAt(i).report(log, true).newline();
                log.string("]").newline();
            }
            if (!oldGen.getToSpace().isEmpty()) {
                log.string("[GCImpl.postcondition: oldGen toSpace should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    oldGen toSpace first AlignedChunk:   ").zhex((WordBase)oldGen.getToSpace().getFirstAlignedHeapChunk()).newline();
                log.string("    oldGen toSpace last  AlignedChunk:   ").zhex((WordBase)oldGen.getToSpace().getLastAlignedHeapChunk()).newline();
                log.string("    oldGen.toSpace first UnalignedChunk: ").zhex((WordBase)oldGen.getToSpace().getFirstUnalignedHeapChunk()).newline();
                log.string("    oldGen.toSpace last  UnalignedChunk: ").zhex((WordBase)oldGen.getToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getToSpace().report(log, true).newline();
                oldGen.getFromSpace().report(log, true).newline();
                log.string("]").newline();
            }
        }
    }

    @Fold
    static boolean runtimeAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(GCImpl.class);
    }

    @Fold
    public static GCImpl getGCImpl() {
        GCImpl gcImpl = HeapImpl.getHeapImpl().getGCImpl();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Override
    public void collectCompletely(GCCause cause) {
        this.collect(cause, true);
    }

    public boolean isCompleteCollection() {
        return this.completeCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge(boolean incremental) {
        try (GreyToBlackObjRefVisitor.Counters counters = this.greyToBlackObjRefVisitor.openCounters();){
            long startTicks;
            try (Timer rootScanTimer = this.timers.rootScan.open();){
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    if (incremental) {
                        this.cheneyScanFromDirtyRoots();
                    } else {
                        this.cheneyScanFromRoots();
                    }
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), incremental ? "Incremental Scan" : "Scan", startTicks);
                }
                catch (Throwable throwable) {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), incremental ? "Incremental Scan" : "Scan", startTicks);
                    throw throwable;
                }
            }
            if (DeoptimizationSupport.enabled()) {
                try (Timer cleanCodeCacheTimer = this.timers.cleanCodeCache.open();){
                    startTicks = JfrGCEvents.startGCPhasePause();
                    try {
                        this.cleanRuntimeCodeCache();
                    }
                    finally {
                        JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Clean Runtime CodeCache", startTicks);
                    }
                }
            }
            try (Timer referenceObjectsTimer = this.timers.referenceObjects.open();){
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    Reference<?> newlyPendingList = ReferenceObjectProcessing.processRememberedReferences();
                    HeapImpl.getHeapImpl().addToReferencePendingList(newlyPendingList);
                }
                finally {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Process Remembered References", startTicks);
                }
            }
            try (Timer releaseSpacesTimer = this.timers.releaseSpaces.open();){
                assert (this.chunkReleaser.isEmpty());
                startTicks = JfrGCEvents.startGCPhasePause();
                try {
                    this.releaseSpaces();
                    boolean keepAllAlignedChunks = incremental;
                    this.chunkReleaser.release(keepAllAlignedChunks);
                }
                finally {
                    JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Release Spaces", startTicks);
                }
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.swapSpaces();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Swap Spaces", startTicks);
            }
        }
    }

    private void walkRuntimeCodeCache() {
        try (Timer walkRuntimeCodeCacheTimer = this.timers.walkRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheWalker);
        }
    }

    private void cleanRuntimeCodeCache() {
        try (Timer cleanRuntimeCodeCacheTimer = this.timers.cleanRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheCleaner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cheneyScanFromRoots() {
        try (Timer cheneyScanFromRootsTimer = this.timers.cheneyScanFromRoots.open();){
            long startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.prepareForPromotion(false);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Snapshot Heap", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.promoteChunksWithPinnedObjects();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Pinned Objects", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.blackenStackRoots();
                this.walkThreadLocals();
                this.blackenImageHeapRoots();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan Roots", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.scanGreyObjects(false);
                if (DeoptimizationSupport.enabled()) {
                    this.walkRuntimeCodeCache();
                    this.scanGreyObjects(false);
                }
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan From Roots", startTicks);
            }
            this.greyToBlackObjectVisitor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cheneyScanFromDirtyRoots() {
        try (Timer cheneyScanFromDirtyRootsTimer = this.timers.cheneyScanFromDirtyRoots.open();){
            long startTicks = JfrGCEvents.startGCPhasePause();
            try {
                OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
                oldGen.emptyFromSpaceIntoToSpace();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Old Generation", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                GCImpl.prepareForPromotion(true);
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Snapshot Heap", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.promoteChunksWithPinnedObjects();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Promote Pinned Objects", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.blackenDirtyCardRoots();
                this.blackenStackRoots();
                this.walkThreadLocals();
                this.blackenDirtyImageHeapRoots();
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan Roots", startTicks);
            }
            startTicks = JfrGCEvents.startGCPhasePause();
            try {
                this.scanGreyObjects(true);
                if (DeoptimizationSupport.enabled()) {
                    this.walkRuntimeCodeCache();
                    this.scanGreyObjects(true);
                }
            }
            finally {
                JfrGCEvents.emitGCPhasePauseEvent(this.getCollectionEpoch(), "Scan From Roots", startTicks);
            }
            this.greyToBlackObjectVisitor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteChunksWithPinnedObjects() {
        try (Timer promotePinnedObjectsTimer = this.timers.promotePinnedObjects.open();){
            PinnedObjectImpl pinnedObjects = GCImpl.removeClosedPinnedObjects(PinnedObjectImpl.getPinnedObjects());
            PinnedObjectImpl.setPinnedObjects(pinnedObjects);
            for (PinnedObjectImpl cur = pinnedObjects; cur != null; cur = cur.getNext()) {
                assert (cur.isOpen());
                this.promotePinnedObject(cur);
            }
        }
    }

    private static PinnedObjectImpl removeClosedPinnedObjects(PinnedObjectImpl list) {
        PinnedObjectImpl firstOpen = null;
        PinnedObjectImpl lastOpen = null;
        for (PinnedObjectImpl cur = list; cur != null; cur = cur.getNext()) {
            if (!cur.isOpen()) continue;
            if (firstOpen == null) {
                assert (lastOpen == null);
                firstOpen = cur;
                lastOpen = cur;
                continue;
            }
            lastOpen.setNext(cur);
            lastOpen = cur;
        }
        if (lastOpen != null) {
            lastOpen.setNext(null);
        }
        return firstOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void blackenStackRoots() {
        try (Timer blackenStackRootsTimer = this.timers.blackenStackRoots.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
            JavaStackWalker.initWalk(walk, sp, ip);
            this.walkStack(walk);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread() && JavaStackWalker.initWalk(walk, vmThread)) {
                        this.walkStack(walk);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void walkStack(JavaStackWalk walk) {
        DeoptimizedFrame deoptFrame;
        SimpleCodeInfoQueryResult queryResult;
        assert (VMOperation.isGCInProgress()) : "This methods accesses a CodeInfo without a tether";
        do {
            queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
            Pointer sp = walk.getSP();
            CodePointer ip = walk.getPossiblyStaleIP();
            CodeInfo codeInfo = CodeInfoAccess.convert(walk.getIPCodeInfo());
            deoptFrame = Deoptimizer.checkDeoptimized(sp);
            if (deoptFrame == null) {
                if (codeInfo.isNull()) {
                    throw JavaStackWalker.reportUnknownFrameEncountered(sp, ip, deoptFrame);
                }
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                assert (Deoptimizer.checkDeoptimized(sp) == null) : "We are at a safepoint, so no deoptimization can have happened";
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) {
                    throw CodeInfoTable.reportNoReferenceMap(sp, ip, codeInfo);
                }
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, this.greyToBlackObjRefVisitor, null);
            }
            if (!DeoptimizationSupport.enabled() || codeInfo == CodeInfoTable.getImageCodeInfo()) continue;
            RuntimeCodeInfoAccess.acquireThreadWriteAccess();
            try {
                RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.greyToBlackObjRefVisitor);
                RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.greyToBlackObjRefVisitor);
            }
            finally {
                RuntimeCodeInfoAccess.releaseThreadWriteAccess();
            }
        } while (JavaStackWalker.continueWalk(walk, queryResult, deoptFrame));
    }

    private void walkThreadLocals() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            try (Timer walkThreadLocalsTimer = this.timers.walkThreadLocals.open();){
                ThreadLocalMTWalker.walk(this.greyToBlackObjRefVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blackenDirtyImageHeapRoots() {
        if (!HeapImpl.usesImageHeapCardMarking()) {
            this.blackenImageHeapRoots();
            return;
        }
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            ImageHeapInfo auxInfo;
            ImageHeapInfo info = HeapImpl.getImageHeapInfo();
            this.blackenDirtyImageHeapChunkRoots(info.getFirstWritableAlignedChunk(), info.getFirstWritableUnalignedChunk());
            if (AuxiliaryImageHeap.isPresent() && (auxInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                this.blackenDirtyImageHeapChunkRoots(auxInfo.getFirstWritableAlignedChunk(), auxInfo.getFirstWritableUnalignedChunk());
            }
        }
    }

    private void blackenDirtyImageHeapChunkRoots(AlignedHeapChunk.AlignedHeader firstAligned, UnalignedHeapChunk.UnalignedHeader firstUnaligned) {
        boolean clean = this.completeCollection;
        AlignedHeapChunk.AlignedHeader aligned = firstAligned;
        while (aligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(aligned, this.greyToBlackObjectVisitor, clean);
            aligned = HeapChunk.getNext(aligned);
        }
        UnalignedHeapChunk.UnalignedHeader unaligned = firstUnaligned;
        while (unaligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(unaligned, this.greyToBlackObjectVisitor, clean);
            unaligned = HeapChunk.getNext(unaligned);
        }
    }

    private void blackenImageHeapRoots() {
        if (HeapImpl.usesImageHeapCardMarking()) {
            this.blackenDirtyImageHeapRoots();
            return;
        }
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            HeapImpl.getHeapImpl().walkNativeImageHeapRegions(this.blackenImageHeapRootsVisitor);
        }
    }

    private void blackenDirtyCardRoots() {
        try (Timer blackenDirtyCardRootsTimer = this.timers.blackenDirtyCardRoots.open();){
            Space oldGenToSpace = HeapImpl.getHeapImpl().getOldGeneration().getToSpace();
            RememberedSet.get().walkDirtyObjects(oldGenToSpace, this.greyToBlackObjectVisitor, true);
        }
    }

    private static void prepareForPromotion(boolean isIncremental) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getOldGeneration().prepareForPromotion();
        if (isIncremental) {
            heap.getYoungGeneration().prepareForPromotion();
        }
    }

    private void scanGreyObjects(boolean isIncremental) {
        try (Timer scanGreyObjectsTimer = this.timers.scanGreyObjects.open();){
            if (isIncremental) {
                GCImpl.scanGreyObjectsLoop();
            } else {
                HeapImpl.getHeapImpl().getOldGeneration().scanGreyObjects();
            }
        }
    }

    private static void scanGreyObjectsLoop() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        do {
            boolean hasGrey = youngGen.scanGreyObjects();
        } while (hasGrey |= oldGen.scanGreyObjects());
    }

    @AlwaysInline(value="GC performance")
    Object promoteObject(Object original, UnsignedWord header) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        boolean isAligned = ObjectHeaderImpl.isAlignedHeader(header);
        HeapChunk.Header<?> originalChunk = GCImpl.getChunk(original, isAligned);
        Space originalSpace = HeapChunk.getSpace(originalChunk);
        if (!originalSpace.isFromSpace()) {
            return original;
        }
        Object result = null;
        if (!this.completeCollection && originalSpace.getNextAgeForPromotion() < this.policy.getTenuringAge() && (result = isAligned ? heap.getYoungGeneration().promoteAlignedObject(original, (AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace) : heap.getYoungGeneration().promoteUnalignedObject(original, (UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace)) == null) {
            this.accounting.onSurvivorOverflowed();
        }
        if (result == null) {
            result = isAligned ? heap.getOldGeneration().promoteAlignedObject(original, (AlignedHeapChunk.AlignedHeader)originalChunk, originalSpace) : heap.getOldGeneration().promoteUnalignedObject(original, (UnalignedHeapChunk.UnalignedHeader)originalChunk, originalSpace);
            assert (result != null) : "promotion failure in old generation must have been handled";
        }
        return result;
    }

    private static HeapChunk.Header<?> getChunk(Object obj, boolean isAligned) {
        if (isAligned) {
            return AlignedHeapChunk.getEnclosingChunk(obj);
        }
        assert (ObjectHeaderImpl.isUnalignedObject(obj));
        return UnalignedHeapChunk.getEnclosingChunk(obj);
    }

    private void promotePinnedObject(PinnedObjectImpl pinned) {
        boolean isAligned;
        HeapChunk.Header<?> originalChunk;
        Space originalSpace;
        HeapImpl heap = HeapImpl.getHeapImpl();
        Object referent = pinned.getObject();
        if (referent != null && !heap.isInImageHeap(referent) && (originalSpace = HeapChunk.getSpace(originalChunk = GCImpl.getChunk(referent, isAligned = ObjectHeaderImpl.isAlignedObject(referent)))).isFromSpace()) {
            boolean promoted = false;
            if (!this.completeCollection && originalSpace.getNextAgeForPromotion() < this.policy.getTenuringAge() && !(promoted = heap.getYoungGeneration().promoteChunk(originalChunk, isAligned, originalSpace))) {
                this.accounting.onSurvivorOverflowed();
            }
            if (!promoted) {
                heap.getOldGeneration().promoteChunk(originalChunk, isAligned, originalSpace);
            }
        }
    }

    private static void swapSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        heap.getYoungGeneration().swapSpaces();
        oldGen.swapSpaces();
    }

    private void releaseSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces(this.chunkReleaser);
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces(this.chunkReleaser);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isCollectionInProgress() {
        return this.collectionInProgress;
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress);
        this.collectionInProgress = true;
    }

    private void finishCollection() {
        assert (this.collectionInProgress);
        this.collectionInProgress = false;
    }

    static void doReferenceHandling() {
        assert (!VMOperation.isInProgress()) : "could result in deadlocks";
        assert (PlatformThreads.isCurrentAssigned()) : "thread is not fully initialized yet";
        if (HeapImpl.getHeapImpl().hasReferencePendingListUnsafe()) {
            long startTime = System.nanoTime();
            ReferenceHandler.processPendingReferencesInRegularThread();
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                long executionTime = System.nanoTime() - startTime;
                Log.log().string("[GC epilogue reference processing and cleaners: ").signed(executionTime).string("]").newline();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    public GCAccounting getAccounting() {
        return this.accounting;
    }

    @Fold
    public static CollectionPolicy getPolicy() {
        return GCImpl.getGCImpl().policy;
    }

    @Fold
    public static boolean hasNeverCollectPolicy() {
        return GCImpl.getPolicy() instanceof BasicCollectionPolicies.NeverCollect;
    }

    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    private void printGCSummary() {
        if (!HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        Log log = Log.log();
        String prefix = "PrintGCSummary: ";
        log.string("PrintGCSummary: ").string("MaximumYoungGenerationSize: ").unsigned((WordBase)GCImpl.getPolicy().getMaximumYoungGenerationSize()).newline();
        log.string("PrintGCSummary: ").string("MinimumHeapSize: ").unsigned((WordBase)GCImpl.getPolicy().getMinimumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("MaximumHeapSize: ").unsigned((WordBase)GCImpl.getPolicy().getMaximumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("AlignedChunkSize: ").unsigned((WordBase)HeapParameters.getAlignedHeapChunkSize()).newline();
        FlushTLABsOperation vmOp = new FlushTLABsOperation();
        vmOp.enqueue();
        HeapImpl heap = HeapImpl.getHeapImpl();
        Space edenSpace = heap.getYoungGeneration().getEden();
        UnsignedWord youngChunkBytes = edenSpace.getChunkBytes();
        UnsignedWord youngObjectBytes = edenSpace.computeObjectBytes();
        UnsignedWord allocatedChunkBytes = this.accounting.getAllocatedChunkBytes().add(youngChunkBytes);
        UnsignedWord allocatedObjectBytes = this.accounting.getAllocatedObjectBytes().add(youngObjectBytes);
        log.string("PrintGCSummary: ").string("CollectedTotalChunkBytes: ").signed((WordBase)this.accounting.getCollectedTotalChunkBytes()).newline();
        log.string("PrintGCSummary: ").string("CollectedTotalObjectBytes: ").signed((WordBase)this.accounting.getCollectedTotalObjectBytes()).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalChunkBytes: ").signed((WordBase)allocatedChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalObjectBytes: ").signed((WordBase)allocatedObjectBytes).newline();
        long incrementalNanos = this.accounting.getIncrementalCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("IncrementalGCCount: ").signed(this.accounting.getIncrementalCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("IncrementalGCNanos: ").signed(incrementalNanos).newline();
        long completeNanos = this.accounting.getCompleteCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("CompleteGCCount: ").signed(this.accounting.getCompleteCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("CompleteGCNanos: ").signed(completeNanos).newline();
        long gcNanos = incrementalNanos + completeNanos;
        long mutatorNanos = this.timers.mutator.getMeasuredNanos();
        long totalNanos = gcNanos + mutatorNanos;
        long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
        log.string("PrintGCSummary: ").string("GCNanos: ").signed(gcNanos).newline();
        log.string("PrintGCSummary: ").string("TotalNanos: ").signed(totalNanos).newline();
        log.string("PrintGCSummary: ").string("GCLoadPercent: ").signed(roundedGCLoad).newline();
    }

    private static class FlushTLABsOperation
    extends JavaVMOperation {
        protected FlushTLABsOperation() {
            super(VMOperationInfos.get(FlushTLABsOperation.class, "Flush TLABs", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            ThreadLocalAllocation.disableAndFlushForAllThreads();
        }
    }

    public static class ChunkReleaser {
        private AlignedHeapChunk.AlignedHeader firstAligned;
        private UnalignedHeapChunk.UnalignedHeader firstUnaligned;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ChunkReleaser() {
        }

        public boolean isEmpty() {
            return this.firstAligned.isNull() && this.firstUnaligned.isNull();
        }

        public void add(AlignedHeapChunk.AlignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstAligned.isNonNull()) {
                    AlignedHeapChunk.AlignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstAligned);
                    HeapChunk.setPrevious(this.firstAligned, lastNewChunk);
                }
                this.firstAligned = chunks;
            }
        }

        public void add(UnalignedHeapChunk.UnalignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstUnaligned.isNonNull()) {
                    UnalignedHeapChunk.UnalignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstUnaligned);
                    HeapChunk.setPrevious(this.firstUnaligned, lastNewChunk);
                }
                this.firstUnaligned = chunks;
            }
        }

        void release(boolean keepAllAlignedChunks) {
            if (this.firstAligned.isNonNull()) {
                HeapImpl.getChunkProvider().consumeAlignedChunks(this.firstAligned, keepAllAlignedChunks);
                this.firstAligned = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
            }
            if (this.firstUnaligned.isNonNull()) {
                HeapChunkProvider.consumeUnalignedChunks(this.firstUnaligned);
                this.firstUnaligned = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
            }
        }

        private static <T extends HeapChunk.Header<T>> T getLast(T chunks) {
            T prev = chunks;
            Object next = HeapChunk.getNext(prev);
            while (next.isNonNull()) {
                prev = next;
                next = HeapChunk.getNext(prev);
            }
            return prev;
        }
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public long getRequestingNanoTime();

        @RawField
        public void setRequestingNanoTime(long var1);

        @RawField
        public boolean getForceFullGC();

        @RawField
        public void setForceFullGC(boolean var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        CollectionVMOperation() {
            super(VMOperationInfos.get(CollectionVMOperation.class, "Garbage collection", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isGC() {
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                HeapImpl.getHeapImpl().getGCImpl().collectOperation((CollectionVMOperationData)data);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere(t);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        @Override
        protected boolean hasWork(NativeVMOperationData data) {
            CollectionVMOperationData d = (CollectionVMOperationData)data;
            return HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal(d.getRequestingEpoch());
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();

        static void exitIf(boolean state) {
            if (state) {
                Log failure = Log.log();
                failure.string("[CollectionInProgressError:");
                failure.newline();
                ThreadStackPrinter.printBacktrace();
                failure.string("]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    private class BlackenImageHeapRootsVisitor
    implements MemoryWalker.ImageHeapRegionVisitor {
        private BlackenImageHeapRootsVisitor() {
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (access.containsReferences(region) && access.isWritable(region)) {
                access.visitObjects(region, GCImpl.this.greyToBlackObjectVisitor);
            }
            return true;
        }
    }
}

