/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class NativeImageHeaderPreamble {
    public static List<String> read(ClassLoader imageClassloader, String preambleResource) {
        return NativeImageHeaderPreamble.getResource(imageClassloader, preambleResource);
    }

    private static List<String> getResource(ClassLoader imageClassloader, String resourceName) {
        List<String> list;
        block8: {
            InputStream input = imageClassloader.getResourceAsStream(resourceName);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                list = reader.lines().collect(Collectors.toList());
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            input.close();
        }
        return list;
    }
}

