/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.hub.AnnotationsEncoding;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCloneable;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateField
implements SharedField {
    protected static final SubstrateField[] EMPTY_ARRAY = new SubstrateField[0];
    SubstrateType type;
    SubstrateType declaringClass;
    private final String name;
    private final int modifiers;
    private int hashCode;
    private Object annotationsEncoding;
    @UnknownPrimitiveField
    int location;
    @UnknownPrimitiveField
    private boolean isAccessed;
    @UnknownPrimitiveField
    private boolean isWritten;
    @UnknownObjectField(types={DirectSubstrateObjectConstant.class, PrimitiveConstant.class}, fullyQualifiedTypes={"jdk.vm.ci.meta.NullConstant"})
    JavaConstant constantValue;
    final boolean truffleChildField;
    final boolean truffleChildrenField;
    final boolean truffleCloneableField;

    public SubstrateField(MetaAccessProvider originalMetaAccess, ResolvedJavaField original, int modifiers, HostedStringDeduplication stringTable) {
        VMError.guarantee(!original.isInternal(), "Internal fields are not supported for JIT compilation");
        this.modifiers = modifiers;
        this.name = stringTable.deduplicate(original.getName(), true);
        this.hashCode = original.hashCode();
        this.truffleChildField = original.getAnnotation(Node.Child.class) != null;
        this.truffleChildrenField = original.getAnnotation(Node.Children.class) != null;
        this.truffleCloneableField = originalMetaAccess.lookupJavaType(NodeCloneable.class).isAssignableFrom((ResolvedJavaType)original.getType());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean setAnnotationsEncoding(Object annotationsEncoding) {
        boolean result = this.annotationsEncoding != annotationsEncoding;
        this.annotationsEncoding = annotationsEncoding;
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getAnnotationsEncoding() {
        return this.annotationsEncoding;
    }

    public void setLinks(SubstrateType type, SubstrateType declaringClass) {
        this.type = type;
        this.declaringClass = declaringClass;
    }

    public void setSubstrateData(int location, boolean isAccessed, boolean isWritten, JavaConstant constantValue) {
        this.location = location;
        this.isAccessed = isAccessed;
        this.isWritten = isWritten;
        this.constantValue = constantValue;
    }

    @Override
    public int getLocation() {
        return this.location;
    }

    @Override
    public boolean isAccessed() {
        return this.isAccessed;
    }

    @Override
    public boolean isReachable() {
        return this.isAccessed || this.isWritten;
    }

    @Override
    public boolean isWritten() {
        return this.isWritten;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public JavaKind getStorageKind() {
        return this.getType().getStorageKind();
    }

    public String getName() {
        return this.name;
    }

    public SubstrateType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getOffset() {
        return this.getLocation();
    }

    public boolean isInternal() {
        return false;
    }

    public SubstrateType getDeclaringClass() {
        return this.declaringClass;
    }

    public Annotation[] getAnnotations() {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return AnnotationsEncoding.decodeAnnotations(this.annotationsEncoding).getAnnotation(annotationClass);
    }

    public boolean isSynthetic() {
        throw VMError.unimplemented();
    }

    public String toString() {
        return "SubstrateField<" + this.format("%h.%n") + " location: " + this.location + ">";
    }
}

