/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.genscavenge.JfrGCEventSupport;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrGCName;
import com.oracle.svm.core.jfr.JfrGCNames;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class JfrGCEventFeature
implements Feature {
    JfrGCEventFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.UseSerialGC.getValue();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (HasJfrSupport.get()) {
            JfrGCName name;
            if (SubstrateOptions.UseEpsilonGC.getValue().booleanValue()) {
                name = JfrGCNames.singleton().addGCName("epsilon");
            } else {
                assert (SubstrateOptions.UseSerialGC.getValue().booleanValue());
                name = JfrGCNames.singleton().addGCName("serial");
            }
            ImageSingletons.add(JfrGCEventSupport.class, (Object)new JfrGCEventSupport(name));
        }
    }
}

