/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.option.URIOptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

final class DirectoryOptionOrigin
extends URIOptionOrigin {
    protected DirectoryOptionOrigin(Path originPath) {
        int pathPos = 0;
        int metaInfPos = -1;
        for (Path entry : originPath) {
            if ("META-INF".equals(entry.toString())) {
                metaInfPos = pathPos;
                break;
            }
            ++pathPos;
        }
        VMError.guarantee(metaInfPos > 0, "Invalid directory origin");
        this.container = originPath.getRoot().resolve(originPath.subpath(0, metaInfPos)).toUri();
        this.location = originPath.subpath(metaInfPos, originPath.getNameCount());
    }

    @Override
    public List<String> getRedirectionValues(Path valuesFile) throws IOException {
        Path normalizedRedirPath = Path.of(this.container()).resolve(this.location()).getParent().resolve(valuesFile).normalize();
        return DirectoryOptionOrigin.getRedirectionValuesFromPath(normalizedRedirPath);
    }
}

