/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationImpl;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.AllocationSnippets;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class GenScavengeAllocationSnippets
extends SubstrateAllocationSnippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_INSTANCE = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewInstance", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor SLOW_NEW_ARRAY = SnippetRuntime.findForeignCall(ThreadLocalAllocation.class, "slowPathNewArray", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{SLOW_NEW_INSTANCE, SLOW_NEW_ARRAY};

    GenScavengeAllocationSnippets() {
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        SubstrateAllocationSnippets.registerForeignCalls(foreignCalls);
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static void registerLowering(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        SubstrateAllocationSnippets snippetReceiver = (SubstrateAllocationSnippets)((Object)ImageSingletons.lookup(SubstrateAllocationSnippets.class));
        Templates allocationSnippets = new Templates(snippetReceiver, options, SnippetCounter.Group.NullFactory, providers);
        allocationSnippets.registerLowerings(lowerings);
    }

    @Snippet
    public Object formatObjectSnippet(Word memory, DynamicHub hub, boolean rememberedSet, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getInstanceSize(layoutEncoding);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, false);
        return this.formatObject(objectHeader, size, memory, fillContents, emitMemoryBarrier, false, snippetCounters);
    }

    @Snippet
    public Object formatArraySnippet(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned, AllocationSnippets.FillContent fillContents, int fillStartOffset, boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArraySize(layoutEncoding, length);
        Word objectHeader = GenScavengeAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        Object obj = this.formatArray(objectHeader, size, length, memory, fillContents, fillStartOffset, false, false, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
        this.emitMemoryBarrierIf(emitMemoryBarrier);
        return obj;
    }

    private static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        return ObjectHeaderImpl.encodeAsObjectHeader(hub, rememberedSet, unaligned);
    }

    @Snippet
    public Object allocateStoredContinuationInstance(@Snippet.ConstantParameter DynamicHub hub, int payloadSize, @Snippet.ConstantParameter DynamicHub byteArrayHub, @Snippet.ConstantParameter int byteArrayBaseOffset, @Snippet.ConstantParameter AllocationSnippets.AllocationProfilingData profilingData) {
        int arrayLength = 24 + payloadSize - byteArrayBaseOffset;
        Object result = this.allocateArrayImpl(GenScavengeAllocationSnippets.encodeAsTLABObjectHeader(byteArrayHub), arrayLength, byteArrayBaseOffset, 0, AllocationSnippets.FillContent.WITH_GARBAGE_IF_ASSERTIONS_ENABLED, GenScavengeAllocationSnippets.afterArrayLengthOffset(), false, false, false, false, profilingData);
        UnsignedWord arrayHeader = ObjectHeaderImpl.readHeaderFromObject(result);
        Word header = GenScavengeAllocationSnippets.encodeAsObjectHeader(hub, ObjectHeaderImpl.hasRememberedSet(arrayHeader), ObjectHeaderImpl.isUnalignedHeader(arrayHeader));
        this.initializeObjectHeader(Word.objectToUntrackedPointer((Object)result), header, false);
        ObjectAccess.writeObject((Object)result, (int)hub.getMonitorOffset(), null, (LocationIdentity)LocationIdentity.init());
        StoredContinuationImpl.initializeNewlyAllocated(result, payloadSize);
        this.emitMemoryBarrierIf(true);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    public void initializeObjectHeader(Word memory, Word objectHeader, boolean isArray) {
        Heap.getHeap().getObjectHeader().initializeHeaderOfNewObject((Pointer)memory, objectHeader);
    }

    public boolean useTLAB() {
        return true;
    }

    protected boolean shouldAllocateInTLAB(UnsignedWord size, boolean isArray) {
        return !isArray || size.belowThan(HeapParameters.getLargeArrayThreshold());
    }

    public Word getTLABInfo() {
        return ThreadLocalAllocation.getTlabAddress();
    }

    public Word readTlabTop(Word tlabInfo) {
        return ((ThreadLocalAllocation.Descriptor)tlabInfo).getAllocationTop(TLAB_TOP_IDENTITY);
    }

    public Word readTlabEnd(Word tlabInfo) {
        return ((ThreadLocalAllocation.Descriptor)tlabInfo).getAllocationEnd(TLAB_END_IDENTITY);
    }

    public void writeTlabTop(Word tlabInfo, Word newTop) {
        ((ThreadLocalAllocation.Descriptor)tlabInfo).setAllocationTop((Pointer)newTop, TLAB_TOP_IDENTITY);
    }

    @Override
    protected SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewInstanceStub() {
        return SLOW_NEW_INSTANCE;
    }

    @Override
    protected SnippetRuntime.SubstrateForeignCallDescriptor getSlowNewArrayStub() {
        return SLOW_NEW_ARRAY;
    }

    public static class Templates
    extends SubstrateAllocationSnippets.Templates {
        private final SnippetTemplate.SnippetInfo formatObject;
        private final SnippetTemplate.SnippetInfo formatArray;
        private final SnippetTemplate.SnippetInfo allocateStoredContinuationInstance;

        Templates(SubstrateAllocationSnippets receiver, OptionValues options, SnippetCounter.Group.Factory groupFactory, Providers providers) {
            super(receiver, options, groupFactory, providers);
            this.formatObject = this.snippet((Class<? extends Snippets>)GenScavengeAllocationSnippets.class, "formatObjectSnippet", (ResolvedJavaMethod)null, (Object)receiver, new LocationIdentity[0]);
            this.formatArray = this.snippet((Class<? extends Snippets>)GenScavengeAllocationSnippets.class, "formatArraySnippet", (ResolvedJavaMethod)null, (Object)receiver, new LocationIdentity[0]);
            this.allocateStoredContinuationInstance = this.snippet(GenScavengeAllocationSnippets.class, "allocateStoredContinuationInstance", null, (Object)receiver, SubstrateAllocationSnippets.ALLOCATION_LOCATIONS);
        }

        @Override
        public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            super.registerLowerings(lowerings);
            FormatObjectLowering formatObjectLowering = new FormatObjectLowering();
            lowerings.put(FormatObjectNode.class, formatObjectLowering);
            FormatArrayLowering formatArrayLowering = new FormatArrayLowering();
            lowerings.put(FormatArrayNode.class, formatArrayLowering);
            NewStoredContinuationLowering newStoredContinuationLowering = new NewStoredContinuationLowering();
            lowerings.put(NewStoredContinuationNode.class, newStoredContinuationLowering);
        }

        private class NewStoredContinuationLowering
        implements NodeLoweringProvider<NewStoredContinuationNode> {
            private NewStoredContinuationLowering() {
            }

            @Override
            public void lower(NewStoredContinuationNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                DynamicHub hub = ((SharedType)tool.getMetaAccess().lookupJavaType(StoredContinuation.class)).getHub();
                assert (hub.isStoredContinuationClass());
                ConstantNode hubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                DynamicHub byteArrayHub = ((SharedType)tool.getMetaAccess().lookupJavaType(byte[].class)).getHub();
                ConstantNode byteArrayHubConstant = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(byteArrayHub), (MetaAccessProvider)Templates.this.providers.getMetaAccess(), (StructuredGraph)graph);
                int byteArrayBaseOffset = GenScavengeAllocationSnippets.getArrayBaseOffset(byteArrayHub.getLayoutEncoding());
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.allocateStoredContinuationInstance, graph.getGuardsStage(), tool.getLoweringStage());
                args.addConst("hub", (Object)hubConstant);
                args.add("payloadSize", (Object)node.getPayloadSize());
                args.addConst("byteArrayHub", (Object)byteArrayHubConstant);
                args.addConst("byteArrayBaseOffset", (Object)byteArrayBaseOffset);
                args.addConst("profilingData", (Object)Templates.this.getProfilingData((ValueNode)node, null));
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatArrayLowering
        implements NodeLoweringProvider<FormatArrayNode> {
            private FormatArrayLowering() {
            }

            @Override
            public void lower(FormatArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("length", (Object)node.getLength());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("fillStartOffset", (Object)node.getFillStartOffset());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroing());
                args.addConst("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.addConst("snippetCounters", (Object)Templates.this.snippetCounters);
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private class FormatObjectLowering
        implements NodeLoweringProvider<FormatObjectNode> {
            private FormatObjectLowering() {
            }

            @Override
            public void lower(FormatObjectNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatObject, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.addConst("snippetCounters", (Object)Templates.this.snippetCounters);
                Templates.this.template((ValueNode)node, args).instantiate(Templates.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

