/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.DetachedParkEvent;
import com.oracle.svm.core.thread.ParkEventConsCell;
import com.oracle.svm.core.thread.ParkEventList;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class ParkEvent {
    protected boolean isSleepEvent;
    private ParkEventConsCell consCell;

    protected ParkEvent() {
    }

    protected abstract void reset();

    protected abstract void condWait();

    protected abstract void condTimedWait(long var1);

    protected abstract void unpark();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    ParkEventConsCell consumeConsCell() {
        assert (this.consCell != null) : "Consuming null cons cell.";
        ParkEventConsCell result = this.consCell;
        this.consCell = null;
        return result;
    }

    static ParkEvent initializeOnce(UninterruptibleUtils.AtomicReference<ParkEvent> ref, boolean isSleepEvent) {
        ParkEvent result = ref.get();
        if (result == null) {
            ParkEvent newEvent = ParkEvent.acquire();
            newEvent.consCell = new ParkEventConsCell(newEvent);
            newEvent.isSleepEvent = isSleepEvent;
            newEvent.reset();
            if (ref.compareAndSet(null, newEvent)) {
                result = newEvent;
            } else {
                ParkEvent.release(newEvent);
                result = ref.get();
                VMError.guarantee(result != null, "ParkEvent must never be reset to null once it has been initialized.");
            }
        }
        return result;
    }

    private static ParkEvent acquire() {
        ParkEvent result = ParkEventList.getSingleton().pop();
        if (result == null) {
            result = ((ParkEventFactory)ImageSingletons.lookup(ParkEventFactory.class)).create();
        }
        return result;
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    static void detach(UninterruptibleUtils.AtomicReference<ParkEvent> ref) {
        ParkEvent event = ref.getAndSet(DetachedParkEvent.SINGLETON);
        if (event != null && event != DetachedParkEvent.SINGLETON) {
            ParkEvent.release(event);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void release(ParkEvent event) {
        ParkEventList.getSingleton().push(event);
    }

    public static interface ParkEventFactory {
        public ParkEvent create();
    }
}

