/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.List;
import java.util.Map;

public class InstanceReferenceMapEncoder
extends ReferenceMapEncoder {
    public static final int MAP_HEADER_SIZE = 4;
    public static final int MAP_ENTRY_SIZE = 8;

    @Override
    protected void encodeAll(List<Map.Entry<ReferenceMapEncoder.Input, Long>> sortedEntries) {
        assert (0L == this.writeBuffer.getBytesWritten());
        this.writeBuffer.putS4(0L);
        for (Map.Entry<ReferenceMapEncoder.Input, Long> entry : sortedEntries) {
            ReferenceMapEncoder.Input map = entry.getKey();
            this.encodings.put(map, this.encode(map.getOffsets()));
        }
    }

    private long encode(ReferenceMapEncoder.OffsetIterator offsets) {
        long startIndex = this.writeBuffer.getBytesWritten();
        this.writeBuffer.putS4(-1L);
        int entries = 0;
        int adjacentReferences = 0;
        int offset = 0;
        if (offsets.hasNext()) {
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            boolean compressed = offsets.isNextCompressed();
            int nextAdjacentOffset = 0;
            do {
                assert (!offsets.isNextDerived()) : "derived references are not located within objects";
                assert (compressed == offsets.isNextCompressed()) : "compressed and uncompressed references must not be mixed";
                int nextOffset = offsets.nextInt();
                if (nextOffset == nextAdjacentOffset) {
                    ++adjacentReferences;
                } else {
                    assert (nextOffset >= nextAdjacentOffset) : "values must be strictly increasing";
                    if (adjacentReferences > 0) {
                        this.encodeRun(offset, adjacentReferences);
                        ++entries;
                    }
                    offset = nextOffset;
                    adjacentReferences = 1;
                }
                nextAdjacentOffset = nextOffset + referenceSize;
            } while (offsets.hasNext());
            if (adjacentReferences > 0) {
                this.encodeRun(offset, adjacentReferences);
                ++entries;
            }
        }
        this.writeBuffer.patchS4((long)entries, startIndex);
        return startIndex;
    }

    private void encodeRun(int offset, int refsCount) {
        assert (offset >= 0 && refsCount >= 0);
        this.writeBuffer.putS4((long)offset);
        this.writeBuffer.putU4((long)refsCount);
    }
}

