/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.image.sources.SourceRoot;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;

public class SourceCache {
    protected static final List<Path> classPathEntries = new ArrayList<Path>();
    protected static final List<String> sourcePathEntries = new ArrayList<String>();
    protected List<SourceRoot> srcRoots;
    private static final String[] specialRootModules = new String[]{"jdk.internal.vm.ci", "jdk.internal.vm.compiler"};
    private HashMap<String, List<Path>> specialSrcRoots;
    private final Path basePath = SubstrateOptions.getDebugInfoSourceCacheRoot();

    protected SourceCache() {
        this.srcRoots = new ArrayList<SourceRoot>();
        this.specialSrcRoots = new HashMap();
        this.addJDKSources();
        this.addGraalSources();
        this.addApplicationSources();
    }

    private void addJDKSources() {
        Path srcZipPath;
        String javaHome = System.getProperty("java.home");
        assert (javaHome != null);
        Path javaHomePath = Paths.get("", javaHome);
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            Path srcZipDir = javaHomePath.getParent();
            if (srcZipDir == null) {
                VMError.shouldNotReachHere("Cannot resolve parent directory of " + javaHome);
            }
            srcZipPath = srcZipDir.resolve("src.zip");
        } else {
            srcZipPath = javaHomePath.resolve("lib").resolve("src.zip");
        }
        if (!srcZipPath.toFile().exists()) {
            return;
        }
        try {
            FileSystem srcFileSystem = FileSystems.newFileSystem(srcZipPath, (ClassLoader)null);
            for (Path root : srcFileSystem.getRootDirectories()) {
                this.srcRoots.add(new SourceRoot(root, true));
                if (JavaVersionUtil.JAVA_SPEC < 11) continue;
                for (String specialRootModule : specialRootModules) {
                    ArrayList rootsList = new ArrayList();
                    this.specialSrcRoots.put(specialRootModule, rootsList);
                    Path specialModuleRoot = root.resolve(specialRootModule);
                    Files.find(specialModuleRoot, 2, (path, attributes) -> path.endsWith("src"), new FileVisitOption[0]).forEach(rootsList::add);
                }
            }
        }
        catch (IOException | FileSystemNotFoundException exception) {
            // empty catch block
        }
    }

    private void addGraalSources() {
        classPathEntries.stream().forEach(classPathEntry -> this.addGraalSourceRoot((Path)classPathEntry, true));
        sourcePathEntries.stream().forEach(sourcePathEntry -> this.addGraalSourceRoot(Paths.get(sourcePathEntry, new String[0]), false));
    }

    private void addGraalSourceRoot(Path sourcePath, boolean fromClassPath) {
        block9: {
            try {
                String fileNameString = sourcePath.getFileName().toString();
                if (fileNameString.endsWith(".jar") || fileNameString.endsWith(".src.zip")) {
                    Path srcPath;
                    if (fromClassPath && fileNameString.endsWith(".jar")) {
                        int length = fileNameString.length();
                        fileNameString = fileNameString.substring(0, length - 3) + "src.zip";
                    }
                    if (!(srcPath = sourcePath.getParent().resolve(fileNameString)).toFile().exists()) break block9;
                    try {
                        FileSystem fileSystem = FileSystems.newFileSystem(srcPath, (ClassLoader)null);
                        for (Path root : fileSystem.getRootDirectories()) {
                            this.srcRoots.add(new SourceRoot(root));
                        }
                        break block9;
                    }
                    catch (IOException | FileSystemNotFoundException exception) {
                        break block9;
                    }
                }
                if (fromClassPath) {
                    Path srcPath = sourcePath.resolve("src");
                    this.srcRoots.add(new SourceRoot(srcPath));
                    srcPath = sourcePath.resolve("src_gen");
                    this.srcRoots.add(new SourceRoot(srcPath));
                } else {
                    this.srcRoots.add(new SourceRoot(sourcePath));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void addApplicationSources() {
        classPathEntries.stream().forEach(classPathEntry -> this.addApplicationSourceRoot((Path)classPathEntry, true));
        sourcePathEntries.stream().forEach(sourcePathEntry -> this.addApplicationSourceRoot(Paths.get(sourcePathEntry, new String[0]), false));
    }

    protected void addApplicationSourceRoot(Path sourceRoot, boolean fromClassPath) {
        block13: {
            try {
                File file;
                Path sourcePath = sourceRoot;
                String fileNameString = sourcePath.getFileName().toString();
                if (fileNameString.endsWith(".jar") || fileNameString.endsWith(".zip")) {
                    if (fromClassPath && fileNameString.endsWith(".jar")) {
                        int length = fileNameString.length();
                        fileNameString = fileNameString.substring(0, length - 4) + "-sources.jar";
                    }
                    if (!(sourcePath = sourcePath.getParent().resolve(fileNameString)).toFile().exists()) break block13;
                    try {
                        FileSystem fileSystem = FileSystems.newFileSystem(sourcePath, (ClassLoader)null);
                        for (Path root : fileSystem.getRootDirectories()) {
                            this.srcRoots.add(new SourceRoot(root));
                        }
                        break block13;
                    }
                    catch (IOException | FileSystemNotFoundException fileSystem) {
                        break block13;
                    }
                }
                if (fromClassPath && sourcePath.endsWith("classes")) {
                    Path parent = sourcePath.getParent();
                    if (parent.endsWith("target")) {
                        parent = parent.getParent();
                    }
                    sourcePath = parent.resolve("src");
                }
                if ((file = sourcePath.toFile()).exists() && file.isDirectory()) {
                    Path subPath = sourcePath.resolve("main").resolve("java");
                    file = subPath.toFile();
                    if (file.exists() && file.isDirectory()) {
                        sourcePath = subPath;
                    } else {
                        subPath = sourcePath.resolve("java");
                        file = subPath.toFile();
                        if (file.exists() && file.isDirectory()) {
                            sourcePath = subPath;
                        }
                    }
                    this.srcRoots.add(new SourceRoot(sourcePath));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public Path resolve(Path filePath, Class<?> clazz) {
        File cachedFile = this.findCandidate(filePath);
        if (cachedFile == null) {
            return this.tryCacheFile(filePath, clazz);
        }
        return this.checkCacheFile(filePath, clazz);
    }

    public File findCandidate(Path filePath) {
        File file = this.cachedFile(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    protected Path tryCacheFile(Path filePath, Class<?> clazz) {
        Path targetPath = this.cachedPath(filePath);
        String moduleName = null;
        if (JavaVersionUtil.JAVA_SPEC >= 11 && clazz != null) {
            moduleName = ModuleSupport.getModuleName(clazz);
        }
        if (moduleName != null) {
            for (String specialRootModule : specialRootModules) {
                if (!moduleName.equals(specialRootModule)) continue;
                for (Path srcRoot : this.specialSrcRoots.get(specialRootModule)) {
                    Path sourcePath;
                    String srcRootGroup = srcRoot.subpath(1, 2).toString().replace(".", filePath.getFileSystem().getSeparator());
                    if (!filePath.toString().startsWith(srcRootGroup) || !this.tryCacheFileFromRoot(sourcePath = this.extendPath(srcRoot, filePath), targetPath)) continue;
                    return filePath;
                }
                break;
            }
        }
        for (SourceRoot root : this.srcRoots) {
            Path scopedFilePath = moduleName != null && root.isJDK ? Paths.get(moduleName, filePath.toString()) : filePath;
            Path sourcePath = this.extendPath(root.path, scopedFilePath);
            if (!this.tryCacheFileFromRoot(sourcePath, targetPath)) continue;
            return filePath;
        }
        return null;
    }

    protected boolean tryCacheFileFromRoot(Path sourcePath, Path targetPath) {
        try {
            if (SourceCache.checkSourcePath(sourcePath)) {
                SourceCache.ensureTargetDirs(targetPath.getParent());
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected Path checkCacheFile(Path filePath, Class<?> clazz) {
        Path targetPath = this.cachedPath(filePath);
        String moduleName = null;
        if (JavaVersionUtil.JAVA_SPEC >= 11 && clazz != null) {
            moduleName = ModuleSupport.getModuleName(clazz);
        }
        if (moduleName != null) {
            for (String specialRootModule : specialRootModules) {
                if (!moduleName.equals(specialRootModule)) continue;
                for (Path srcRoot : this.specialSrcRoots.get(specialRootModule)) {
                    String srcRootGroup = srcRoot.subpath(1, 2).toString().replace(".", filePath.getFileSystem().getSeparator());
                    if (!filePath.toString().startsWith(srcRootGroup)) continue;
                    Path sourcePath = this.extendPath(srcRoot, filePath);
                    try {
                        if (!this.tryCheckCacheFile(sourcePath, targetPath)) continue;
                        return filePath;
                    }
                    catch (IOException e) {
                        targetPath.toFile().delete();
                        return this.tryCacheFile(filePath, clazz);
                    }
                }
                break;
            }
        }
        for (SourceRoot root : this.srcRoots) {
            Path scopedFilePath = moduleName != null && root.isJDK ? Paths.get(moduleName, filePath.toString()) : filePath;
            Path sourcePath = this.extendPath(root.path, scopedFilePath);
            try {
                if (!this.tryCheckCacheFile(sourcePath, targetPath)) continue;
                return filePath;
            }
            catch (IOException e) {
                targetPath.toFile().delete();
                return this.tryCacheFile(filePath, clazz);
            }
        }
        targetPath.toFile().delete();
        return null;
    }

    protected boolean tryCheckCacheFile(Path sourcePath, Path targetPath) throws IOException {
        if (SourceCache.checkSourcePath(sourcePath)) {
            FileTime sourceTime = Files.getLastModifiedTime(sourcePath, new LinkOption[0]);
            FileTime destTime = Files.getLastModifiedTime(targetPath, new LinkOption[0]);
            if (destTime.compareTo(sourceTime) < 0) {
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            return true;
        }
        return false;
    }

    protected Path extendPath(Path root, Path filePath) {
        String newSeparator;
        String filePathString = filePath.toString();
        String fileSeparator = filePath.getFileSystem().getSeparator();
        if (!fileSeparator.equals(newSeparator = root.getFileSystem().getSeparator())) {
            filePathString = filePathString.replace(fileSeparator, newSeparator);
        }
        return root.resolve(filePathString);
    }

    protected Path cachedPath(Path candidate) {
        return this.basePath.resolve(candidate);
    }

    protected File cachedFile(Path candidate) {
        return this.cachedPath(candidate).toFile();
    }

    protected static boolean checkSourcePath(Path sourcePath) {
        return Files.isRegularFile(sourcePath, new LinkOption[0]);
    }

    protected static void ensureTargetDirs(Path targetDir) {
        File targetFile;
        if (targetDir != null && !(targetFile = targetDir.toFile()).exists()) {
            targetDir.toFile().mkdirs();
        }
    }

    private static void addClassPathEntry(Path path) {
        classPathEntries.add(path);
    }

    private static void addSourcePathEntry(String path) {
        sourcePathEntries.add(path);
    }

    @AutomaticFeature
    public static class SourceCacheFeature
    implements Feature {
        public void afterAnalysis(Feature.AfterAnalysisAccess access) {
            FeatureImpl.AfterAnalysisAccessImpl accessImpl = (FeatureImpl.AfterAnalysisAccessImpl)access;
            ImageClassLoader loader = accessImpl.getImageClassLoader();
            for (Path entry : loader.classpath()) {
                SourceCache.addClassPathEntry(entry);
            }
            if (SubstrateOptions.DebugInfoSourceSearchPath.getValue() != null) {
                for (String searchPathEntry : OptionUtils.flatten(",", SubstrateOptions.DebugInfoSourceSearchPath.getValue())) {
                    SourceCache.addSourcePathEntry(searchPathEntry);
                }
            }
        }
    }
}

