/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.code.RestrictHeapAccessCalleesImpl;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;

public final class RestrictHeapAccessAnnotationChecker {
    public static void check(DebugContext debug, HostedUniverse universe, Collection<HostedMethod> methods) {
        RestrictHeapAccessWarningVisitor visitor = new RestrictHeapAccessWarningVisitor(universe);
        for (HostedMethod method : methods) {
            visitor.visitMethod(debug, method);
        }
    }

    static Node checkViolatingNode(StructuredGraph graph, RestrictHeapAccess.Access access) {
        if (graph != null) {
            for (Node node : graph.getNodes()) {
                if (RestrictHeapAccessAnnotationChecker.isViolatingNode(node, access)) continue;
                return node;
            }
        }
        return null;
    }

    private static boolean isViolatingNode(Node node, RestrictHeapAccess.Access access) {
        assert (access != RestrictHeapAccess.Access.UNRESTRICTED) : "does not require checks";
        return !RestrictHeapAccessAnnotationChecker.isAllocationNode(node);
    }

    private static boolean isAllocationNode(Node node) {
        return node instanceof AbstractNewObjectNode || node instanceof NewMultiArrayNode;
    }

    static class RestrictHeapAccessWarningVisitor {
        private final HostedUniverse universe;
        private final RestrictHeapAccessCalleesImpl restrictHeapAccessCallees;

        RestrictHeapAccessWarningVisitor(HostedUniverse universe) {
            this.universe = universe;
            this.restrictHeapAccessCallees = (RestrictHeapAccessCalleesImpl)ImageSingletons.lookup(RestrictHeapAccessCallees.class);
        }

        public void visitMethod(DebugContext debug, HostedMethod method) {
            RestrictHeapAccessCalleesImpl.RestrictionInfo info = this.restrictHeapAccessCallees.getRestrictionInfo(method);
            if (info == null || info.getAccess() == RestrictHeapAccess.Access.UNRESTRICTED) {
                return;
            }
            StructuredGraph graph = method.compilationInfo.getGraph();
            if (RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph, info.getAccess()) != null) {
                try (DebugContext.Scope s = debug.scope((Object)"RestrictHeapAccessAnnotationChecker", (Object)graph, (Object)method, (Object)this);){
                    this.postRestrictHeapAccessWarning(method.getWrapped(), this.restrictHeapAccessCallees.getCallerMap());
                }
                catch (Throwable t) {
                    throw debug.handle(t);
                }
            }
        }

        private void postRestrictHeapAccessWarning(AnalysisMethod violatingCallee, Map<AnalysisMethod, RestrictHeapAccessCalleesImpl.RestrictionInfo> callerMap) {
            if (Options.PrintRestrictHeapAccessWarnings.getValue().booleanValue()) {
                RestrictHeapAccess.Access violatedAccess = callerMap.get(violatingCallee).getAccess();
                String message = "@RestrictHeapAccess warning: ";
                ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo> callChain = new ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo>();
                AnalysisMethod current = violatingCallee;
                while (current != null) {
                    RestrictHeapAccessCalleesImpl.RestrictionInfo info = callerMap.get(current);
                    callChain.addFirst(info);
                    current = info.getCaller();
                }
                ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo> allocationList = new ArrayDeque<RestrictHeapAccessCalleesImpl.RestrictionInfo>();
                for (RestrictHeapAccessCalleesImpl.RestrictionInfo element : callChain) {
                    allocationList.addLast(element);
                    if (this.checkHostedViolatingNode(element.getMethod(), element.getAccess()) == null) continue;
                    break;
                }
                assert (!allocationList.isEmpty());
                if (allocationList.size() == 1) {
                    StackTraceElement allocationStackTraceElement = this.getViolatingStackTraceElement(violatingCallee, violatedAccess);
                    message = allocationStackTraceElement != null ? message + "Restricted method '" + allocationStackTraceElement.toString() + "' directly violates restriction " + (Object)((Object)violatedAccess) + "." : message + "Restricted method '" + violatingCallee.format("%H.%n(%p)") + "' directly violates restriction " + (Object)((Object)violatedAccess) + ".";
                } else {
                    RestrictHeapAccessCalleesImpl.RestrictionInfo first = (RestrictHeapAccessCalleesImpl.RestrictionInfo)allocationList.getFirst();
                    RestrictHeapAccessCalleesImpl.RestrictionInfo last = (RestrictHeapAccessCalleesImpl.RestrictionInfo)allocationList.getLast();
                    message = message + "Restricted method: '" + first.getMethod().format("%h.%n(%p)") + "' calls '" + last.getMethod().format("%h.%n(%p)") + "' that violates restriction " + (Object)((Object)violatedAccess) + ".";
                    if (Options.PrintRestrictHeapAccessPath.getValue().booleanValue()) {
                        message = message + "\n  [Path:";
                        for (RestrictHeapAccessCalleesImpl.RestrictionInfo element : allocationList) {
                            if (element == first) continue;
                            message = message + "\n    " + element.getInvocationStackTraceElement().toString();
                        }
                        StackTraceElement allocationStackTraceElement = this.getViolatingStackTraceElement(last.getMethod(), last.getAccess());
                        message = allocationStackTraceElement != null ? message + "\n    " + allocationStackTraceElement.toString() : message + "\n    " + last.getMethod().format("%H.%n(%p)");
                        message = message + "]";
                    }
                }
                throw UserError.abort("%s", message);
            }
        }

        Node checkHostedViolatingNode(AnalysisMethod method, RestrictHeapAccess.Access access) {
            HostedMethod hostedMethod = this.universe.optionalLookup((JavaMethod)method);
            if (hostedMethod != null) {
                StructuredGraph graph = hostedMethod.compilationInfo.getGraph();
                return RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph, access);
            }
            return null;
        }

        private StackTraceElement getViolatingStackTraceElement(AnalysisMethod method, RestrictHeapAccess.Access access) {
            NodeSourcePosition sourcePosition;
            StructuredGraph graph;
            Node node;
            HostedMethod hostedMethod = this.universe.optionalLookup((JavaMethod)method);
            if (hostedMethod != null && (node = RestrictHeapAccessAnnotationChecker.checkViolatingNode(graph = hostedMethod.compilationInfo.getGraph(), access)) != null && (sourcePosition = node.getNodeSourcePosition()) != null && sourcePosition.getBCI() != -1) {
                return method.asStackTraceElement(sourcePosition.getBCI());
            }
            return null;
        }
    }

    public static class Options {
        @Option(help={"Print warnings for @RestrictHeapAccess annotations."})
        public static final HostedOptionKey<Boolean> PrintRestrictHeapAccessWarnings = new HostedOptionKey<Boolean>(true);
        @Option(help={"Print path for @RestrictHeapAccess warnings."})
        public static final HostedOptionKey<Boolean> PrintRestrictHeapAccessPath = new HostedOptionKey<Boolean>(true);
    }
}

