/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.analysis.UnknownFieldHandler;
import jdk.vm.ci.meta.JavaKind;

public class PointsToUnknownFieldHandler
extends UnknownFieldHandler {
    public PointsToUnknownFieldHandler(AnalysisMetaAccess metaAccess) {
        super(metaAccess);
    }

    @Override
    protected void handleUnknownObjectField(BigBang bb, AnalysisField aField, AnalysisType ... declaredTypes) {
        NativeImagePointsToAnalysis analysis = (NativeImagePointsToAnalysis)bb;
        assert (aField.getJavaKind() == JavaKind.Object);
        aField.registerAsWritten(null);
        for (AnalysisType fieldDeclaredType : declaredTypes) {
            AllInstantiatedTypeFlow fieldDeclaredTypeFlow = fieldDeclaredType.getTypeFlow((BigBang)analysis, true);
            if (aField.isStatic()) {
                fieldDeclaredTypeFlow.addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getStaticFieldFlow());
                continue;
            }
            fieldDeclaredTypeFlow.addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getInitialInstanceFieldFlow());
            if (!fieldDeclaredType.isArray()) continue;
            AnalysisType fieldComponentType = fieldDeclaredType.getComponentType();
            aField.getInitialInstanceFieldFlow().addUse((PointsToAnalysis)analysis, (TypeFlow)aField.getInstanceFieldFlow());
            if (fieldComponentType.isPrimitive()) continue;
            ArrayElementsTypeFlow elementsFlow = fieldDeclaredType.getContextInsensitiveAnalysisObject().getArrayElementsFlow((PointsToAnalysis)analysis, true);
            fieldComponentType.getTypeFlow((BigBang)analysis, false).addUse((PointsToAnalysis)analysis, (TypeFlow)elementsFlow);
        }
    }
}

