/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.hub.AnnotatedSuperInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.GenericInfo;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.AnnotationsProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public class DynamicHubInitializer {
    private final SVMHost hostVM;
    private final AnalysisUniverse universe;
    private final AnalysisMetaAccess metaAccess;
    private final UnsupportedFeatures unsupportedFeatures;
    private final ConstantReflectionProvider constantReflection;
    private final Map<GenericInterfacesEncodingKey, Type[]> genericInterfacesMap;
    private final Map<AnnotatedInterfacesEncodingKey, AnnotatedType[]> annotatedInterfacesMap;
    private final Map<InterfacesEncodingKey, DynamicHub[]> interfacesEncodings;

    public DynamicHubInitializer(AnalysisUniverse universe, AnalysisMetaAccess metaAccess, UnsupportedFeatures unsupportedFeatures, ConstantReflectionProvider constantReflection) {
        this.hostVM = (SVMHost)universe.hostVM();
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.unsupportedFeatures = unsupportedFeatures;
        this.constantReflection = constantReflection;
        this.genericInterfacesMap = new ConcurrentHashMap<GenericInterfacesEncodingKey, Type[]>();
        this.annotatedInterfacesMap = new ConcurrentHashMap<AnnotatedInterfacesEncodingKey, AnnotatedType[]>();
        this.interfacesEncodings = new ConcurrentHashMap<InterfacesEncodingKey, DynamicHub[]>();
    }

    public void initializeMetaData(AnalysisType type) {
        assert (type.isReachable());
        DynamicHub hub = this.hostVM.dynamicHub((ResolvedJavaType)type);
        if (hub.getGenericInfo() == null) {
            this.fillGenericInfo(type, hub);
        }
        if (hub.getAnnotatedSuperInfo() == null) {
            this.fillAnnotatedSuperInfo(type, hub);
        }
        if (type.getJavaKind() == JavaKind.Object) {
            if (type.isArray()) {
                hub.getComponentHub().setArrayHub(hub);
            }
            try {
                AnalysisType enclosingType = type.getEnclosingType();
                if (enclosingType != null) {
                    hub.setEnclosingClass(this.hostVM.dynamicHub((ResolvedJavaType)enclosingType));
                }
            }
            catch (UnsupportedFeatureException ex) {
                this.unsupportedFeatures.addMessage(type.toJavaName(true), null, ex.getMessage(), null, (Throwable)ex);
            }
            if (hub.getInterfacesEncoding() == null) {
                this.fillInterfaces(type, hub);
            }
            try {
                Annotation[] annotations = type.getWrappedWithoutResolve().getAnnotations();
                Annotation[] declared = type.getWrappedWithoutResolve().getDeclaredAnnotations();
                hub.setAnnotationsEncoding(AnnotationsProcessor.encodeAnnotations(this.metaAccess, annotations, declared, hub.getAnnotationsEncoding()));
            }
            catch (ArrayStoreException e) {
                hub.setAnnotationsEncoding(e);
            }
            if (type.isEnum() && hub.shouldInitEnumConstants()) {
                if (this.hostVM.getClassInitializationSupport().shouldInitializeAtRuntime((ResolvedJavaType)type)) {
                    hub.initEnumConstantsAtRuntime(type.getJavaClass());
                } else {
                    Enum[] enumConstants;
                    Annotation found = null;
                    for (Annotation annotation : type.getStaticFields()) {
                        if (!annotation.getName().endsWith("$VALUES")) continue;
                        if (found != null) {
                            found = null;
                            break;
                        }
                        found = annotation;
                    }
                    if (found == null) {
                        enumConstants = (Enum[])type.getJavaClass().getEnumConstants();
                    } else {
                        enumConstants = (Enum[])SubstrateObjectConstant.asObject((Constant)this.constantReflection.readFieldValue(found, null));
                        assert (enumConstants != null);
                    }
                    hub.initEnumConstants(enumConstants);
                }
            }
        }
    }

    private static boolean shallowEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static int shallowHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            result = 31 * result + System.identityHashCode(element);
        }
        return result;
    }

    private void fillGenericInfo(AnalysisType type, DynamicHub hub) {
        Type genericSuperClass;
        Type[] cachedGenericInterfaces;
        Type[] allGenericInterfaces;
        Class javaClass = type.getJavaClass();
        TypeVariable<Class<T>>[] typeParameters = javaClass.getTypeParameters();
        try {
            allGenericInterfaces = javaClass.getGenericInterfaces();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            allGenericInterfaces = new Type[]{};
        }
        Type[] genericInterfaces = (Type[])Arrays.stream(allGenericInterfaces).filter(this::isTypeAllowed).toArray(Type[]::new);
        try {
            cachedGenericInterfaces = this.genericInterfacesMap.computeIfAbsent(new GenericInterfacesEncodingKey(genericInterfaces), k -> genericInterfaces);
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            cachedGenericInterfaces = genericInterfaces;
        }
        try {
            genericSuperClass = javaClass.getGenericSuperclass();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            genericSuperClass = null;
        }
        if (!this.isTypeAllowed(genericSuperClass)) {
            genericSuperClass = null;
        }
        hub.setGenericInfo(GenericInfo.factory(typeParameters, cachedGenericInterfaces, genericSuperClass));
    }

    private void fillAnnotatedSuperInfo(AnalysisType type, DynamicHub hub) {
        AnnotatedType[] allAnnotatedInterfaces;
        AnnotatedType annotatedSuperclass;
        Class javaClass = type.getJavaClass();
        try {
            annotatedSuperclass = javaClass.getAnnotatedSuperclass();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            annotatedSuperclass = null;
        }
        if (annotatedSuperclass != null && !this.isTypeAllowed(annotatedSuperclass.getType())) {
            annotatedSuperclass = null;
        }
        try {
            allAnnotatedInterfaces = javaClass.getAnnotatedInterfaces();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException t) {
            allAnnotatedInterfaces = new AnnotatedType[]{};
        }
        AnnotatedType[] annotatedInterfaces = (AnnotatedType[])Arrays.stream(allAnnotatedInterfaces).filter(ai -> this.isTypeAllowed(ai.getType())).toArray(AnnotatedType[]::new);
        AnnotatedType[] cachedAnnotatedInterfaces = this.annotatedInterfacesMap.computeIfAbsent(new AnnotatedInterfacesEncodingKey(annotatedInterfaces), k -> annotatedInterfaces);
        hub.setAnnotatedSuperInfo(AnnotatedSuperInfo.factory(annotatedSuperclass, cachedAnnotatedInterfaces));
    }

    private boolean isTypeAllowed(Type t) {
        if (t instanceof Class) {
            Optional resolved = this.metaAccess.optionalLookupJavaType((Class)t);
            return resolved.isPresent() && this.hostVM.platformSupported(this.universe, (AnnotatedElement)resolved.get());
        }
        return true;
    }

    private void fillInterfaces(AnalysisType type, DynamicHub hub) {
        AnalysisType[] aInterfaces = type.getInterfaces();
        if (aInterfaces.length == 0) {
            hub.setInterfacesEncoding(null);
        } else if (aInterfaces.length == 1) {
            hub.setInterfacesEncoding(this.hostVM.dynamicHub((ResolvedJavaType)aInterfaces[0]));
        } else {
            hub.setInterfacesEncoding(this.interfacesEncodings.computeIfAbsent(new InterfacesEncodingKey(aInterfaces), InterfacesEncodingKey::createHubs));
        }
    }

    class InterfacesEncodingKey {
        final AnalysisType[] aInterfaces;

        InterfacesEncodingKey(AnalysisType[] aInterfaces) {
            this.aInterfaces = aInterfaces;
        }

        DynamicHub[] createHubs() {
            DynamicHub[] hubs = new DynamicHub[this.aInterfaces.length];
            for (int i = 0; i < hubs.length; ++i) {
                hubs[i] = DynamicHubInitializer.this.hostVM.dynamicHub((ResolvedJavaType)this.aInterfaces[i]);
            }
            return hubs;
        }

        public boolean equals(Object obj) {
            return obj instanceof InterfacesEncodingKey && Arrays.equals(this.aInterfaces, ((InterfacesEncodingKey)obj).aInterfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.aInterfaces);
        }
    }

    static class AnnotatedInterfacesEncodingKey {
        final AnnotatedType[] interfaces;

        AnnotatedInterfacesEncodingKey(AnnotatedType[] aInterfaces) {
            this.interfaces = aInterfaces;
        }

        public boolean equals(Object obj) {
            return obj instanceof AnnotatedInterfacesEncodingKey && DynamicHubInitializer.shallowEquals(this.interfaces, ((AnnotatedInterfacesEncodingKey)obj).interfaces);
        }

        public int hashCode() {
            return DynamicHubInitializer.shallowHashCode(this.interfaces);
        }
    }

    static class GenericInterfacesEncodingKey {
        final Type[] interfaces;

        GenericInterfacesEncodingKey(Type[] aInterfaces) {
            this.interfaces = aInterfaces;
        }

        public boolean equals(Object obj) {
            return obj instanceof GenericInterfacesEncodingKey && Arrays.equals(this.interfaces, ((GenericInterfacesEncodingKey)obj).interfaces);
        }

        public int hashCode() {
            return Arrays.hashCode(this.interfaces);
        }
    }
}

