/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import java.io.FileDescriptor;
import java.io.IOException;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class WindowsUtils {
    private static long performanceFrequency = 0L;
    public static final long NANOSECS_PER_SEC = 1000000000L;
    public static final int NANOSECS_PER_MILLISEC = 1000000;
    public static final PointerBase UNINITIALIZED_HANDLE = WordFactory.pointer((long)1L);
    static final PointerBase UNINITIALIZED_POINTER = WordFactory.pointer((long)2989L);

    public static int getpid(Process process) {
        Target_java_lang_ProcessImpl processImpl = SubstrateUtil.cast(process, Target_java_lang_ProcessImpl.class);
        return Process.NoTransitions.GetProcessId((WinBase.HANDLE)WordFactory.pointer((long)processImpl.handle));
    }

    static void setHandle(FileDescriptor descriptor, long handle) {
        SubstrateUtil.cast((Object)descriptor, Target_java_io_FileDescriptor.class).handle = handle;
    }

    static boolean outOfBounds(int off, int len, byte[] array) {
        return off < 0 || len < 0 || array.length - off < len;
    }

    public static String lastErrorString(String defaultMsg) {
        int error = WinBase.GetLastError();
        return defaultMsg + " GetLastError: " + error;
    }

    public static boolean writeBytes(int handle, CCharPointer bytes, UnsignedWord length) {
        CCharPointer curBuf = bytes;
        UnsignedWord curLen = length;
        while (curLen.notEqual(0)) {
            if (handle == -1) {
                return false;
            }
            CIntPointer bytesWritten = (CIntPointer)StackValue.get(CIntPointer.class);
            int ret = FileAPI.WriteFile(handle, curBuf, curLen, bytesWritten, WordFactory.nullPointer());
            if (ret == 0) {
                return false;
            }
            int writtenCount = bytesWritten.read();
            if (curLen.notEqual(writtenCount)) {
                return false;
            }
            curBuf = curBuf.addressOf(writtenCount);
            curLen = curLen.subtract(writtenCount);
        }
        return true;
    }

    static boolean flush(int handle) {
        if (handle == -1) {
            return false;
        }
        int result = FileAPI.FlushFileBuffers(handle);
        return result != 0;
    }

    static void writeBytes(FileDescriptor descriptor, byte[] bytes, int off, int len, boolean append) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (WindowsUtils.outOfBounds(off, len, bytes)) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try (PinnedObject bytesPin = PinnedObject.create((Object)bytes);){
            CCharPointer curBuf = (CCharPointer)bytesPin.addressOfArrayElement(off);
            UnsignedWord curLen = WordFactory.unsigned((int)len);
            int handle = FileAPI.GetStdHandle(FileAPI.STD_ERROR_HANDLE());
            CIntPointer bytesWritten = (CIntPointer)StackValue.get(CIntPointer.class);
            int ret = FileAPI.WriteFile(handle, curBuf, curLen, bytesWritten, WordFactory.nullPointer());
            if (ret == 0) {
                throw new IOException(WindowsUtils.lastErrorString("Write error"));
            }
            int writtenCount = bytesWritten.read();
            if (curLen.notEqual(writtenCount)) {
                throw new IOException(WindowsUtils.lastErrorString("Write error"));
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getNanoCounter() {
        if (performanceFrequency == 0L) {
            CLongPointer count = (CLongPointer)StackValue.get(CLongPointer.class);
            WinBase.QueryPerformanceFrequency(count);
            performanceFrequency = count.read();
        }
        CLongPointer currentCount = (CLongPointer)StackValue.get(CLongPointer.class);
        WinBase.QueryPerformanceCounter(currentCount);
        double current = currentCount.read();
        double freq = performanceFrequency;
        return (long)(current / freq * 1.0E9);
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    static <T extends CFunctionPointer> T getAndCacheFunctionPointer(CFunctionPointerPointer<T> cachedFunctionPointer, CCharPointer dllName, CCharPointer functionName) {
        T functionPointer = cachedFunctionPointer.read();
        if (functionPointer.equal((ComparableWord)UNINITIALIZED_POINTER)) {
            functionPointer = WindowsUtils.getFunctionPointer(dllName, functionName, false);
            cachedFunctionPointer.write(functionPointer);
        }
        return functionPointer;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    static <T extends CFunctionPointer> T getFunctionPointer(CCharPointer dllName, CCharPointer functionName, boolean failOnError) {
        PointerBase functionPointer = LibLoaderAPI.GetProcAddress(WindowsUtils.getDLLHandle(dllName), functionName);
        if (functionPointer.isNull() && failOnError) {
            CEntryPointActions.failFatally(WinBase.GetLastError(), functionName);
        }
        return (T)((CFunctionPointer)functionPointer);
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static WinBase.HMODULE getDLLHandle(CCharPointer dllName) {
        WinBase.HMODULE dllHandle = LibLoaderAPI.GetModuleHandleA(dllName);
        if (dllHandle.isNull()) {
            CEntryPointActions.failFatally(WinBase.GetLastError(), dllName);
        }
        return dllHandle;
    }

    @CPointerTo(nameOfCType="void*")
    static interface CFunctionPointerPointer<T extends CFunctionPointer>
    extends PointerBase {
        public T read();

        public void write(T var1);
    }

    @TargetClass(value=FileDescriptor.class)
    private static final class Target_java_io_FileDescriptor {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=InvalidHandleValueComputer.class)
        long handle;

        private Target_java_io_FileDescriptor() {
        }

        static class InvalidHandleValueComputer
        implements RecomputeFieldValue.CustomFieldValueComputer {
            InvalidHandleValueComputer() {
            }

            @Override
            public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
                return -1L;
            }
        }
    }

    @TargetClass(className="java.lang.ProcessImpl")
    private static final class Target_java_lang_ProcessImpl {
        @Alias
        long handle;

        private Target_java_lang_ProcessImpl() {
        }
    }
}

