/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.util.HostedImageHeapMap;
import com.oracle.svm.core.util.VMError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ImageHeapMap {
    private ImageHeapMap() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> create() {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to create an ImageHeapMap after analysis.");
        return new HostedImageHeapMap(Equivalence.DEFAULT);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <K, V> EconomicMap<K, V> create(Equivalence strategy) {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to create an ImageHeapMap after analysis.");
        return new HostedImageHeapMap(strategy);
    }
}

