/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapPartition;
import com.oracle.svm.core.genscavenge.FillerObjectDummyPartition;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ObjectHeaderImpl
extends ObjectHeader {
    private static final UnsignedWord UNALIGNED_BIT = WordFactory.unsigned((int)1);
    private static final UnsignedWord REMEMBERED_SET_BIT = WordFactory.unsigned((int)2);
    private static final UnsignedWord FORWARDED_BIT = WordFactory.unsigned((int)4);
    private static final int RESERVED_BITS_MASK = 7;
    private static final UnsignedWord MASK_HEADER_BITS = WordFactory.unsigned((int)7);
    private static final UnsignedWord CLEAR_HEADER_BITS = MASK_HEADER_BITS.not();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ObjectHeaderImpl() {
    }

    @Fold
    public static ObjectHeaderImpl getObjectHeaderImpl() {
        ObjectHeaderImpl oh = HeapImpl.getHeapImpl().getObjectHeaderImpl();
        assert (oh != null);
        return oh;
    }

    @Override
    public int getReservedBitsMask() {
        assert (MASK_HEADER_BITS.rawValue() == 7L);
        assert (CLEAR_HEADER_BITS.rawValue() == -8L);
        return 7;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord readHeaderFromPointer(Pointer objectPointer) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)objectPointer.readInt(ObjectHeaderImpl.getHubOffset()));
        }
        return (UnsignedWord)objectPointer.readWord(ObjectHeaderImpl.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord readHeaderFromObject(Object o) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return WordFactory.unsigned((int)ObjectAccess.readInt((Object)o, (int)ObjectHeaderImpl.getHubOffset()));
        }
        return (UnsignedWord)ObjectAccess.readWord((Object)o, (int)ObjectHeaderImpl.getHubOffset());
    }

    public static UnsignedWord readHeaderFromObjectCarefully(Object o) {
        VMError.guarantee(o != null, "ObjectHeader.readHeaderFromObjectCarefully:  o: null");
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(o);
        VMError.guarantee(header.notEqual((UnsignedWord)WordFactory.zero()), "ObjectHeader.readHeaderFromObjectCarefully:  header: 0");
        VMError.guarantee(!ObjectHeaderImpl.isProducedHeapChunkZapped(header), "ObjectHeader.readHeaderFromObjectCarefully:  header: producedZapValue");
        VMError.guarantee(!ObjectHeaderImpl.isConsumedHeapChunkZapped(header), "ObjectHeader.readHeaderFromObjectCarefully:  header: consumedZapValue");
        return header;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub readDynamicHubFromPointer(Pointer ptr) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(ptr);
        return this.dynamicHubFromObjectHeader(header);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public DynamicHub dynamicHubFromObjectHeader(UnsignedWord header) {
        Object objectValue;
        UnsignedWord pointerBits = ObjectHeaderImpl.clearBits(header);
        ReferenceAccess referenceAccess = ReferenceAccess.singleton();
        if (referenceAccess.haveCompressedReferences()) {
            UnsignedWord compressedBits = pointerBits.unsignedShiftRight(ObjectHeaderImpl.getCompressionShift());
            objectValue = referenceAccess.uncompressReference(compressedBits);
        } else {
            objectValue = ((Pointer)pointerBits).toObject();
        }
        return (DynamicHub)objectValue;
    }

    @Override
    public Pointer readPotentialDynamicHubFromPointer(Pointer ptr) {
        UnsignedWord potentialHeader = ObjectHeaderImpl.readHeaderFromPointer(ptr);
        UnsignedWord pointerBits = ObjectHeaderImpl.clearBits(potentialHeader);
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            UnsignedWord compressedBits = pointerBits.unsignedShiftRight(ObjectHeaderImpl.getCompressionShift());
            return KnownIntrinsics.heapBase().add(compressedBits.shiftLeft(ObjectHeaderImpl.getCompressionShift()));
        }
        return (Pointer)pointerBits;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub hub) {
        return ObjectHeaderImpl.encodeAsObjectHeader(hub, false, false);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void initializeHeaderOfNewObject(Pointer objectPointer, Word encodedHub) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            ObjectHeaderImpl.dynamicAssert(ObjectHeaderImpl.getIdentityHashCodeOffset() == ObjectHeaderImpl.getHubOffset() + 4, "assumed layout to optimize initializing write");
            ObjectHeaderImpl.dynamicAssert(encodedHub.and((Word)WordFactory.unsigned((long)-4294967296L)).isNull(), "hub can only use 32 bit");
            objectPointer.writeLong(ObjectHeaderImpl.getHubOffset(), encodedHub.rawValue(), LocationIdentity.INIT_LOCATION);
        } else {
            objectPointer.writeWord(ObjectHeaderImpl.getHubOffset(), (WordBase)encodedHub, LocationIdentity.INIT_LOCATION);
            objectPointer.writeInt(ObjectHeaderImpl.getIdentityHashCodeOffset(), 0, LocationIdentity.INIT_LOCATION);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void dynamicAssert(boolean condition, String msg) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)condition, (String)msg);
        } else assert (condition) : msg;
    }

    private static void writeHeaderToObject(Object o, WordBase header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            ObjectAccess.writeInt((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (int)((int)header.rawValue()));
        } else {
            ObjectAccess.writeWord((Object)o, (int)ObjectHeaderImpl.getHubOffset(), (WordBase)header);
        }
    }

    @Override
    public Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return ObjectHeaderImpl.encodeAsObjectHeader(hub, false, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        Word result = Word.objectToUntrackedPointer((Object)hub);
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && ObjectHeaderImpl.hasBase()) {
            result = result.subtract((UnsignedWord)KnownIntrinsics.heapBase());
        }
        if (rememberedSet) {
            result = result.or(REMEMBERED_SET_BIT);
        }
        if (unaligned) {
            result = result.or(UNALIGNED_BIT);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord clearBits(UnsignedWord header) {
        return header.and(CLEAR_HEADER_BITS);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isProducedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapParameters.getProducedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapParameters.getProducedHeapChunkZapWord());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isConsumedHeapChunkZapped(UnsignedWord header) {
        if (ObjectHeaderImpl.getReferenceSize() == 4) {
            return header.equal(HeapParameters.getConsumedHeapChunkZapInt());
        }
        return header.equal((UnsignedWord)HeapParameters.getConsumedHeapChunkZapWord());
    }

    @Override
    public long encodeAsImageHeapObjectHeader(ImageHeapObject obj, long hubOffsetFromHeapBase) {
        long header = hubOffsetFromHeapBase;
        assert ((header & MASK_HEADER_BITS.rawValue()) == 0L) : "Object header bits must be zero initially";
        if (HeapImpl.usesImageHeapCardMarking()) {
            if (obj.getPartition() instanceof ChunkedImageHeapPartition) {
                ChunkedImageHeapPartition partition = (ChunkedImageHeapPartition)obj.getPartition();
                if (partition.isWritable()) {
                    header |= REMEMBERED_SET_BIT.rawValue();
                }
                if (partition.usesUnalignedObjects()) {
                    header |= UNALIGNED_BIT.rawValue();
                }
            } else assert (obj.getPartition() instanceof FillerObjectDummyPartition);
        }
        return header;
    }

    public static boolean isAlignedObject(Object o) {
        return !ObjectHeaderImpl.isUnalignedObject(o);
    }

    public static boolean isAlignedHeader(UnsignedWord header) {
        return !ObjectHeaderImpl.isUnalignedHeader(header);
    }

    public static boolean isUnalignedObject(Object obj) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromObject(obj);
        return ObjectHeaderImpl.isUnalignedHeader(header);
    }

    public static boolean isUnalignedHeader(UnsignedWord header) {
        return header.and(UNALIGNED_BIT).notEqual(0);
    }

    public static void setRememberedSetBit(Object o) {
        UnsignedWord oldHeader = ObjectHeaderImpl.readHeaderFromObject(o);
        UnsignedWord newHeader = oldHeader.or(REMEMBERED_SET_BIT);
        ObjectHeaderImpl.writeHeaderToObject(o, (WordBase)newHeader);
    }

    public static boolean hasRememberedSet(UnsignedWord header) {
        return header.and(REMEMBERED_SET_BIT).notEqual(0);
    }

    public static boolean isPointerToForwardedObject(Pointer p) {
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(p);
        return ObjectHeaderImpl.isForwardedHeader(header);
    }

    public static boolean isForwardedHeader(UnsignedWord header) {
        return ObjectHeaderImpl.testForwardedHeaderBit(header);
    }

    private static boolean testForwardedHeaderBit(UnsignedWord headerBits) {
        return headerBits.and(FORWARDED_BIT).notEqual(0);
    }

    static Object getForwardedObject(Pointer ptr) {
        return ObjectHeaderImpl.getForwardedObject(ptr, ObjectHeaderImpl.readHeaderFromPointer(ptr));
    }

    static Object getForwardedObject(Pointer ptr, UnsignedWord header) {
        assert (ObjectHeaderImpl.isForwardedHeader(header));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            if (ReferenceAccess.singleton().getCompressEncoding().hasShift()) {
                ObjectLayout layout = ConfigurationValues.getObjectLayout();
                assert (layout.isAligned(ObjectHeaderImpl.getHubOffset()) && 2 * ObjectHeaderImpl.getReferenceSize() <= layout.getAlignment()) : "Forwarding reference must fit after hub";
                int forwardRefOffset = ObjectHeaderImpl.getHubOffset() + ObjectHeaderImpl.getReferenceSize();
                return ReferenceAccess.singleton().readObjectAt(ptr.add(forwardRefOffset), true);
            }
            return ReferenceAccess.singleton().uncompressReference(ObjectHeaderImpl.clearBits(header));
        }
        return ((Pointer)ObjectHeaderImpl.clearBits(header)).toObject();
    }

    @AlwaysInline(value="GC performance")
    static void installForwardingPointer(Object original, Object copy) {
        Word forwardHeader;
        assert (!ObjectHeaderImpl.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            if (ReferenceAccess.singleton().getCompressEncoding().hasShift()) {
                forwardHeader = WordFactory.unsigned((long)-1085102592571150096L);
                ObjectAccess.writeObject((Object)original, (int)(ObjectHeaderImpl.getHubOffset() + ObjectHeaderImpl.getReferenceSize()), (Object)copy);
            } else {
                forwardHeader = ReferenceAccess.singleton().getCompressedRepresentation(copy);
            }
        } else {
            forwardHeader = Word.objectToUntrackedPointer((Object)copy);
        }
        assert (ObjectHeaderImpl.getHeaderBitsFromHeader((UnsignedWord)forwardHeader).equal(0));
        ObjectHeaderImpl.writeHeaderToObject(original, (WordBase)forwardHeader.or(FORWARDED_BIT));
        assert (ObjectHeaderImpl.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)original)));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getHeaderBitsFromHeader(UnsignedWord header) {
        assert (!ObjectHeaderImpl.isProducedHeapChunkZapped(header)) : "Produced chunk zap value";
        assert (!ObjectHeaderImpl.isConsumedHeapChunkZapped(header)) : "Consumed chunk zap value";
        return header.and(MASK_HEADER_BITS);
    }

    static UnsignedWord getHeaderBitsFromHeaderCarefully(UnsignedWord header) {
        VMError.guarantee(!ObjectHeaderImpl.isProducedHeapChunkZapped(header), "Produced chunk zap value");
        VMError.guarantee(!ObjectHeaderImpl.isConsumedHeapChunkZapped(header), "Consumed chunk zap value");
        return header.and(MASK_HEADER_BITS);
    }

    @Fold
    static int getHubOffset() {
        return ConfigurationValues.getObjectLayout().getHubOffset();
    }

    @Fold
    static int getIdentityHashCodeOffset() {
        return ConfigurationValues.getObjectLayout().getIdentityHashCodeOffset();
    }

    @Fold
    static int getReferenceSize() {
        return ConfigurationValues.getObjectLayout().getReferenceSize();
    }

    @Fold
    static boolean hasBase() {
        return ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static int getCompressionShift() {
        return ReferenceAccess.singleton().getCompressEncoding().getShift();
    }
}

