// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HeapOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class HeapOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "ImageHeapCardMarking": {
            return OptionDescriptor.create(
                /*name*/ "ImageHeapCardMarking",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "ImageHeapCardMarking",
                /*option*/ HeapOptions.ImageHeapCardMarking,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCSummary": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCSummary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print summary GC information after application main method returns.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCSummary",
                /*option*/ HeapOptions.PrintGCSummary,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimeStamps": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimeStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print a time stamp at each collection, if +PrintGC or +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCTimeStamps",
                /*option*/ HeapOptions.PrintGCTimeStamps,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintGCTimes": {
            return OptionDescriptor.create(
                /*name*/ "PrintGCTimes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the time for each of the phases of each collection, if +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintGCTimes",
                /*option*/ HeapOptions.PrintGCTimes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintHeapShape": {
            return OptionDescriptor.create(
                /*name*/ "PrintHeapShape",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print the shape of the heap before and after each collection, if +VerboseGC.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "PrintHeapShape",
                /*option*/ HeapOptions.PrintHeapShape,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SoftRefLRUPolicyMSPerMB": {
            return OptionDescriptor.create(
                /*name*/ "SoftRefLRUPolicyMSPerMB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Soft references: this number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "SoftRefLRUPolicyMSPerMB",
                /*option*/ HeapOptions.SoftRefLRUPolicyMSPerMB,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyReferences": {
            return OptionDescriptor.create(
                /*name*/ "VerifyReferences",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify all object references if VerifyHeap is enabled.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyReferences",
                /*option*/ HeapOptions.VerifyReferences,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyRememberedSet": {
            return OptionDescriptor.create(
                /*name*/ "VerifyRememberedSet",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify the remembered set if VerifyHeap is enabled.",
                /*declaringClass*/ HeapOptions.class,
                /*fieldName*/ "VerifyRememberedSet",
                /*option*/ HeapOptions.VerifyRememberedSet,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 8;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ImageHeapCardMarking");
                    case 1: return get("PrintGCSummary");
                    case 2: return get("PrintGCTimeStamps");
                    case 3: return get("PrintGCTimes");
                    case 4: return get("PrintHeapShape");
                    case 5: return get("SoftRefLRUPolicyMSPerMB");
                    case 6: return get("VerifyReferences");
                    case 7: return get("VerifyRememberedSet");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
