/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapParameters;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class HeapParameters_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AlignedHeapChunkSize": {
                return OptionDescriptor.create((String)"AlignedHeapChunkSize", (OptionType)OptionType.Debug, Long.class, (String)"The size of an aligned chunk.", HeapParameters.Options.class, (String)"AlignedHeapChunkSize", HeapParameters.Options.AlignedHeapChunkSize, (boolean)false, (String)"");
            }
            case "CollectYoungGenerationSeparately": {
                return OptionDescriptor.create((String)"CollectYoungGenerationSeparately", (OptionType)OptionType.Debug, Boolean.class, (String)"Determines if a full GC collects the young generation separately or together with the old generation.", HeapParameters.Options.class, (String)"CollectYoungGenerationSeparately", HeapParameters.Options.CollectYoungGenerationSeparately, (boolean)false, (String)"");
            }
            case "LargeArrayThreshold": {
                return OptionDescriptor.create((String)"LargeArrayThreshold", (OptionType)OptionType.Debug, Long.class, (String)"The size at or above which an array will be allocated in its own unaligned chunk.  0 implies (AlignedHeapChunkSize / 8).", HeapParameters.Options.class, (String)"LargeArrayThreshold", HeapParameters.Options.LargeArrayThreshold, (boolean)false, (String)"");
            }
            case "MaxSurvivorSpaces": {
                return OptionDescriptor.create((String)"MaxSurvivorSpaces", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of survivor spaces.", HeapParameters.Options.class, (String)"MaxSurvivorSpaces", HeapParameters.Options.MaxSurvivorSpaces, (boolean)false, (String)"");
            }
            case "MaximumHeapSizePercent": {
                return OptionDescriptor.create((String)"MaximumHeapSizePercent", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum heap size as percent of physical memory", HeapParameters.Options.class, (String)"MaximumHeapSizePercent", HeapParameters.Options.MaximumHeapSizePercent, (boolean)false, (String)"");
            }
            case "MaximumYoungGenerationSizePercent": {
                return OptionDescriptor.create((String)"MaximumYoungGenerationSizePercent", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum size of the young generation as a percentage of the maximum heap size", HeapParameters.Options.class, (String)"MaximumYoungGenerationSizePercent", HeapParameters.Options.MaximumYoungGenerationSizePercent, (boolean)false, (String)"");
            }
            case "TraceHeapChunks": {
                return OptionDescriptor.create((String)"TraceHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.", HeapParameters.Options.class, (String)"TraceHeapChunks", HeapParameters.Options.TraceHeapChunks, (boolean)false, (String)"");
            }
            case "ZapChunks": {
                return OptionDescriptor.create((String)"ZapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Fill unused memory chunks with a sentinel value.", HeapParameters.Options.class, (String)"ZapChunks", HeapParameters.Options.ZapChunks, (boolean)false, (String)"");
            }
            case "ZapConsumedHeapChunks": {
                return OptionDescriptor.create((String)"ZapConsumedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"After use, Fill memory chunks with a sentinel value.", HeapParameters.Options.class, (String)"ZapConsumedHeapChunks", HeapParameters.Options.ZapConsumedHeapChunks, (boolean)false, (String)"");
            }
            case "ZapProducedHeapChunks": {
                return OptionDescriptor.create((String)"ZapProducedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Before use, fill memory chunks with a sentinel value.", HeapParameters.Options.class, (String)"ZapProducedHeapChunks", HeapParameters.Options.ZapProducedHeapChunks, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 10;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return HeapParameters_OptionDescriptors.this.get("AlignedHeapChunkSize");
                    }
                    case 1: {
                        return HeapParameters_OptionDescriptors.this.get("CollectYoungGenerationSeparately");
                    }
                    case 2: {
                        return HeapParameters_OptionDescriptors.this.get("LargeArrayThreshold");
                    }
                    case 3: {
                        return HeapParameters_OptionDescriptors.this.get("MaxSurvivorSpaces");
                    }
                    case 4: {
                        return HeapParameters_OptionDescriptors.this.get("MaximumHeapSizePercent");
                    }
                    case 5: {
                        return HeapParameters_OptionDescriptors.this.get("MaximumYoungGenerationSizePercent");
                    }
                    case 6: {
                        return HeapParameters_OptionDescriptors.this.get("TraceHeapChunks");
                    }
                    case 7: {
                        return HeapParameters_OptionDescriptors.this.get("ZapChunks");
                    }
                    case 8: {
                        return HeapParameters_OptionDescriptors.this.get("ZapConsumedHeapChunks");
                    }
                    case 9: {
                        return HeapParameters_OptionDescriptors.this.get("ZapProducedHeapChunks");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

