/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.SubstitutionReportFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import java.nio.file.Paths;
import java.util.Arrays;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class NativeImageOptions {
    public static final int DEFAULT_MAX_ANALYSIS_SCALING = 16;
    @Option(help={"Comma separated list of CPU features that will be enabled while building the target executable, irrespective of whether they are supported by the hosted environment. Note that enabling features not present within the target environment may result in application crashes. The specific options available are target platform dependent. See --list-cpu-features for feature list."}, type=OptionType.User)
    public static final HostedOptionKey<LocatableMultiOptionValue.Strings> CPUFeatures = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    @APIOption(name={"list-cpu-features"})
    @Option(help={"Show CPU features specific to the target platform and exit."}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> ListCPUFeatures = new HostedOptionKey<Boolean>(false);
    @Option(help={"Overrides CPUFeatures and uses the native architecture, i.e., the architecture of a machine that builds an image. NativeArchitecture takes precedence over CPUFeatures"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> NativeArchitecture = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print information about classes, methods, and fields that are present in the native image"})
    public static final HostedOptionKey<Boolean> PrintUniverse = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print logging information during compilation"})
    public static final HostedOptionKey<Boolean> PrintAOTCompilation = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print class statistics of native image heap"})
    public static final HostedOptionKey<Boolean> PrintHeapHistogram = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print statistics of methods in native image heap"})
    public static final HostedOptionKey<Boolean> PrintMethodHistogram = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print the sizes of the elements of the built image"})
    public static final HostedOptionKey<Boolean> PrintImageElementSizes = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print the sizes of the native image heap as the image is built"})
    public static final HostedOptionKey<Boolean> PrintImageHeapPartitionSizes = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print a list of active features"})
    public static final HostedOptionKey<Boolean> PrintFeatures = new HostedOptionKey<Boolean>(false);
    @Option(help={"Directory for temporary files generated during native image generation. If this option is specified, the temporary files are not deleted so that you can inspect them after native image generation"})
    public static final HostedOptionKey<String> TempDirectory = new HostedOptionKey<String>("");
    @Option(help={"Suppress console error output for unittests"})
    public static final HostedOptionKey<Boolean> SuppressStderr = new HostedOptionKey<Boolean>(false);
    @Option(help={"Suppress console normal output for unittests"})
    public static final HostedOptionKey<Boolean> SuppressStdout = new HostedOptionKey<Boolean>(false);
    @Option(help={"Allow MethodTypeFlow to see @Fold methods"})
    public static final HostedOptionKey<Boolean> AllowFoldMethods = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"report-unsupported-elements-at-runtime"})
    @Option(help={"Report usage of unsupported methods and fields at run time when they are accessed the first time, instead of as an error during image building"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> ReportUnsupportedElementsAtRuntime = new HostedOptionKey<Boolean>(false);
    @APIOption(name={"allow-incomplete-classpath"})
    @Option(help={"Allow image building with an incomplete class path: report type resolution errors at run time when they are accessed the first time, instead of during image building"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> AllowIncompleteClasspath = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            PointstoOptions.UnresolvedIsError.update(values, (Object)(newValue == false ? 1 : 0));
        }
    };
    @Option(help={"C standard to use in header files. Possible values are: [C89, C99, C11]"}, type=OptionType.User)
    public static final HostedOptionKey<String> CStandard = new HostedOptionKey<String>("C89");
    @Option(help={"The maximum number of threads to use concurrently during native image generation."})
    public static final HostedOptionKey<Integer> NumberOfThreads = new HostedOptionKey<Integer>(Math.min(Runtime.getRuntime().availableProcessors(), 32));
    @Option(help={"The number of threads to use for analysis during native image generation. The number must be smaller than the NumberOfThreads."})
    public static final HostedOptionKey<Integer> NumberOfAnalysisThreads = new HostedOptionKey<Integer>(-1);
    @Option(help={"Return after analysis"})
    public static final HostedOptionKey<Boolean> ReturnAfterAnalysis = new HostedOptionKey<Boolean>(false);
    @Option(help={"Exit after analysis"})
    public static final HostedOptionKey<Boolean> ExitAfterAnalysis = new HostedOptionKey<Boolean>(false);
    @Option(help={"Exit after writing relocatable file"})
    public static final HostedOptionKey<Boolean> ExitAfterRelocatableImageWrite = new HostedOptionKey<Boolean>(false);
    @Option(help={"Throw unsafe operation offset errors.)"})
    public static final HostedOptionKey<Boolean> ThrowUnsafeOffsetErrors = new HostedOptionKey<Boolean>(true);
    @Option(help={"Print unsafe operation offset warnings.)"})
    public static final HostedOptionKey<Boolean> ReportUnsafeOffsetWarnings = new HostedOptionKey<Boolean>(false);
    @Option(help={"Print unsafe operation offset warnings.)"})
    public static final HostedOptionKey<Boolean> UnsafeOffsetWarningsAreFatal = new HostedOptionKey<Boolean>(false);
    @Option(help={"Show exception stack traces for exceptions during image building.)"})
    public static final HostedOptionKey<Boolean> ReportExceptionStackTraces = new HostedOptionKey<Boolean>(NativeImageOptions.areAssertionsEnabled());
    @Option(help={"Maximum number of types allowed in the image. Used for tests where small number of types is necessary."}, type=OptionType.Debug)
    public static final HostedOptionKey<Integer> MaxReachableTypes = new HostedOptionKey<Integer>(-1);
    @Option(help={"Sets the dir where diagnostic information is dumped."})
    public static final HostedOptionKey<String> DiagnosticsDir = new HostedOptionKey<String>(Paths.get("reports", ReportUtils.timeStampedFileName((String)"diagnostics", (String)"")).toString());
    @Option(help={"Enables the diagnostic mode."})
    public static final HostedOptionKey<Boolean> DiagnosticsMode = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                ClassInitializationOptions.PrintClassInitialization.update(values, true);
                SubstitutionReportFeature.Options.ReportPerformedSubstitutions.update(values, true);
                SubstrateOptions.DumpTargetInfo.update(values, true);
                PrintFeatures.update(values, true);
            }
        }
    };

    private static boolean areAssertionsEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    public static CStandards getCStandard() {
        try {
            return CStandards.valueOf(CStandard.getValue());
        }
        catch (IllegalArgumentException e) {
            throw UserError.abort("C standard %s is not supported. Supported standards are: %s", CStandard.getValue(), Arrays.toString((Object[])CStandards.values()));
        }
    }

    public static int getMaximumNumberOfConcurrentThreads(OptionValues optionValues) {
        int maxNumberOfThreads = (Integer)NumberOfThreads.getValue(optionValues);
        if (maxNumberOfThreads < 0) {
            throw UserError.abort("Number of threads can't be negative. Set the NumberOfThreads flag to a positive value.", new Object[0]);
        }
        return maxNumberOfThreads;
    }

    public static int getMaximumNumberOfAnalysisThreads(OptionValues optionValues) {
        int analysisThreads;
        int optionValue = (Integer)NumberOfAnalysisThreads.getValue(optionValues);
        int n = analysisThreads = NumberOfAnalysisThreads.hasBeenSet(optionValues) ? optionValue : Math.min(NativeImageOptions.getMaximumNumberOfConcurrentThreads(optionValues), 16);
        if (analysisThreads < 0) {
            throw UserError.abort("Number of analysis threads can't be negative. Set the NumberOfAnalysisThreads flag to a positive value.", new Object[0]);
        }
        if (analysisThreads > (Integer)NumberOfThreads.getValue(optionValues)) {
            throw UserError.abort("Number of analysis threads can't be larger than NumberOfThreads. Set the NumberOfAnalysisThreads flag to a positive value smaller than NumberOfThreads.", new Object[0]);
        }
        return analysisThreads;
    }

    public static enum CStandards {
        C89,
        C99,
        C11;


        public boolean compatibleWith(CStandards standard) {
            return this.compareTo(standard) >= 0;
        }
    }
}

