/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class SubstrateOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AOTInline": {
                return OptionDescriptor.create((String)"AOTInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTInline", SubstrateOptions.AOTInline, (boolean)false, (String)"");
            }
            case "AOTTrivialInline": {
                return OptionDescriptor.create((String)"AOTTrivialInline", (OptionType)OptionType.Debug, Boolean.class, (String)"Perform trivial method inlining in the AOT compiled native image", SubstrateOptions.class, (String)"AOTTrivialInline", SubstrateOptions.AOTTrivialInline, (boolean)false, (String)"");
            }
            case "APIFunctionPrefix": {
                return OptionDescriptor.create((String)"APIFunctionPrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of API functions.", SubstrateOptions.class, (String)"APIFunctionPrefix", SubstrateOptions.APIFunctionPrefix, (boolean)false, (String)"");
            }
            case "ActiveProcessorCount": {
                return OptionDescriptor.create((String)"ActiveProcessorCount", (OptionType)OptionType.Debug, Integer.class, (String)"Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.", SubstrateOptions.class, (String)"ActiveProcessorCount", SubstrateOptions.ActiveProcessorCount, (boolean)false, (String)"");
            }
            case "AllocateInstancePrefetchLines": {
                return OptionDescriptor.create((String)"AllocateInstancePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the object address using prefetch instructions.", SubstrateOptions.class, (String)"AllocateInstancePrefetchLines", SubstrateOptions.AllocateInstancePrefetchLines, (boolean)false, (String)"");
            }
            case "AllocatePrefetchDistance": {
                return OptionDescriptor.create((String)"AllocatePrefetchDistance", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.", SubstrateOptions.class, (String)"AllocatePrefetchDistance", SubstrateOptions.AllocatePrefetchDistance, (boolean)false, (String)"");
            }
            case "AllocatePrefetchInstr": {
                return OptionDescriptor.create((String)"AllocatePrefetchInstr", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.", SubstrateOptions.class, (String)"AllocatePrefetchInstr", SubstrateOptions.AllocatePrefetchInstr, (boolean)false, (String)"");
            }
            case "AllocatePrefetchLines": {
                return OptionDescriptor.create((String)"AllocatePrefetchLines", (OptionType)OptionType.Debug, Integer.class, (String)"Number of cache lines to load after the array allocation using prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchLines", SubstrateOptions.AllocatePrefetchLines, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStepSize": {
                return OptionDescriptor.create((String)"AllocatePrefetchStepSize", (OptionType)OptionType.Debug, Integer.class, (String)"Sets the step size (in bytes) for sequential prefetch instructions.", SubstrateOptions.class, (String)"AllocatePrefetchStepSize", SubstrateOptions.AllocatePrefetchStepSize, (boolean)false, (String)"");
            }
            case "AllocatePrefetchStyle": {
                return OptionDescriptor.create((String)"AllocatePrefetchStyle", (OptionType)OptionType.Debug, Integer.class, (String)"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.", SubstrateOptions.class, (String)"AllocatePrefetchStyle", SubstrateOptions.AllocatePrefetchStyle, (boolean)false, (String)"");
            }
            case "AutomaticReferenceHandling": {
                return OptionDescriptor.create((String)"AutomaticReferenceHandling", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if the reference handling is executed automatically or manually.", SubstrateOptions.class, (String)"AutomaticReferenceHandling", SubstrateOptions.AutomaticReferenceHandling, (boolean)false, (String)"");
            }
            case "CCompilerOption": {
                return OptionDescriptor.create((String)"CCompilerOption", (OptionType)OptionType.User, LocatableMultiOptionValue.Strings.class, (String)"Provide custom C compiler option used for query code compilation.", SubstrateOptions.class, (String)"CCompilerOption", SubstrateOptions.CCompilerOption, (boolean)false, (String)"");
            }
            case "CCompilerPath": {
                return OptionDescriptor.create((String)"CCompilerPath", (OptionType)OptionType.User, String.class, (String)"Provide custom path to C compiler used for query code compilation and linking.", SubstrateOptions.class, (String)"CCompilerPath", SubstrateOptions.CCompilerPath, (boolean)false, (String)"");
            }
            case "CLibraryPath": {
                return OptionDescriptor.create((String)"CLibraryPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Search path for C libraries passed to the linker (list of comma-separated directories)", SubstrateOptions.class, (String)"CLibraryPath", SubstrateOptions.CLibraryPath, (boolean)false, (String)"");
            }
            case "CheckToolchain": {
                return OptionDescriptor.create((String)"CheckToolchain", (OptionType)OptionType.Expert, Boolean.class, (String)"Check if native-toolchain is known to work with native-image", SubstrateOptions.class, (String)"CheckToolchain", SubstrateOptions.CheckToolchain, (boolean)false, (String)"");
            }
            case "Class": {
                return OptionDescriptor.create((String)"Class", (OptionType)OptionType.User, String.class, (String)"Class containing the default entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Class", SubstrateOptions.Class, (boolean)false, (String)"");
            }
            case "CodeAlignment": {
                return OptionDescriptor.create((String)"CodeAlignment", (OptionType)OptionType.Debug, Integer.class, (String)"Alignment of AOT and JIT compiled code in bytes.", SubstrateOptions.class, (String)"CodeAlignment", SubstrateOptions.CodeAlignment, (boolean)false, (String)"");
            }
            case "CompilationIsolateAddressSpaceSize": {
                return OptionDescriptor.create((String)"CompilationIsolateAddressSpaceSize", (OptionType)OptionType.Debug, Long.class, (String)"Size of the reserved address space of each compilation isolate (0: default for new isolates).", SubstrateOptions.class, (String)"CompilationIsolateAddressSpaceSize", SubstrateOptions.CompilationIsolateAddressSpaceSize, (boolean)false, (String)"");
            }
            case "CompileInIsolates": {
                return OptionDescriptor.create((String)"CompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"CompileInIsolates", SubstrateOptions.ConcealedOptions.CompileInIsolates, (boolean)false, (String)"");
            }
            case "CompilerBackend": {
                return OptionDescriptor.create((String)"CompilerBackend", (OptionType)OptionType.User, String.class, (String)"Backend used by the compiler", SubstrateOptions.class, (String)"CompilerBackend", SubstrateOptions.CompilerBackend, (boolean)false, (String)"");
            }
            case "ConfigureReflectionMetadata": {
                return OptionDescriptor.create((String)"ConfigureReflectionMetadata", (OptionType)OptionType.Expert, Boolean.class, (String)"Enable runtime instantiation of reflection objects for non-invoked methods.", SubstrateOptions.class, (String)"ConfigureReflectionMetadata", SubstrateOptions.ConfigureReflectionMetadata, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogExitOnTimeout": {
                return OptionDescriptor.create((String)"DeadlockWatchdogExitOnTimeout", (OptionType)OptionType.Expert, Boolean.class, (String)"Exit the image builder VM after printing call stacks", SubstrateOptions.class, (String)"DeadlockWatchdogExitOnTimeout", SubstrateOptions.DeadlockWatchdogExitOnTimeout, (boolean)false, (String)"");
            }
            case "DeadlockWatchdogInterval": {
                return OptionDescriptor.create((String)"DeadlockWatchdogInterval", (OptionType)OptionType.Expert, Integer.class, (String)"The interval in minutes between watchdog checks (0 disables the watchdog)", SubstrateOptions.class, (String)"DeadlockWatchdogInterval", SubstrateOptions.DeadlockWatchdogInterval, (boolean)false, (String)"");
            }
            case "DebugInfoSourceCacheRoot": {
                return OptionDescriptor.create((String)"DebugInfoSourceCacheRoot", (OptionType)OptionType.Debug, String.class, (String)"Directory under which to create source file cache for Application or GraalVM classes", SubstrateOptions.class, (String)"DebugInfoSourceCacheRoot", SubstrateOptions.DebugInfoSourceCacheRoot, (boolean)false, (String)"");
            }
            case "DebugInfoSourceSearchPath": {
                return OptionDescriptor.create((String)"DebugInfoSourceSearchPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)", SubstrateOptions.class, (String)"DebugInfoSourceSearchPath", SubstrateOptions.DebugInfoSourceSearchPath, (boolean)false, (String)"");
            }
            case "DeleteLocalSymbols": {
                return OptionDescriptor.create((String)"DeleteLocalSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to remove all local symbols from image.", SubstrateOptions.class, (String)"DeleteLocalSymbols", SubstrateOptions.DeleteLocalSymbols, (boolean)false, (String)"");
            }
            case "DetectUserDirectoriesInImageHeap": {
                return OptionDescriptor.create((String)"DetectUserDirectoriesInImageHeap", (OptionType)OptionType.User, Boolean.class, (String)"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring", SubstrateOptions.class, (String)"DetectUserDirectoriesInImageHeap", SubstrateOptions.DetectUserDirectoriesInImageHeap, (boolean)false, (String)"");
            }
            case "DiagnosticDetails": {
                return OptionDescriptor.create((String)"DiagnosticDetails", (OptionType)OptionType.Expert, String.class, (String)"Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.", SubstrateOptions.class, (String)"DiagnosticDetails", SubstrateOptions.DiagnosticDetails, (boolean)false, (String)"");
            }
            case "DisableTypeIdResultVerification": {
                return OptionDescriptor.create((String)"DisableTypeIdResultVerification", (OptionType)OptionType.Debug, Boolean.class, (String)"For internal purposes only. Disables type id result verification even when running with assertions enabled.", SubstrateOptions.class, (String)"DisableTypeIdResultVerification", SubstrateOptions.DisableTypeIdResultVerification, (boolean)false, (String)"");
            }
            case "DumpTargetInfo": {
                return OptionDescriptor.create((String)"DumpTargetInfo", (OptionType)OptionType.User, Boolean.class, (String)"Show native-toolchain information and image-build settings", SubstrateOptions.class, (String)"DumpTargetInfo", SubstrateOptions.DumpTargetInfo, (boolean)false, (String)"");
            }
            case "EnableAllSecurityServices": {
                return OptionDescriptor.create((String)"EnableAllSecurityServices", (OptionType)OptionType.Debug, Boolean.class, (String)"Add all security service classes to the generated image.", SubstrateOptions.class, (String)"EnableAllSecurityServices", SubstrateOptions.EnableAllSecurityServices, (boolean)true, (String)"");
            }
            case "EnableSignalAPI": {
                return OptionDescriptor.create((String)"EnableSignalAPI", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal). Defaults to false for shared library and true for executables", SubstrateOptions.class, (String)"EnableSignalAPI", SubstrateOptions.EnableSignalAPI, (boolean)false, (String)"");
            }
            case "EnableURLProtocols": {
                return OptionDescriptor.create((String)"EnableURLProtocols", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"List of comma separated URL protocols to enable.", SubstrateOptions.class, (String)"EnableURLProtocols", SubstrateOptions.EnableURLProtocols, (boolean)false, (String)"");
            }
            case "EnableWildcardExpansion": {
                return OptionDescriptor.create((String)"EnableWildcardExpansion", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable wildcard expansion in command line arguments on Windows.", SubstrateOptions.class, (String)"EnableWildcardExpansion", SubstrateOptions.EnableWildcardExpansion, (boolean)false, (String)"");
            }
            case "EntryPointNamePrefix": {
                return OptionDescriptor.create((String)"EntryPointNamePrefix", (OptionType)OptionType.Debug, String.class, (String)"Prefix that is added to the names of entry point methods.", SubstrateOptions.class, (String)"EntryPointNamePrefix", SubstrateOptions.EntryPointNamePrefix, (boolean)false, (String)"");
            }
            case "FallbackThreshold": {
                return OptionDescriptor.create((String)"FallbackThreshold", (OptionType)OptionType.Debug, Integer.class, (String)"Define when fallback-image generation should be used.", SubstrateOptions.class, (String)"FallbackThreshold", SubstrateOptions.FallbackThreshold, (boolean)false, (String)"");
            }
            case "FlightRecorder": {
                return OptionDescriptor.create((String)"FlightRecorder", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Flight Recorder.", SubstrateOptions.class, (String)"FlightRecorder", SubstrateOptions.FlightRecorder, (boolean)false, (String)"");
            }
            case "FlightRecorderLogging": {
                return OptionDescriptor.create((String)"FlightRecorderLogging", (OptionType)OptionType.Debug, String.class, (String)"Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]", (String[])new String[]{"", "When this option is not set, logging is enabled at a level of WARNING.", "When this option is set to the empty string, logging is enabled at a level of INFO.", "When this option is set to \"disable\", logging is disabled entirely.", "", "Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.", "A tag combination without a level is given a default level of INFO.", "Messages with tags that match a given tag combination are set to log at that tag combination's level.", "If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.", "Otherwise, messages whose tags are a subset of the tag combination are matched.", "Specifying \"all\" instead of a tag combination matches all tag combinations.", "If more than one tag combination matches a message's tags, the rightmost one will apply.", "Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.", "This option is case insensitive.", "", "Available log levels:", "[trace, debug, info, warning, error, off]", "", "Available log tags:", "[jfr, system, event, setting, bytecode, parser, metadata, dcmd]"}, SubstrateOptions.class, (String)"FlightRecorderLogging", SubstrateOptions.FlightRecorderLogging, (boolean)false, (String)"");
            }
            case "FoldSecurityManagerGetter": {
                return OptionDescriptor.create((String)"FoldSecurityManagerGetter", (OptionType)OptionType.Expert, Boolean.class, (String)"Fold SecurityManager getter.", SubstrateOptions.class, (String)"FoldSecurityManagerGetter", SubstrateOptions.FoldSecurityManagerGetter, (boolean)false, (String)"");
            }
            case "ForceNoROSectionRelocations": {
                return OptionDescriptor.create((String)"ForceNoROSectionRelocations", (OptionType)OptionType.Debug, Boolean.class, (String)"Use only a writable native image heap (requires ld.gold linker)", SubstrateOptions.class, (String)"ForceNoROSectionRelocations", SubstrateOptions.ForceNoROSectionRelocations, (boolean)false, (String)"");
            }
            case "GenerateDebugInfo": {
                return OptionDescriptor.create((String)"GenerateDebugInfo", (OptionType)OptionType.Debug, Integer.class, (String)"Insert debug info into the generated native image or library", SubstrateOptions.class, (String)"GenerateDebugInfo", SubstrateOptions.GenerateDebugInfo, (boolean)false, (String)"");
            }
            case "ImageSymbolsPrefix": {
                return OptionDescriptor.create((String)"ImageSymbolsPrefix", (OptionType)OptionType.Debug, String.class, (String)"Common prefix used by method symbols in image.", SubstrateOptions.class, (String)"ImageSymbolsPrefix", SubstrateOptions.ImageSymbolsPrefix, (boolean)false, (String)"");
            }
            case "IncludeMethodData": {
                return OptionDescriptor.create((String)"IncludeMethodData", (OptionType)OptionType.Expert, Boolean.class, (String)"Include a list of methods included in the image for runtime inspection.", SubstrateOptions.class, (String)"IncludeMethodData", SubstrateOptions.IncludeMethodData, (boolean)false, (String)"");
            }
            case "IncludeNodeSourcePositions": {
                return OptionDescriptor.create((String)"IncludeNodeSourcePositions", (OptionType)OptionType.Debug, Boolean.class, (String)"Track NodeSourcePositions during runtime-compilation", SubstrateOptions.class, (String)"IncludeNodeSourcePositions", SubstrateOptions.IncludeNodeSourcePositions, (boolean)false, (String)"");
            }
            case "InstallExitHandlers": {
                return OptionDescriptor.create((String)"InstallExitHandlers", (OptionType)OptionType.User, Boolean.class, (String)"Provide java.lang.Terminator exit handlers for executable images", SubstrateOptions.class, (String)"InstallExitHandlers", SubstrateOptions.InstallExitHandlers, (boolean)false, (String)"");
            }
            case "InternalSymbolsAreGlobal": {
                return OptionDescriptor.create((String)"InternalSymbolsAreGlobal", (OptionType)OptionType.Debug, Boolean.class, (String)"Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.", SubstrateOptions.class, (String)"InternalSymbolsAreGlobal", SubstrateOptions.InternalSymbolsAreGlobal, (boolean)false, (String)"");
            }
            case "InternalThreadStackSize": {
                return OptionDescriptor.create((String)"InternalThreadStackSize", (OptionType)OptionType.Expert, Long.class, (String)"The size of each internal thread stack, in bytes.", SubstrateOptions.class, (String)"InternalThreadStackSize", SubstrateOptions.InternalThreadStackSize, (boolean)false, (String)"");
            }
            case "JNI": {
                return OptionDescriptor.create((String)"JNI", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable Java Native Interface (JNI) support.", SubstrateOptions.class, (String)"JNI", SubstrateOptions.JNI, (boolean)false, (String)"");
            }
            case "JNIExportSymbols": {
                return OptionDescriptor.create((String)"JNIExportSymbols", (OptionType)OptionType.User, Boolean.class, (String)"Export Invocation API symbols.", SubstrateOptions.class, (String)"JNIExportSymbols", SubstrateOptions.JNIExportSymbols, (boolean)false, (String)"");
            }
            case "JNIVerboseLookupErrors": {
                return OptionDescriptor.create((String)"JNIVerboseLookupErrors", (OptionType)OptionType.User, Boolean.class, (String)"Report information about known JNI elements when lookup fails", SubstrateOptions.class, (String)"JNIVerboseLookupErrors", SubstrateOptions.JNIVerboseLookupErrors, (boolean)false, (String)"");
            }
            case "LinkerRPath": {
                return OptionDescriptor.create((String)"LinkerRPath", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Path passed to the linker as the -rpath (list of comma-separated directories)", SubstrateOptions.class, (String)"LinkerRPath", SubstrateOptions.LinkerRPath, (boolean)false, (String)"");
            }
            case "MaxDirectMemorySize": {
                return OptionDescriptor.create((String)"MaxDirectMemorySize", (OptionType)OptionType.Debug, Long.class, (String)"Maximum total size of NIO direct-buffer allocations", SubstrateOptions.class, (String)"MaxDirectMemorySize", SubstrateOptions.MaxDirectMemorySize, (boolean)false, (String)"");
            }
            case "MaxInvokesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxInvokesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of invokes in a method so that it is considered trivial (for testing only).", SubstrateOptions.class, (String)"MaxInvokesInTrivialMethod", SubstrateOptions.MaxInvokesInTrivialMethod, (boolean)false, (String)"");
            }
            case "MaxJavaStackTraceDepth": {
                return OptionDescriptor.create((String)"MaxJavaStackTraceDepth", (OptionType)OptionType.User, Integer.class, (String)"The maximum number of lines in the stack trace for Java exceptions (0 means all)", SubstrateOptions.class, (String)"MaxJavaStackTraceDepth", SubstrateOptions.MaxJavaStackTraceDepth, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialLeafMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialLeafMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.", SubstrateOptions.class, (String)"MaxNodesInTrivialLeafMethod", SubstrateOptions.MaxNodesInTrivialLeafMethod, (boolean)false, (String)"");
            }
            case "MaxNodesInTrivialMethod": {
                return OptionDescriptor.create((String)"MaxNodesInTrivialMethod", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of nodes in a method so that it is considered trivial.", SubstrateOptions.class, (String)"MaxNodesInTrivialMethod", SubstrateOptions.MaxNodesInTrivialMethod, (boolean)false, (String)"");
            }
            case "MaxUnrolledObjectZeroingStores": {
                return OptionDescriptor.create((String)"MaxUnrolledObjectZeroingStores", (OptionType)OptionType.Debug, Integer.class, (String)"Define the maximum number of stores for which the loop that zeroes out objects is unrolled.", SubstrateOptions.class, (String)"MaxUnrolledObjectZeroingStores", SubstrateOptions.MaxUnrolledObjectZeroingStores, (boolean)false, (String)"");
            }
            case "Method": {
                return OptionDescriptor.create((String)"Method", (OptionType)OptionType.Debug, String.class, (String)"Name of the main entry point method. Optional if --shared is used.", SubstrateOptions.class, (String)"Method", SubstrateOptions.Method, (boolean)false, (String)"");
            }
            case "Module": {
                return OptionDescriptor.create((String)"Module", (OptionType)OptionType.User, String.class, (String)"Module containing the class that contains the main entry point. Optional if --shared is used.", SubstrateOptions.class, (String)"Module", SubstrateOptions.Module, (boolean)false, (String)"");
            }
            case "MultiThreaded": {
                return OptionDescriptor.create((String)"MultiThreaded", (OptionType)OptionType.Debug, Boolean.class, (String)"Enable support for threads and and thread-local variables (disable for single-threaded implementation)", SubstrateOptions.class, (String)"MultiThreaded", SubstrateOptions.MultiThreaded, (boolean)false, (String)"");
            }
            case "Name": {
                return OptionDescriptor.create((String)"Name", (OptionType)OptionType.User, String.class, (String)"Name of the output file to be generated", SubstrateOptions.class, (String)"Name", SubstrateOptions.Name, (boolean)false, (String)"");
            }
            case "NeverInline": {
                return OptionDescriptor.create((String)"NeverInline", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Pattern for disabling inlining of methods during image generation.", (String[])new String[]{"The syntax for a pattern is:", "", "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .", "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .", "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .", "  Class = { package \".\" } class .", "", "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.", "", "Examples of method filters:", "---------", "  visit(Argument;BlockScope)", "", "  Matches all methods named \"visit\", with the first parameter of", "  type \"Argument\", and the second parameter of type \"BlockScope\".", "  The packages of the parameter types are irrelevant.", "---------", "  arraycopy(Object;;;;)", "", "  Matches all methods named \"arraycopy\", with the first parameter", "  of type \"Object\", and four more parameters of any type. The", "  packages of the parameter types are irrelevant.", "---------", "  org.graalvm.compiler.core.graph.PostOrderNodeIterator.*", "", "  Matches all methods in the class \"org.graalvm.compiler.core.graph.PostOrderNodeIterator\".", "---------", "  *", "", "  Matches all methods in all classes", "---------", "  org.graalvm.compiler.core.graph.*.visit", "", "  Matches all methods named \"visit\" in classes in the package", "  \"org.graalvm.compiler.core.graph\".", "---------", "  arraycopy,toString", "", "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator."}, SubstrateOptions.class, (String)"NeverInline", SubstrateOptions.NeverInline, (boolean)false, (String)"");
            }
            case "OmitInlinedMethodDebugLineInfo": {
                return OptionDescriptor.create((String)"OmitInlinedMethodDebugLineInfo", (OptionType)OptionType.Debug, Boolean.class, (String)"Omit generation of DebugLineInfo originating from inlined methods", SubstrateOptions.class, (String)"OmitInlinedMethodDebugLineInfo", SubstrateOptions.OmitInlinedMethodDebugLineInfo, (boolean)false, (String)"");
            }
            case "Optimize": {
                return OptionDescriptor.create((String)"Optimize", (OptionType)OptionType.User, Integer.class, (String)"Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations.", SubstrateOptions.class, (String)"Optimize", SubstrateOptions.Optimize, (boolean)false, (String)"");
            }
            case "PageSize": {
                return OptionDescriptor.create((String)"PageSize", (OptionType)OptionType.Debug, Integer.class, (String)"Define PageSize of a machine that runs the image. The default = 0 (== same as host machine page size)", SubstrateOptions.class, (String)"PageSize", SubstrateOptions.PageSize, (boolean)false, (String)"");
            }
            case "ParseOnce": {
                return OptionDescriptor.create((String)"ParseOnce", (OptionType)OptionType.Debug, Boolean.class, (String)"When true, compiler graphs are parsed only once before static analysis. When false, compiler graphs are parsed for static analysis and again for AOT compilation.", SubstrateOptions.class, (String)"ParseOnce", SubstrateOptions.ParseOnce, (boolean)false, (String)"");
            }
            case "ParseRuntimeOptions": {
                return OptionDescriptor.create((String)"ParseRuntimeOptions", (OptionType)OptionType.Debug, Boolean.class, (String)"Parse and consume standard options and system properties from the command line arguments when the VM is created.", SubstrateOptions.class, (String)"ParseRuntimeOptions", SubstrateOptions.ParseRuntimeOptions, (boolean)false, (String)"");
            }
            case "Path": {
                return OptionDescriptor.create((String)"Path", (OptionType)OptionType.User, String.class, (String)"Directory of the image file to be generated", SubstrateOptions.class, (String)"Path", SubstrateOptions.Path, (boolean)false, (String)"");
            }
            case "PreserveFramePointer": {
                return OptionDescriptor.create((String)"PreserveFramePointer", (OptionType)OptionType.Debug, Boolean.class, (String)"Saves stack base pointer on the stack on method entry.", SubstrateOptions.class, (String)"PreserveFramePointer", SubstrateOptions.PreserveFramePointer, (boolean)false, (String)"");
            }
            case "PrintFlags": {
                return OptionDescriptor.create((String)"PrintFlags", (OptionType)OptionType.Debug, String.class, (String)"Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug).", SubstrateOptions.class, (String)"PrintFlags", SubstrateOptions.PrintFlags, (boolean)false, (String)"");
            }
            case "PrintFlagsWithExtraHelp": {
                return OptionDescriptor.create((String)"PrintFlagsWithExtraHelp", (OptionType)OptionType.Debug, String.class, (String)"Print extra help, if available, based on comma-separated option names. Pass * to show all options that contain extra help.", SubstrateOptions.class, (String)"PrintFlagsWithExtraHelp", SubstrateOptions.PrintFlagsWithExtraHelp, (boolean)false, (String)"");
            }
            case "RemoveUnusedSymbols": {
                return OptionDescriptor.create((String)"RemoveUnusedSymbols", (OptionType)OptionType.Debug, Boolean.class, (String)"Use linker option to prevent unreferenced symbols in image.", SubstrateOptions.class, (String)"RemoveUnusedSymbols", SubstrateOptions.RemoveUnusedSymbols, (boolean)false, (String)"");
            }
            case "ReportAnalysisForbiddenType": {
                return OptionDescriptor.create((String)"ReportAnalysisForbiddenType", (OptionType)OptionType.Debug, LocatableMultiOptionValue.Strings.class, (String)"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, Reachable).", SubstrateOptions.class, (String)"ReportAnalysisForbiddenType", SubstrateOptions.ReportAnalysisForbiddenType, (boolean)false, (String)"");
            }
            case "SharedLibrary": {
                return OptionDescriptor.create((String)"SharedLibrary", (OptionType)OptionType.Debug, Boolean.class, (String)"Build shared library", SubstrateOptions.class, (String)"SharedLibrary", SubstrateOptions.SharedLibrary, (boolean)false, (String)"");
            }
            case "SpawnIsolates": {
                return OptionDescriptor.create((String)"SpawnIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support multiple isolates.", SubstrateOptions.class, (String)"SpawnIsolates", SubstrateOptions.SpawnIsolates, (boolean)false, (String)"");
            }
            case "StackSize": {
                return OptionDescriptor.create((String)"StackSize", (OptionType)OptionType.User, Long.class, (String)"The size of each thread stack at run-time, in bytes.", SubstrateOptions.class, (String)"StackSize", SubstrateOptions.StackSize, (boolean)false, (String)"");
            }
            case "StackTrace": {
                return OptionDescriptor.create((String)"StackTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Provide method names for stack traces.", SubstrateOptions.class, (String)"StackTrace", SubstrateOptions.StackTrace, (boolean)false, (String)"");
            }
            case "StartFlightRecording": {
                return OptionDescriptor.create((String)"StartFlightRecording", (OptionType)OptionType.Debug, String.class, (String)"Start flight recording with options.", SubstrateOptions.class, (String)"StartFlightRecording", SubstrateOptions.StartFlightRecording, (boolean)false, (String)"");
            }
            case "StaticExecutable": {
                return OptionDescriptor.create((String)"StaticExecutable", (OptionType)OptionType.Debug, Boolean.class, (String)"Build statically linked executable (requires static libc and zlib)", SubstrateOptions.class, (String)"StaticExecutable", SubstrateOptions.StaticExecutable, (boolean)false, (String)"");
            }
            case "StaticExecutableWithDynamicLibC": {
                return OptionDescriptor.create((String)"StaticExecutableWithDynamicLibC", (OptionType)OptionType.Expert, Boolean.class, (String)"Builds a statically linked executable with libc dynamically linked", SubstrateOptions.class, (String)"StaticExecutableWithDynamicLibC", SubstrateOptions.StaticExecutableWithDynamicLibC, (boolean)false, (String)"");
            }
            case "StrictQueryCodeCompilation": {
                return OptionDescriptor.create((String)"StrictQueryCodeCompilation", (OptionType)OptionType.User, Boolean.class, (String)"Use strict checks when performing query code compilation.", SubstrateOptions.class, (String)"StrictQueryCodeCompilation", SubstrateOptions.StrictQueryCodeCompilation, (boolean)false, (String)"");
            }
            case "SupportCompileInIsolates": {
                return OptionDescriptor.create((String)"SupportCompileInIsolates", (OptionType)OptionType.Debug, Boolean.class, (String)"Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).", SubstrateOptions.ConcealedOptions.class, (String)"SupportCompileInIsolates", SubstrateOptions.ConcealedOptions.SupportCompileInIsolates, (boolean)false, (String)"");
            }
            case "TargetPlatform": {
                return OptionDescriptor.create((String)"TargetPlatform", (OptionType)OptionType.Debug, String.class, (String)"Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.", SubstrateOptions.class, (String)"TargetPlatform", SubstrateOptions.TargetPlatform, (boolean)false, (String)"");
            }
            case "TearDownFailureNanos": {
                return OptionDescriptor.create((String)"TearDownFailureNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.", SubstrateOptions.class, (String)"TearDownFailureNanos", SubstrateOptions.TearDownFailureNanos, (boolean)false, (String)"");
            }
            case "TearDownWarningNanos": {
                return OptionDescriptor.create((String)"TearDownWarningNanos", (OptionType)OptionType.Debug, Long.class, (String)"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.", SubstrateOptions.class, (String)"TearDownWarningNanos", SubstrateOptions.TearDownWarningNanos, (boolean)false, (String)"");
            }
            case "TraceClassInitialization": {
                return OptionDescriptor.create((String)"TraceClassInitialization", (OptionType)OptionType.Debug, String.class, (String)"Comma-separated list of fully-qualified class names that class initialization is traced for.", SubstrateOptions.class, (String)"TraceClassInitialization", SubstrateOptions.TraceClassInitialization, (boolean)false, (String)"");
            }
            case "TraceNativeToolUsage": {
                return OptionDescriptor.create((String)"TraceNativeToolUsage", (OptionType)OptionType.User, Boolean.class, (String)"Trace all native tool invocations as part of image building", SubstrateOptions.class, (String)"TraceNativeToolUsage", SubstrateOptions.TraceNativeToolUsage, (boolean)false, (String)"");
            }
            case "TraceObjectInstantiation": {
                return OptionDescriptor.create((String)"TraceObjectInstantiation", (OptionType)OptionType.Debug, String.class, (String)"Comma-separated list of fully-qualified class names that object instantiation is traced for.", SubstrateOptions.class, (String)"TraceObjectInstantiation", SubstrateOptions.TraceObjectInstantiation, (boolean)false, (String)"");
            }
            case "TraceVMOperations": {
                return OptionDescriptor.create((String)"TraceVMOperations", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace VMOperation execution.", SubstrateOptions.class, (String)"TraceVMOperations", SubstrateOptions.TraceVMOperations, (boolean)false, (String)"");
            }
            case "UseCalleeSavedRegisters": {
                return OptionDescriptor.create((String)"UseCalleeSavedRegisters", (OptionType)OptionType.Debug, Boolean.class, (String)"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)", SubstrateOptions.class, (String)"UseCalleeSavedRegisters", SubstrateOptions.UseCalleeSavedRegisters, (boolean)false, (String)"");
            }
            case "UseDedicatedVMOperationThread": {
                return OptionDescriptor.create((String)"UseDedicatedVMOperationThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if VM operations should be executed in a dedicated thread.", SubstrateOptions.class, (String)"UseDedicatedVMOperationThread", SubstrateOptions.UseDedicatedVMOperationThread, (boolean)false, (String)"");
            }
            case "UseEpsilonGC": {
                return OptionDescriptor.create((String)"UseEpsilonGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a no-op GC", SubstrateOptions.class, (String)"UseEpsilonGC", SubstrateOptions.UseEpsilonGC, (boolean)false, (String)"");
            }
            case "UseLoom": {
                return OptionDescriptor.create((String)"UseLoom", (OptionType)OptionType.Debug, Boolean.class, (String)"Build with Loom JDK", SubstrateOptions.class, (String)"UseLoom", SubstrateOptions.UseLoom, (boolean)false, (String)"");
            }
            case "UseNullRegion": {
                return OptionDescriptor.create((String)"UseNullRegion", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a null region is present between the heap base and the image heap.", SubstrateOptions.class, (String)"UseNullRegion", SubstrateOptions.UseNullRegion, (boolean)false, (String)"");
            }
            case "UseReferenceHandlerThread": {
                return OptionDescriptor.create((String)"UseReferenceHandlerThread", (OptionType)OptionType.Expert, Boolean.class, (String)"Populate reference queues in a separate thread rather than after a garbage collection.", SubstrateOptions.class, (String)"UseReferenceHandlerThread", SubstrateOptions.UseReferenceHandlerThread, (boolean)false, (String)"");
            }
            case "UseRememberedSet": {
                return OptionDescriptor.create((String)"UseRememberedSet", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a remembered sets is used, which is necessary for collecting the young and old generation independently.", SubstrateOptions.ConcealedOptions.class, (String)"UseRememberedSet", SubstrateOptions.ConcealedOptions.UseRememberedSet, (boolean)false, (String)"");
            }
            case "UseSerialGC": {
                return OptionDescriptor.create((String)"UseSerialGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Use a serial GC", SubstrateOptions.class, (String)"UseSerialGC", SubstrateOptions.UseSerialGC, (boolean)false, (String)"");
            }
            case "VerifyNamingConventions": {
                return OptionDescriptor.create((String)"VerifyNamingConventions", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify naming conventions during image construction.", SubstrateOptions.class, (String)"VerifyNamingConventions", SubstrateOptions.VerifyNamingConventions, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 98;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTInline");
                    }
                    case 1: {
                        return SubstrateOptions_OptionDescriptors.this.get("AOTTrivialInline");
                    }
                    case 2: {
                        return SubstrateOptions_OptionDescriptors.this.get("APIFunctionPrefix");
                    }
                    case 3: {
                        return SubstrateOptions_OptionDescriptors.this.get("ActiveProcessorCount");
                    }
                    case 4: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocateInstancePrefetchLines");
                    }
                    case 5: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchDistance");
                    }
                    case 6: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchInstr");
                    }
                    case 7: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchLines");
                    }
                    case 8: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStepSize");
                    }
                    case 9: {
                        return SubstrateOptions_OptionDescriptors.this.get("AllocatePrefetchStyle");
                    }
                    case 10: {
                        return SubstrateOptions_OptionDescriptors.this.get("AutomaticReferenceHandling");
                    }
                    case 11: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerOption");
                    }
                    case 12: {
                        return SubstrateOptions_OptionDescriptors.this.get("CCompilerPath");
                    }
                    case 13: {
                        return SubstrateOptions_OptionDescriptors.this.get("CLibraryPath");
                    }
                    case 14: {
                        return SubstrateOptions_OptionDescriptors.this.get("CheckToolchain");
                    }
                    case 15: {
                        return SubstrateOptions_OptionDescriptors.this.get("Class");
                    }
                    case 16: {
                        return SubstrateOptions_OptionDescriptors.this.get("CodeAlignment");
                    }
                    case 17: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilationIsolateAddressSpaceSize");
                    }
                    case 18: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompileInIsolates");
                    }
                    case 19: {
                        return SubstrateOptions_OptionDescriptors.this.get("CompilerBackend");
                    }
                    case 20: {
                        return SubstrateOptions_OptionDescriptors.this.get("ConfigureReflectionMetadata");
                    }
                    case 21: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogExitOnTimeout");
                    }
                    case 22: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeadlockWatchdogInterval");
                    }
                    case 23: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceCacheRoot");
                    }
                    case 24: {
                        return SubstrateOptions_OptionDescriptors.this.get("DebugInfoSourceSearchPath");
                    }
                    case 25: {
                        return SubstrateOptions_OptionDescriptors.this.get("DeleteLocalSymbols");
                    }
                    case 26: {
                        return SubstrateOptions_OptionDescriptors.this.get("DetectUserDirectoriesInImageHeap");
                    }
                    case 27: {
                        return SubstrateOptions_OptionDescriptors.this.get("DiagnosticDetails");
                    }
                    case 28: {
                        return SubstrateOptions_OptionDescriptors.this.get("DisableTypeIdResultVerification");
                    }
                    case 29: {
                        return SubstrateOptions_OptionDescriptors.this.get("DumpTargetInfo");
                    }
                    case 30: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableAllSecurityServices");
                    }
                    case 31: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableSignalAPI");
                    }
                    case 32: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableURLProtocols");
                    }
                    case 33: {
                        return SubstrateOptions_OptionDescriptors.this.get("EnableWildcardExpansion");
                    }
                    case 34: {
                        return SubstrateOptions_OptionDescriptors.this.get("EntryPointNamePrefix");
                    }
                    case 35: {
                        return SubstrateOptions_OptionDescriptors.this.get("FallbackThreshold");
                    }
                    case 36: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorder");
                    }
                    case 37: {
                        return SubstrateOptions_OptionDescriptors.this.get("FlightRecorderLogging");
                    }
                    case 38: {
                        return SubstrateOptions_OptionDescriptors.this.get("FoldSecurityManagerGetter");
                    }
                    case 39: {
                        return SubstrateOptions_OptionDescriptors.this.get("ForceNoROSectionRelocations");
                    }
                    case 40: {
                        return SubstrateOptions_OptionDescriptors.this.get("GenerateDebugInfo");
                    }
                    case 41: {
                        return SubstrateOptions_OptionDescriptors.this.get("ImageSymbolsPrefix");
                    }
                    case 42: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeMethodData");
                    }
                    case 43: {
                        return SubstrateOptions_OptionDescriptors.this.get("IncludeNodeSourcePositions");
                    }
                    case 44: {
                        return SubstrateOptions_OptionDescriptors.this.get("InstallExitHandlers");
                    }
                    case 45: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalSymbolsAreGlobal");
                    }
                    case 46: {
                        return SubstrateOptions_OptionDescriptors.this.get("InternalThreadStackSize");
                    }
                    case 47: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNI");
                    }
                    case 48: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIExportSymbols");
                    }
                    case 49: {
                        return SubstrateOptions_OptionDescriptors.this.get("JNIVerboseLookupErrors");
                    }
                    case 50: {
                        return SubstrateOptions_OptionDescriptors.this.get("LinkerRPath");
                    }
                    case 51: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxDirectMemorySize");
                    }
                    case 52: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxInvokesInTrivialMethod");
                    }
                    case 53: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxJavaStackTraceDepth");
                    }
                    case 54: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialLeafMethod");
                    }
                    case 55: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxNodesInTrivialMethod");
                    }
                    case 56: {
                        return SubstrateOptions_OptionDescriptors.this.get("MaxUnrolledObjectZeroingStores");
                    }
                    case 57: {
                        return SubstrateOptions_OptionDescriptors.this.get("Method");
                    }
                    case 58: {
                        return SubstrateOptions_OptionDescriptors.this.get("Module");
                    }
                    case 59: {
                        return SubstrateOptions_OptionDescriptors.this.get("MultiThreaded");
                    }
                    case 60: {
                        return SubstrateOptions_OptionDescriptors.this.get("Name");
                    }
                    case 61: {
                        return SubstrateOptions_OptionDescriptors.this.get("NeverInline");
                    }
                    case 62: {
                        return SubstrateOptions_OptionDescriptors.this.get("OmitInlinedMethodDebugLineInfo");
                    }
                    case 63: {
                        return SubstrateOptions_OptionDescriptors.this.get("Optimize");
                    }
                    case 64: {
                        return SubstrateOptions_OptionDescriptors.this.get("PageSize");
                    }
                    case 65: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseOnce");
                    }
                    case 66: {
                        return SubstrateOptions_OptionDescriptors.this.get("ParseRuntimeOptions");
                    }
                    case 67: {
                        return SubstrateOptions_OptionDescriptors.this.get("Path");
                    }
                    case 68: {
                        return SubstrateOptions_OptionDescriptors.this.get("PreserveFramePointer");
                    }
                    case 69: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintFlags");
                    }
                    case 70: {
                        return SubstrateOptions_OptionDescriptors.this.get("PrintFlagsWithExtraHelp");
                    }
                    case 71: {
                        return SubstrateOptions_OptionDescriptors.this.get("RemoveUnusedSymbols");
                    }
                    case 72: {
                        return SubstrateOptions_OptionDescriptors.this.get("ReportAnalysisForbiddenType");
                    }
                    case 73: {
                        return SubstrateOptions_OptionDescriptors.this.get("SharedLibrary");
                    }
                    case 74: {
                        return SubstrateOptions_OptionDescriptors.this.get("SpawnIsolates");
                    }
                    case 75: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackSize");
                    }
                    case 76: {
                        return SubstrateOptions_OptionDescriptors.this.get("StackTrace");
                    }
                    case 77: {
                        return SubstrateOptions_OptionDescriptors.this.get("StartFlightRecording");
                    }
                    case 78: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutable");
                    }
                    case 79: {
                        return SubstrateOptions_OptionDescriptors.this.get("StaticExecutableWithDynamicLibC");
                    }
                    case 80: {
                        return SubstrateOptions_OptionDescriptors.this.get("StrictQueryCodeCompilation");
                    }
                    case 81: {
                        return SubstrateOptions_OptionDescriptors.this.get("SupportCompileInIsolates");
                    }
                    case 82: {
                        return SubstrateOptions_OptionDescriptors.this.get("TargetPlatform");
                    }
                    case 83: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownFailureNanos");
                    }
                    case 84: {
                        return SubstrateOptions_OptionDescriptors.this.get("TearDownWarningNanos");
                    }
                    case 85: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceClassInitialization");
                    }
                    case 86: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceNativeToolUsage");
                    }
                    case 87: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceObjectInstantiation");
                    }
                    case 88: {
                        return SubstrateOptions_OptionDescriptors.this.get("TraceVMOperations");
                    }
                    case 89: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseCalleeSavedRegisters");
                    }
                    case 90: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseDedicatedVMOperationThread");
                    }
                    case 91: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseEpsilonGC");
                    }
                    case 92: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseLoom");
                    }
                    case 93: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseNullRegion");
                    }
                    case 94: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseReferenceHandlerThread");
                    }
                    case 95: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseRememberedSet");
                    }
                    case 96: {
                        return SubstrateOptions_OptionDescriptors.this.get("UseSerialGC");
                    }
                    case 97: {
                        return SubstrateOptions_OptionDescriptors.this.get("VerifyNamingConventions");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

