/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGeneratorRunner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.OptionValues;

public abstract class AbstractNativeImageClassLoaderSupport {
    final List<Path> imagecp;
    private final List<Path> buildcp;
    protected final URLClassLoader classPathClassLoader;

    protected AbstractNativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath) {
        String[] builderClassPathEntries;
        this.classPathClassLoader = new URLClassLoader(Util.verifyClassPathAndConvertToURLs(classpath), defaultSystemClassLoader);
        this.imagecp = Collections.unmodifiableList(Arrays.stream(this.classPathClassLoader.getURLs()).map(Util::urlToPath).collect(Collectors.toList()));
        String builderClassPathString = System.getProperty("java.class.path");
        String[] stringArray = builderClassPathEntries = builderClassPathString.isEmpty() ? new String[]{} : builderClassPathString.split(File.pathSeparator);
        if (Arrays.asList(builderClassPathEntries).contains(".")) {
            VMError.shouldNotReachHere("The classpath of " + NativeImageGeneratorRunner.class.getName() + " must not contain \".\". This can happen implicitly if the builder runs exclusively on the --module-path but specifies the " + NativeImageGeneratorRunner.class.getName() + " main class without --module.");
        }
        this.buildcp = Collections.unmodifiableList(Arrays.stream(builderClassPathEntries).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList()));
    }

    List<Path> classpath() {
        return Stream.concat(this.imagecp.stream(), this.buildcp.stream()).collect(Collectors.toList());
    }

    List<Path> applicationClassPath() {
        return this.imagecp;
    }

    public ClassLoader getClassLoader() {
        return this.classPathClassLoader;
    }

    protected abstract Class<?> loadClassFromModule(Object var1, String var2) throws ClassNotFoundException;

    protected abstract Optional<String> getMainClassFromModule(Object var1);

    protected abstract List<Path> modulepath();

    protected abstract List<Path> applicationModulePath();

    protected abstract Optional<? extends Object> findModule(String var1);

    protected abstract void processAddExportsAndAddOpens(OptionValues var1);

    protected abstract void initAllClasses(ForkJoinPool var1, ImageClassLoader var2);

    protected class ClassInit {
        protected final ForkJoinPool executor;
        protected final ImageClassLoader imageClassLoader;
        private final Set<Path> excludeDirectories = this.getExcludeDirectories();
        protected static final String CLASS_EXTENSION = ".class";

        protected ClassInit(ForkJoinPool executor, ImageClassLoader imageClassLoader) {
            this.executor = executor;
            this.imageClassLoader = imageClassLoader;
        }

        protected void init() {
            TreeSet<Path> uniquePaths = new TreeSet<Path>(Comparator.comparing(this::toRealPath));
            uniquePaths.addAll(AbstractNativeImageClassLoaderSupport.this.classpath());
            uniquePaths.parallelStream().forEach(path -> this.loadClassesFromPath((Path)path));
        }

        private Path toRealPath(Path p) {
            try {
                return p.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Path.toRealPath failed for " + p, e);
            }
        }

        private Set<Path> getExcludeDirectories() {
            Path root = Paths.get("/", new String[0]);
            return Stream.of("dev", "sys", "proc", "etc", "var", "tmp", "boot", "lost+found").map(root::resolve).collect(Collectors.toSet());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadClassesFromPath(Path path) {
            if (ClasspathUtils.isJar(path)) {
                try {
                    FileSystem probeJarFileSystem;
                    URI jarURI = new URI("jar:" + path.toAbsolutePath().toUri());
                    try {
                        probeJarFileSystem = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    }
                    catch (UnsupportedOperationException e) {
                        return;
                    }
                    if (probeJarFileSystem == null) return;
                    try (FileSystem jarFileSystem = probeJarFileSystem;){
                        this.loadClassesFromPath(jarFileSystem.getPath("/", new String[0]), Collections.emptySet());
                        return;
                    }
                }
                catch (ClosedByInterruptException ignored) {
                    throw new InterruptImageBuilding();
                }
                catch (IOException | URISyntaxException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            this.loadClassesFromPath(path, this.excludeDirectories);
        }

        private void loadClassesFromPath(final Path root, final Set<Path> excludes) {
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
                private final char fileSystemSeparatorChar;
                {
                    this.fileSystemSeparatorChar = root.getFileSystem().getSeparator().charAt(0);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (excludes.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    assert (!excludes.contains(file.getParent())) : "Visiting file '" + file + "' with excluded parent directory";
                    String fileName = root.relativize(file).toString();
                    if (fileName.endsWith(ClassInit.CLASS_EXTENSION)) {
                        ClassInit.this.executor.execute(() -> ClassInit.this.handleClassFileName(null, fileName, this.fileSystemSeparatorChar));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }

        private String strippedClassFileName(String fileName) {
            int versionedSuffixIndex;
            String versionedPrefix = "META-INF/versions/";
            String versionedSuffix = "/";
            String result = fileName;
            if (fileName.startsWith("META-INF/versions/") && (versionedSuffixIndex = fileName.indexOf("/", "META-INF/versions/".length())) >= 0) {
                result = fileName.substring(versionedSuffixIndex + "/".length());
            }
            return result.substring(0, result.length() - CLASS_EXTENSION.length());
        }

        protected void handleClassFileName(Object module, String fileName, char fileSystemSeparatorChar) {
            String strippedClassFileName = this.strippedClassFileName(fileName);
            if (strippedClassFileName.equals("module-info")) {
                return;
            }
            String className = strippedClassFileName.replace(fileSystemSeparatorChar, '.');
            Class<?> clazz = null;
            try {
                clazz = this.imageClassLoader.forName(className, module);
            }
            catch (AssertionError error) {
                VMError.shouldNotReachHere((Throwable)((Object)error));
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
            }
            if (clazz != null) {
                this.imageClassLoader.handleClass(clazz);
            }
        }
    }

    protected static class Util {
        protected Util() {
        }

        static URL[] verifyClassPathAndConvertToURLs(String[] classpath) {
            Stream<URL> pathStream = new LinkedHashSet<String>(Arrays.asList(classpath)).stream().flatMap(Util::toClassPathEntries);
            return (URL[])pathStream.map(v -> {
                try {
                    return v.toAbsolutePath().toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw UserError.abort("Invalid classpath element '%s'. Make sure that all paths provided with '%s' are correct.", v, "-imagecp");
                }
            }).toArray(URL[]::new);
        }

        static Stream<Path> toClassPathEntries(String classPathEntry) {
            Path entry = ClasspathUtils.stringToClasspath(classPathEntry);
            if (entry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
                try {
                    return Files.list(entry.getParent()).filter(ClasspathUtils::isJar);
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }
            if (Files.isReadable(entry)) {
                return Stream.of(entry);
            }
            return Stream.empty();
        }

        static Path urlToPath(URL url) {
            try {
                return Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw VMError.shouldNotReachHere();
            }
        }
    }
}

